/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.dcerpc.info;

import org.filesys.smb.NTTime;
import org.filesys.smb.SMBDate;
import org.filesys.smb.dcerpc.DCEBuffer;
import org.filesys.smb.dcerpc.DCEBufferException;
import org.filesys.smb.dcerpc.DCEReadable;

public class PerfDataBlock
implements DCEReadable {
    private int m_endian;
    private int m_version;
    private int m_revision;
    private int m_totalLen;
    private int m_headerLen;
    private int m_numObjs;
    private int m_defObj;
    private SMBDate m_sysTime;
    private long m_perfTime;
    private long m_perfFreq;
    private long m_perfFreq100Ns;
    private String m_sysName;

    @Override
    public void readObject(DCEBuffer buf) throws DCEBufferException {
        String sig = buf.getChars(4);
        if (sig.compareTo("PERF") != 0) {
            throw new DCEBufferException("Invalid perf block");
        }
        this.m_endian = buf.getInt();
        this.m_version = buf.getInt();
        this.m_revision = buf.getInt();
        this.m_totalLen = buf.getInt();
        this.m_headerLen = buf.getInt();
        this.m_numObjs = buf.getInt();
        this.m_defObj = buf.getInt();
        this.m_sysTime = NTTime.toSMBDate(buf.getLong());
        this.m_perfTime = buf.getLong();
        this.m_perfFreq = buf.getLong();
        this.m_perfFreq100Ns = buf.getLong();
        int nameLen = buf.getInt();
        buf.getInt();
        this.m_sysName = buf.getChars(nameLen / 2 - 2);
        buf.skipBytes(2);
    }

    @Override
    public void readStrings(DCEBuffer buf) throws DCEBufferException {
    }
}

