/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.dcerpc.info;

import org.filesys.smb.dcerpc.DCEBuffer;
import org.filesys.smb.dcerpc.DCEBufferException;
import org.filesys.smb.dcerpc.DCEReadable;
import org.filesys.smb.dcerpc.client.RegistryType;
import org.filesys.util.DataPacker;
import org.filesys.util.HexDump;
import org.filesys.util.StringList;

public class RegistryValue
implements DCEReadable {
    private byte[] m_rawValue;
    private String m_regName;
    private int m_regType;

    public RegistryValue() {
    }

    public RegistryValue(String name) {
        this.m_regName = name;
    }

    public RegistryValue(String name, int typ, byte[] value) {
        this.m_regName = name;
        this.m_regType = typ;
        this.m_rawValue = value;
    }

    public RegistryValue(String name, String value) {
        this.m_regName = name;
        this.m_regType = 1;
        this.m_rawValue = new byte[value.length() * 2 + 2];
        DataPacker.putUnicodeString(value, this.m_rawValue, 0, true);
    }

    public RegistryValue(String name, int value) {
        this.m_regName = name;
        this.m_regType = 4;
        this.m_rawValue = new byte[4];
        DataPacker.putIntelInt(value, this.m_rawValue, 0);
    }

    public final byte[] getRawValue() {
        return this.m_rawValue;
    }

    public final Object getValue() {
        if (this.getRawValue() == null) {
            return null;
        }
        byte[] buf = this.getRawValue();
        Object objVal = null;
        switch (this.getDataType()) {
            case 1: {
                objVal = DataPacker.getUnicodeString(buf, 0, buf.length / 2);
                break;
            }
            case 2: {
                if (buf.length <= 2) {
                    objVal = "";
                    break;
                }
                objVal = DataPacker.getUnicodeString(buf, 0, buf.length / 2 - 1);
                break;
            }
            case 4: {
                objVal = new Integer(DataPacker.getIntelInt(buf, 0));
                break;
            }
            case 7: {
                objVal = this.unpackMultiSz();
                break;
            }
            default: {
                objVal = buf;
            }
        }
        return objVal;
    }

    public final String getName() {
        return this.m_regName;
    }

    public final int getDataType() {
        return this.m_regType;
    }

    public final String getDataTypeString() {
        return RegistryType.getTypeAsString(this.m_regType);
    }

    public void readValue(DCEBuffer buf) throws DCEBufferException {
        if (buf.getPointer() != 0) {
            this.m_regType = buf.getInt();
        }
        if (buf.getPointer() != 0) {
            this.m_rawValue = buf.getDataBlock(1);
        }
        if (buf.getPointer() != 0) {
            buf.skipBytes(4);
        }
        if (buf.getPointer() != 0) {
            buf.skipBytes(4);
        }
    }

    @Override
    public void readObject(DCEBuffer buf) throws DCEBufferException {
        int len = buf.getUnicodeHeaderLength();
        if (len > 0) {
            this.m_regName = buf.getString();
        }
        if (buf.getPointer() != 0) {
            this.m_regType = buf.getInt() & 0xFF;
        }
        if (buf.getPointer() != 0) {
            this.m_rawValue = buf.getDataBlock(1);
        }
        if (buf.getPointer() != 0) {
            buf.skipBytes(4);
        }
        if (buf.getPointer() != 0) {
            buf.skipBytes(4);
        }
    }

    @Override
    public void readStrings(DCEBuffer buf) throws DCEBufferException {
    }

    private final StringList unpackMultiSz() {
        StringList strList = new StringList();
        if (this.getRawValue() == null || this.getRawValue().length == 0) {
            return strList;
        }
        StringBuffer buf = new StringBuffer(256);
        for (int i = 0; i < this.m_rawValue.length; i += 2) {
            char ch = (char)(this.m_rawValue[i] + (this.m_rawValue[i + 1] << 8));
            if (ch == '\u0000') {
                strList.addString(buf.toString());
                buf.setLength(0);
                continue;
            }
            buf.append(ch);
        }
        return strList;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(this.getName());
        str.append(":");
        str.append(this.getDataTypeString());
        str.append(":");
        if (this.getValue() != null) {
            if (this.getDataType() == 1 || this.getDataType() == 4 || this.getDataType() == 7 || this.getDataType() == 2) {
                str.append(this.getValue());
            } else {
                str.append(HexDump.hexString((byte[])this.getValue()));
            }
        }
        str.append("]");
        return str.toString();
    }
}

