/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.nt;

public class WellKnownRID {
    public static final int DomainUserAdmin = 500;
    public static final int DomainUserGuest = 501;
    public static final int DomainUserKrbtgt = 502;
    public static final int DomainGroupAdmins = 512;
    public static final int DomainGroupUsers = 513;
    public static final int DomainGroupGuests = 514;
    public static final int DomainGroupComputers = 515;
    public static final int DomainGroupControllers = 516;
    public static final int DomainGroupCertAdmins = 517;
    public static final int DomainGroupSchemaAdmins = 518;
    public static final int DomainAliasAdmins = 544;
    public static final int DomainAliasUsers = 545;
    public static final int DomainAliasGuests = 546;
    public static final int DomainAliasPowerUsers = 547;
    public static final int DomainAliasAccountOps = 548;
    public static final int DomainAliasSystemOps = 549;
    public static final int DomainAliasPrintOps = 550;
    public static final int DomainAliasBackupOps = 551;
    public static final int DomainAliasReplicator = 552;

    public static final boolean isWellKnownUser(int id) {
        return id >= 500 && id <= 502;
    }

    public static final boolean isWellKnownGroup(int id) {
        return id >= 512 && id <= 518;
    }

    public static final boolean isWellKnownAlias(int id) {
        return id >= 544 && id <= 552;
    }

    public static final String getWellKnownUserName(int id) {
        String ret = null;
        switch (id) {
            case 500: {
                ret = "Administrator";
                break;
            }
            case 501: {
                ret = "Guest";
                break;
            }
            case 502: {
                ret = "Krbtgt";
            }
        }
        return ret;
    }

    public static final String getWellKnownGroupName(int id) {
        String ret = null;
        switch (id) {
            case 512: {
                ret = "Administrators";
                break;
            }
            case 513: {
                ret = "Users";
                break;
            }
            case 514: {
                ret = "Guests";
                break;
            }
            case 515: {
                ret = "Computers";
                break;
            }
            case 516: {
                ret = "Controllers";
                break;
            }
            case 517: {
                ret = "CertificatePublishers";
                break;
            }
            case 518: {
                ret = "SchemaAdministrators";
            }
        }
        return ret;
    }

    public static final String getWellKnownAliasName(int id) {
        String ret = null;
        switch (id) {
            case 544: {
                ret = "Administrators";
                break;
            }
            case 545: {
                ret = "Users";
                break;
            }
            case 546: {
                ret = "Guests";
                break;
            }
            case 547: {
                ret = "PowerUsers";
                break;
            }
            case 548: {
                ret = "AccountOps";
                break;
            }
            case 549: {
                ret = "SystemOps";
                break;
            }
            case 550: {
                ret = "PrintOps";
                break;
            }
            case 551: {
                ret = "BackupOps";
                break;
            }
            case 552: {
                ret = "Replicator";
            }
        }
        return ret;
    }
}

