/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.server;

import org.filesys.server.filesys.DiskInfo;
import org.filesys.server.filesys.SrvDiskInfo;
import org.filesys.server.filesys.VolumeInfo;
import org.filesys.smb.NTTime;
import org.filesys.util.DataBuffer;
import org.filesys.util.DataPacker;

public class DiskInfoPacker {
    public static final int InfoStandard = 1;
    public static final int InfoVolume = 2;
    public static final int InfoFsVolume = 258;
    public static final int InfoFsSize = 259;
    public static final int InfoFsDevice = 260;
    public static final int InfoFsAttribute = 261;
    public static final int InfoCifsUnix = 512;
    public static final int InfoMacFsInfo = 769;
    public static final int InfoFullFsSize = 1007;
    public static final int MacAccessControl = 16;
    public static final int MacGetSetComments = 32;
    public static final int MacDesktopDbCalls = 64;
    public static final int MacUniqueIds = 128;
    public static final int MacNoStreamsOrMacSupport = 256;

    public static final void packStandardInfo(DiskInfo info, DataBuffer buf) {
        buf.putZeros(4);
        buf.putInt(info.getBlocksPerAllocationUnit());
        buf.putInt((int)info.getTotalUnits());
        buf.putInt((int)info.getFreeUnits());
        buf.putShort(info.getBlockSize());
    }

    public static final void packVolumeInfo(VolumeInfo info, DataBuffer buf, boolean uni) {
        buf.putInt(info.getSerialNumber());
        buf.putByte(info.getVolumeLabel().length());
        buf.putString(info.getVolumeLabel(), uni);
    }

    public static final void packFsSizeInformation(SrvDiskInfo info, DataBuffer buf) {
        buf.putLong(info.getTotalUnits());
        buf.putLong(info.getFreeUnits());
        buf.putInt(info.getBlocksPerAllocationUnit());
        buf.putInt(info.getBlockSize());
    }

    public static final void packFsVolumeInformation(VolumeInfo info, DataBuffer buf, boolean uni) {
        if (info.hasCreationDateTime()) {
            buf.putLong(NTTime.toNTTime(info.getCreationDateTime()));
        } else {
            buf.putZeros(8);
        }
        if (info.hasSerialNumber()) {
            buf.putInt(info.getSerialNumber());
        } else {
            buf.putZeros(4);
        }
        int len = info.getVolumeLabel().length();
        if (uni) {
            len *= 2;
        }
        buf.putInt(len);
        buf.putZeros(2);
        buf.putString(info.getVolumeLabel(), uni, false);
    }

    public static final void packFsDevice(int typ, int devChar, DataBuffer buf) {
        buf.putInt(typ);
        buf.putInt(devChar);
    }

    public static final void packFsAttribute(int attr, int maxName, String fsType, boolean uni, DataBuffer buf) {
        buf.putInt(attr);
        buf.putInt(maxName);
        if (uni) {
            buf.putInt(fsType.length() * 2);
        } else {
            buf.putInt(fsType.length());
        }
        buf.putString(fsType, uni, false);
    }

    public static final void packMacFsInformation(DiskInfo diskInfo, VolumeInfo volInfo, boolean ntfs, DataBuffer buf) {
        if (volInfo.hasCreationDateTime()) {
            long ntTime = NTTime.toNTTime(volInfo.getCreationDateTime());
            buf.putLong(ntTime);
            buf.putLong(ntTime);
            buf.putLong(ntTime);
        } else {
            buf.putZeros(24);
        }
        buf.putInt((int)diskInfo.getTotalUnits());
        buf.putInt(diskInfo.getBlockSize() * diskInfo.getBlocksPerAllocationUnit());
        buf.putInt((int)diskInfo.getFreeUnits());
        buf.putZeros(32);
        buf.putInt(0);
        buf.putInt(0);
        buf.putInt(0);
        buf.putInt(0);
        DataPacker.putIntelInt(ntfs ? 0 : 256, buf.getBuffer(), buf.getPosition());
        buf.setPosition(buf.getPosition() + 4);
    }

    public static final void packFullFsSizeInformation(long userTotalSpace, long userLimit, SrvDiskInfo info, DataBuffer buf) {
        buf.putLong(userTotalSpace);
        buf.putLong(userLimit);
        buf.putLong(info.getFreeUnits());
        buf.putInt(info.getBlocksPerAllocationUnit());
        buf.putInt(info.getBlockSize());
    }
}

