/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.server;

import java.util.HashMap;
import org.filesys.smb.server.CoreProtocolHandler;
import org.filesys.smb.server.LanManProtocolHandler;
import org.filesys.smb.server.NTProtocolHandler;
import org.filesys.smb.server.ProtocolHandler;

public class ProtocolFactory {
    private static HashMap<Integer, Class> _handlerMap = new HashMap(16);

    private ProtocolFactory() {
    }

    protected static ProtocolHandler getHandler(int dialect) {
        if (_handlerMap == null) {
            return null;
        }
        Class handlerClass = _handlerMap.get(dialect);
        if (handlerClass != null) {
            try {
                ProtocolHandler protocolHandler = (ProtocolHandler)handlerClass.newInstance();
                return protocolHandler;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static void addHandlerClass(int dialect, Class handlerClass) {
        try {
            if (handlerClass == null || !(handlerClass.newInstance() instanceof ProtocolHandler)) {
                throw new RuntimeException("Invalid protocol handler class");
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Error checking handler class type");
        }
        if (_handlerMap == null) {
            throw new RuntimeException("Invalid protocol handler map");
        }
        _handlerMap.put(dialect, handlerClass);
    }

    static {
        Class<CoreProtocolHandler> handlerClass = CoreProtocolHandler.class;
        ProtocolFactory.addHandlerClass(0, handlerClass);
        ProtocolFactory.addHandlerClass(1, handlerClass);
        handlerClass = LanManProtocolHandler.class;
        ProtocolFactory.addHandlerClass(2, handlerClass);
        ProtocolFactory.addHandlerClass(4, handlerClass);
        ProtocolFactory.addHandlerClass(3, handlerClass);
        ProtocolFactory.addHandlerClass(5, handlerClass);
        ProtocolFactory.addHandlerClass(6, handlerClass);
        ProtocolFactory.addHandlerClass(7, NTProtocolHandler.class);
    }
}

