/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.server;

import java.io.IOException;
import org.filesys.audit.AuditType;
import org.filesys.server.RequestPostProcessor;
import org.filesys.server.SrvSession;
import org.filesys.server.auth.ClientInfo;
import org.filesys.server.auth.ISMBAuthenticator;
import org.filesys.server.core.NoPooledMemoryException;
import org.filesys.server.filesys.DiskDeviceContext;
import org.filesys.server.filesys.DiskInterface;
import org.filesys.server.filesys.DiskSizeInterface;
import org.filesys.server.filesys.DiskVolumeInterface;
import org.filesys.server.filesys.SrvDiskInfo;
import org.filesys.server.filesys.TooManyConnectionsException;
import org.filesys.server.filesys.VolumeInfo;
import org.filesys.server.locking.LocalOpLockDetails;
import org.filesys.smb.server.NegotiateContext;
import org.filesys.smb.server.SMBServer;
import org.filesys.smb.server.SMBSrvException;
import org.filesys.smb.server.SMBSrvPacket;
import org.filesys.smb.server.SMBSrvSession;
import org.filesys.smb.server.SMBV1VirtualCircuitList;
import org.filesys.smb.server.VirtualCircuit;
import org.filesys.smb.server.VirtualCircuitList;
import org.filesys.smb.server.notify.NotifyChangeEvent;
import org.filesys.smb.server.notify.NotifyRequest;

public abstract class ProtocolHandler {
    private static final int NegotiateResponseLength = 4096;
    protected SMBSrvSession m_sess;
    protected int m_dialect = -1;
    protected int m_srvCapabilites;

    protected ProtocolHandler() {
    }

    protected ProtocolHandler(SMBSrvSession sess) {
        this.m_sess = sess;
    }

    public void initialize(SMBServer smbServer, SMBSrvSession smbSession, int dialect) {
        this.setSession(smbSession);
        this.setDialect(dialect);
    }

    public abstract String getName();

    public abstract boolean runProtocol(SMBSrvPacket var1) throws IOException, SMBSrvException, TooManyConnectionsException;

    protected final SMBSrvSession getSession() {
        return this.m_sess;
    }

    protected final void setSession(SMBSrvSession sess) {
        this.m_sess = sess;
    }

    public final int getDialect() {
        return this.m_dialect;
    }

    protected final void setDialect(int dialect) {
        this.m_dialect = dialect;
    }

    public final int getServerCapabilities() {
        return this.m_srvCapabilites;
    }

    public SMBSrvPacket buildChangeNotificationResponse(NotifyChangeEvent evt, NotifyRequest req) {
        return null;
    }

    public SMBSrvPacket buildOpLockBreakResponse(LocalOpLockDetails oplock) {
        return null;
    }

    protected final void setServerCapabilities(int srvCapab) {
        this.m_srvCapabilites = srvCapab;
    }

    public SMBSrvPacket postProcessNegotiate(SMBSrvPacket smbPkt, NegotiateContext negCtx) throws SMBSrvException {
        SMBSrvPacket respPkt = smbPkt;
        if (respPkt.getBufferLength() < 4096) {
            try {
                respPkt = this.m_sess.getPacketPool().allocatePacket(4096, smbPkt);
            }
            catch (NoPooledMemoryException noPooledMemoryException) {
                // empty catch block
            }
        }
        return respPkt;
    }

    protected final SrvDiskInfo getDiskInformation(DiskInterface disk, DiskDeviceContext ctx) throws IOException {
        SrvDiskInfo diskInfo = ctx.getDiskInformation();
        if (diskInfo == null) {
            diskInfo = new SrvDiskInfo();
        }
        if (disk instanceof DiskSizeInterface) {
            DiskSizeInterface sizeInterface = (DiskSizeInterface)((Object)disk);
            sizeInterface.getDiskInformation(ctx, diskInfo);
        }
        return diskInfo;
    }

    protected final VolumeInfo getVolumeInformation(DiskInterface disk, DiskDeviceContext ctx) {
        VolumeInfo volInfo = ctx.getVolumeInformation();
        if (disk instanceof DiskVolumeInterface) {
            DiskVolumeInterface volInterface = (DiskVolumeInterface)((Object)disk);
            volInfo = volInterface.getVolumeInformation(ctx);
        }
        if (volInfo == null) {
            volInfo = new VolumeInfo("");
        }
        return volInfo;
    }

    protected final void runRequestPostProcessors(SrvSession sess) {
        while (sess.hasPostProcessorRequests()) {
            try {
                RequestPostProcessor postProc = sess.getNextPostProcessor();
                postProc.runProcessor();
            }
            catch (Throwable throwable) {}
        }
    }

    protected final ISMBAuthenticator.ShareStatus asShareStatus(int aclPerm) {
        ISMBAuthenticator.ShareStatus sharePerm = ISMBAuthenticator.ShareStatus.NO_ACCESS;
        switch (aclPerm) {
            case 1: {
                sharePerm = ISMBAuthenticator.ShareStatus.READ_ONLY;
                break;
            }
            case 2: {
                sharePerm = ISMBAuthenticator.ShareStatus.WRITEABLE;
            }
        }
        return sharePerm;
    }

    public void hangupSession(SMBSrvSession sess, String reason) {
    }

    public void socketClosed(SMBSrvSession sess) {
    }

    public void virtualCircuitClosed(VirtualCircuit vc, SMBSrvSession sess) {
    }

    public void sessionDisconnected(SMBSrvSession sess) {
    }

    public void sessionReconnected(SMBSrvSession sess) {
    }

    public VirtualCircuitList createVirtualCircuitList(int maxVC) {
        return new SMBV1VirtualCircuitList(maxVC);
    }

    public void auditPrintln(AuditType auditTyp, ClientInfo client, String detail) {
    }
}

