/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.server;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Random;
import org.filesys.debug.Debug;
import org.filesys.netbios.server.LANAMonitor;
import org.filesys.server.SrvSession;
import org.filesys.server.SrvSessionList;
import org.filesys.server.Version;
import org.filesys.server.auth.ISMBAuthenticator;
import org.filesys.server.config.ConfigurationListener;
import org.filesys.server.config.CoreServerConfigSection;
import org.filesys.server.config.InvalidConfigurationException;
import org.filesys.server.config.ServerConfiguration;
import org.filesys.server.core.InvalidDeviceInterfaceException;
import org.filesys.server.core.ShareType;
import org.filesys.server.core.SharedDevice;
import org.filesys.server.filesys.DiskInterface;
import org.filesys.server.filesys.NetworkFileServer;
import org.filesys.server.thread.ThreadRequestPool;
import org.filesys.server.thread.TimedThreadRequest;
import org.filesys.smb.DialectSelector;
import org.filesys.smb.dcerpc.UUID;
import org.filesys.smb.server.AdminSharedDevice;
import org.filesys.smb.server.SMBConfigSection;
import org.filesys.smb.server.SMBConnectionsHandler;
import org.filesys.smb.server.SMBPacketPool;
import org.filesys.smb.server.SMBSrvSession;
import org.filesys.smb.server.ThreadedSMBConnectionsHandler;
import org.filesys.smb.server.VirtualCircuit;
import org.filesys.smb.server.nio.NIOSMBConnectionsHandler;
import org.filesys.util.PlatformType;

public class SMBServer
extends NetworkFileServer
implements Runnable,
ConfigurationListener {
    private static final String ServerVersion = Version.SMBServerVersion;
    public static final int SMBNetBIOSNamesAdded = 100;
    private static final long SMBDisconnectExpiryTime = 300000L;
    private static final long SMBDisconnectExpiryCheckSecs = 30L;
    private SMBConfigSection m_smbConfig;
    private CoreServerConfigSection m_coreConfig;
    private Thread m_srvThread;
    private SMBConnectionsHandler m_connectionsHandler;
    private SrvSessionList m_sessions;
    private SrvSessionList m_disconnectedSessList;
    private int m_srvType = 3;
    private UUID m_serverGUID;
    private SMBPacketPool m_packetPool;
    private LANAMonitor m_lanaMonitor;

    public SMBServer(ServerConfiguration cfg) throws Exception {
        super("SMB", cfg);
        this.CommonConstructor();
    }

    public final void addSession(SMBSrvSession sess) {
        this.m_sessions.addSession(sess);
        sess.setDisconnectedAt(0L);
        if (this.hasDebug()) {
            sess.setDebug(this.getSMBConfiguration().getSessionDebugFlags());
        }
    }

    protected final void checkReadOnly(SharedDevice shr) {
        block10: {
            if (shr.getType() == ShareType.DISK) {
                try {
                    DiskInterface disk = (DiskInterface)shr.getInterface();
                    if (disk.isReadOnly(null, shr.getContext())) {
                        int attr = shr.getAttributes();
                        if ((attr & 4) == 0) {
                            attr += 4;
                        }
                        shr.setAttributes(attr);
                        if (this.hasDebug()) {
                            Debug.println("[SMB] Add Share " + shr.toString() + " : isReadOnly");
                        }
                    }
                }
                catch (InvalidDeviceInterfaceException ex) {
                    if (this.hasDebug()) {
                        Debug.println("[SMB] Add Share " + shr.toString() + " : " + ex.toString());
                    }
                }
                catch (FileNotFoundException ex) {
                    if (this.hasDebug()) {
                        Debug.println("[SMB] Add Share " + shr.toString() + " : " + ex.toString());
                    }
                }
                catch (IOException ex) {
                    if (!this.hasDebug()) break block10;
                    Debug.println("[SMB] Add Share " + shr.toString() + " : " + ex.toString());
                }
            }
        }
    }

    protected void CommonConstructor() throws Exception {
        this.m_smbConfig = (SMBConfigSection)this.getConfiguration().getConfigSection("SMB");
        if (this.m_smbConfig != null) {
            this.getConfiguration().addListener(this);
            if (!this.getSMBConfiguration().getSessionDebugFlags().isEmpty()) {
                this.setDebug(true);
            }
            this.setVersion(ServerVersion);
            this.m_sessions = new SrvSessionList();
            SMBSrvSession.getFactory().setMaximumVirtualCircuits(this.m_smbConfig.getMaximumVirtualCircuits());
            this.m_coreConfig = (CoreServerConfigSection)this.getConfiguration().getConfigSection("CoreServer");
            if (this.m_coreConfig != null) {
                this.m_packetPool = new SMBPacketPool(this.m_coreConfig.getMemoryPool(), this.m_coreConfig.getThreadPool());
                this.m_packetPool.setMaximumOverSizedAllocation(this.m_coreConfig.getMaximumOversizedPacket());
                if (this.m_smbConfig.getSessionDebugFlags().contains((Object)SMBSrvSession.Dbg.PKTPOOL)) {
                    this.m_packetPool.setDebug(true);
                }
                if (this.m_smbConfig.getSessionDebugFlags().contains((Object)SMBSrvSession.Dbg.PKTALLOC)) {
                    this.m_packetPool.setAllocateDebug(true);
                }
            }
        } else {
            this.setEnabled(false);
        }
    }

    public final void deleteTemporaryShares(SMBSrvSession sess) {
        this.getShareMapper().deleteShares(sess);
    }

    public final SMBConfigSection getSMBConfiguration() {
        return this.m_smbConfig;
    }

    public final String getComment() {
        return this.getSMBConfiguration().getComment();
    }

    public final String getServerName() {
        return this.getSMBConfiguration().getServerName();
    }

    public final int getServerType() {
        return this.m_srvType;
    }

    public final EnumSet<SMBSrvSession.Dbg> getSessionDebug() {
        return this.getSMBConfiguration().getSessionDebugFlags();
    }

    public final DialectSelector getSMBDialects() {
        return this.getSMBConfiguration().getEnabledDialects();
    }

    public final ISMBAuthenticator getSMBAuthenticator() {
        return this.getSMBConfiguration().getAuthenticator();
    }

    public final SrvSessionList getSessions() {
        return this.m_sessions;
    }

    public int getCurrentSessionCount() {
        return this.m_sessions.numberOfSessions();
    }

    public int getDisconnectedSessionCount() {
        if (this.m_disconnectedSessList != null) {
            return this.m_disconnectedSessList.numberOfSessions();
        }
        return 0;
    }

    public int getMaximumSessionCount() {
        return 0;
    }

    public final SMBPacketPool getPacketPool() {
        return this.m_packetPool;
    }

    public final ThreadRequestPool getThreadPool() {
        return this.m_coreConfig.getThreadPool();
    }

    public final LANAMonitor getLANAMonitor() {
        return this.m_lanaMonitor;
    }

    public final void setLANAMonitor(LANAMonitor lanaMonitor) {
        this.m_lanaMonitor = lanaMonitor;
    }

    @Override
    public void run() {
        boolean isWindows;
        block22: {
            this.fireServerEvent(0);
            this.setActive(true);
            isWindows = PlatformType.isWindowsNTOnwards();
            Random r = new Random();
            this.m_serverGUID = new UUID(r.nextLong(), r.nextLong());
            if (this.hasDebug()) {
                Debug.println("[SMB] SMB Server " + this.getServerName() + " starting");
                Debug.print("[SMB] Version " + this.isVersion());
                Debug.print(", Java VM " + System.getProperty("java.vm.version"));
                Debug.println(", OS " + System.getProperty("os.name") + ", version " + System.getProperty("os.version"));
                if (this.getSMBConfiguration().hasAliasNames()) {
                    Debug.println("[SMB] Server alias(es) : " + this.getSMBConfiguration().getAliasNames());
                }
                if (this.getSMBAuthenticator() != null) {
                    Debug.println("[SMB] Using authenticator " + this.getSMBAuthenticator().toString());
                }
                if (this.getGlobalConfiguration().getTimeZone() != null) {
                    Debug.println("[SMB] Server timezone " + this.getGlobalConfiguration().getTimeZone() + ", offset from UTC = " + this.getGlobalConfiguration().getTimeZoneOffset() / 60 + "hrs");
                } else {
                    Debug.println("[SMB] Server timezone offset = " + this.getGlobalConfiguration().getTimeZoneOffset() / 60 + "hrs");
                }
                Debug.println("[SMB] Dialects enabled = " + this.getSMBDialects());
                Debug.println("[SMB] Shares:");
                Enumeration<SharedDevice> enm = this.getFullShareList(this.getSMBConfiguration().getServerName(), null).enumerateShares();
                while (enm.hasMoreElements()) {
                    SharedDevice share = enm.nextElement();
                    Debug.println("[SMB]  " + share.toString() + " " + (share.getContext() != null ? share.getContext().toString() : ""));
                }
            }
            try {
                AdminSharedDevice admShare = new AdminSharedDevice();
                this.getFilesystemConfiguration().addShare(admShare);
                this.setShutdown(false);
                this.getServerIPAddresses();
                if (this.getSMBConfiguration().getEnabledDialects().hasDialect(7)) {
                    this.getSMBConfiguration().setServerType(this.getServerType() + 4096);
                    if (this.hasDebug()) {
                        Debug.println("[SMB] Added NTServer flag to host announcement");
                    }
                }
                if (this.getSMBConfiguration().hasDisableNIOCode() || this.getSMBConfiguration().hasWin32NetBIOS()) {
                    this.m_connectionsHandler = new ThreadedSMBConnectionsHandler();
                } else if (this.getSMBConfiguration().hasTcpipSMB() || this.getSMBConfiguration().hasNetBIOSSMB()) {
                    this.m_connectionsHandler = new NIOSMBConnectionsHandler();
                }
                this.m_connectionsHandler.initializeHandler(this, this.getSMBConfiguration());
                this.m_connectionsHandler.startHandler();
                if (this.m_connectionsHandler.numberOfSessionHandlers() > 0 || this.getSMBConfiguration().hasWin32NetBIOS()) {
                    this.fireServerEvent(1);
                    while (!this.hasShutdown()) {
                        try {
                            Thread.sleep(3000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                } else if (this.hasDebug()) {
                    Debug.println("[SMB] No valid session handlers, server closing");
                }
            }
            catch (Exception ex) {
                if (this.hasShutdown()) break block22;
                Debug.println("[SMB] Server error : " + ex.toString(), 1);
                Debug.println(ex);
                this.setException(ex);
                this.fireServerEvent(3);
            }
        }
        if (this.hasDebug()) {
            Debug.println("[SMB] SMB Server shutting down ...");
            this.dumpSessionLists(true);
        }
        this.m_connectionsHandler.stopHandler();
        if (isWindows && this.getLANAMonitor() != null) {
            this.getLANAMonitor().shutdownRequest();
        }
        this.setActive(false);
        this.fireServerEvent(2);
        if (this.hasDebug()) {
            Debug.println("[SMB] Packet pool at shutdown: " + this.getPacketPool());
        }
    }

    protected final void sessionClosed(SMBSrvSession sess) {
        this.m_sessions.removeSession(sess);
        if (this.hasDebug()) {
            Debug.println("[SMB] Closed session " + sess.getSessionId() + ", sessions=" + this.m_sessions.numberOfSessions());
            if (this.m_sessions.numberOfSessions() > 0 && this.m_sessions.numberOfSessions() <= 10) {
                Enumeration<SrvSession> sessions = this.m_sessions.enumerateSessions();
                Debug.print("      Active sessions [");
                while (sessions.hasMoreElements()) {
                    SMBSrvSession curSess = (SMBSrvSession)sessions.nextElement();
                    InetAddress addr = curSess.getRemoteAddress();
                    Debug.print("" + curSess.getSessionId() + "=" + (addr != null ? addr.getHostAddress() : "unknown") + ",");
                }
                Debug.println("]");
            }
        }
        this.fireSessionClosedEvent(sess);
    }

    protected final void sessionLoggedOn(SMBSrvSession sess) {
        this.fireSessionLoggedOnEvent(sess);
    }

    protected final void sessionOpened(SMBSrvSession sess) {
        this.fireSessionOpenEvent(sess);
    }

    @Override
    public final void shutdownServer(boolean immediate) {
        SMBSrvSession sess;
        this.setShutdown(true);
        try {
            this.m_srvThread.interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Enumeration<SrvSession> enm = this.m_sessions.enumerateSessions();
        while (enm.hasMoreElements()) {
            sess = (SMBSrvSession)enm.nextElement();
            this.fireSessionClosedEvent(sess);
            sess.closeSession();
        }
        if (this.hasDisconnectedSessions()) {
            if (this.hasDebug()) {
                Debug.println("[SMB] Disconnected sessions=" + this.m_disconnectedSessList.numberOfSessions());
            }
            enm = this.m_disconnectedSessList.enumerateSessions();
            while (enm.hasMoreElements()) {
                sess = (SMBSrvSession)enm.nextElement();
                this.fireSessionClosedEvent(sess);
                sess.closeSession();
            }
        }
        if (this.m_srvThread != null) {
            try {
                this.m_srvThread.join(3000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.fireServerEvent(2);
    }

    @Override
    public void startServer() {
        this.m_srvThread = new Thread(this);
        this.m_srvThread.setName("SMB Server");
        this.m_srvThread.start();
    }

    @Override
    public void dumpSessionLists(boolean verbose) {
        SrvSession curSess;
        Enumeration<SrvSession> sessEnum;
        Debug.println("[SMB] Open sessions: " + this.m_sessions.numberOfSessions());
        if (this.m_sessions.numberOfSessions() > 0) {
            sessEnum = this.m_sessions.enumerateSessions();
            while (sessEnum.hasMoreElements()) {
                curSess = sessEnum.nextElement();
                if (curSess == null || !(curSess instanceof SMBSrvSession)) continue;
                SMBSrvSession smbSess = (SMBSrvSession)curSess;
                Debug.println("[SMB]  Open session: " + smbSess.toString());
                if (!verbose || smbSess.getVirtualCircuitList() == null) continue;
                Iterator<VirtualCircuit> vcIter = smbSess.getVirtualCircuitList().iterator();
                while (vcIter.hasNext()) {
                    Debug.println("         VC=" + vcIter.next());
                }
            }
        }
        if (this.m_disconnectedSessList != null) {
            Debug.println("[SMB] Disconnected sessions: " + this.m_disconnectedSessList.numberOfSessions());
            if (this.m_disconnectedSessList.numberOfSessions() > 0) {
                sessEnum = this.m_disconnectedSessList.enumerateSessions();
                while (sessEnum.hasMoreElements()) {
                    curSess = sessEnum.nextElement();
                    if (curSess == null) continue;
                    Debug.println("[SMB]  Disconnected session: " + curSess.toString());
                }
            }
        }
    }

    @Override
    public int configurationChanged(int id, ServerConfiguration config, Object newVal) throws InvalidConfigurationException {
        int sts = 0;
        try {
            switch (id) {
                case 65537: {
                    Boolean enaSMB = (Boolean)newVal;
                    if (this.isActive() && !enaSMB.booleanValue()) {
                        this.shutdownServer(false);
                    } else if (!this.isActive() && enaSMB.booleanValue()) {
                        this.startServer();
                    }
                    sts = 1;
                    break;
                }
                case 65540: 
                case 65541: 
                case 131076: 
                case 131081: 
                case 131082: 
                case 131086: 
                case 131088: 
                case 393217: 
                case 393218: 
                case 458753: 
                case 524289: 
                case 589825: {
                    sts = 1;
                    break;
                }
                case 131087: {
                    sts = 2;
                    if (!(newVal instanceof Integer)) break;
                    Integer dbgVal = (Integer)newVal;
                    this.setDebug(dbgVal != 0);
                    break;
                }
                case 131101: {
                    sts = 2;
                    if (!(newVal instanceof Integer)) break;
                    Integer maxVC = (Integer)newVal;
                    SMBSrvSession.getFactory().setMaximumVirtualCircuits(maxVC);
                    break;
                }
                case 131073: 
                case 131074: 
                case 131077: 
                case 131078: 
                case 131079: 
                case 131080: 
                case 131084: 
                case 131085: 
                case 131089: {
                    sts = 3;
                }
            }
        }
        catch (Exception ex) {
            throw new InvalidConfigurationException("SMB Server configuration error", ex);
        }
        return sts;
    }

    private final void getServerIPAddresses() {
        block6: {
            try {
                Enumeration<NetworkInterface> enm = NetworkInterface.getNetworkInterfaces();
                ArrayList<InetAddress> addrList = new ArrayList<InetAddress>();
                while (enm.hasMoreElements()) {
                    NetworkInterface ni = enm.nextElement();
                    Enumeration<InetAddress> addrs = ni.getInetAddresses();
                    while (addrs.hasMoreElements()) {
                        addrList.add(addrs.nextElement());
                    }
                }
                if (addrList.size() > 0) {
                    InetAddress[] inetAddrs = new InetAddress[addrList.size()];
                    for (int i = 0; i < addrList.size(); ++i) {
                        inetAddrs[i] = (InetAddress)addrList.get(i);
                    }
                    this.setServerAddresses(inetAddrs);
                }
            }
            catch (Exception ex) {
                if (!this.hasDebug()) break block6;
                Debug.println("[SMB] Error getting local IP addresses, " + ex.toString());
            }
        }
    }

    public final UUID getServerGUID() {
        return this.m_serverGUID;
    }

    public final void fireNetBIOSNamesAddedEvent(int lana) {
        this.fireServerEvent(100 + (lana << 16));
    }

    public final boolean hasDisconnectedSessions() {
        if (this.m_disconnectedSessList == null) {
            return false;
        }
        return this.m_disconnectedSessList.numberOfSessions() > 0;
    }

    public final synchronized SMBSrvSession restoreDisconnectedSession(int sessId) {
        if (this.m_disconnectedSessList == null) {
            return null;
        }
        return (SMBSrvSession)this.m_disconnectedSessList.removeSession(sessId);
    }

    public final synchronized SMBSrvSession findActiveSession(int sessId) {
        SMBSrvSession sess = (SMBSrvSession)this.m_sessions.findSession(sessId);
        if (sess != null && sess.isPersistentSession()) {
            this.m_sessions.removeSession(sessId);
        } else {
            sess = null;
        }
        return sess;
    }

    public final synchronized void addDisconnectedSession(SMBSrvSession sess) {
        if (this.m_disconnectedSessList == null) {
            this.m_disconnectedSessList = new SrvSessionList();
            this.getThreadPool().queueTimedRequest(new SMBDisconnectedSessionTimedRequest());
        }
        sess.setDisconnectedAt(System.currentTimeMillis());
        this.m_disconnectedSessList.addSession(sess);
        sess.sessionDisconnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkForExpiredSessions() {
        if (this.m_disconnectedSessList == null || this.m_disconnectedSessList.numberOfSessions() == 0) {
            return;
        }
        SrvSessionList srvSessionList = this.m_disconnectedSessList;
        synchronized (srvSessionList) {
            Enumeration<SrvSession> enm = this.m_disconnectedSessList.enumerateSessions();
            long timeNow = System.currentTimeMillis();
            while (enm.hasMoreElements()) {
                SMBSrvSession curSess = (SMBSrvSession)enm.nextElement();
                if (curSess != null && curSess.isDisconnectedSession()) {
                    if (curSess.getDisconnectedAt() + 300000L >= timeNow) continue;
                    this.m_disconnectedSessList.removeSession(curSess.getSessionId());
                    if (this.getSessionDebug().contains((Object)SMBSrvSession.Dbg.SOCKET)) {
                        Debug.println("[SMB] Disconnected session expired, sess=" + curSess + ", vcircuits=" + curSess.numberOfVirtualCircuits());
                    }
                    curSess.setPersistentSession(false);
                    curSess.closeSession();
                    continue;
                }
                if (!this.getSessionDebug().contains((Object)SMBSrvSession.Dbg.SOCKET)) continue;
                Debug.println("[SMB] Ignored disconnected session=" + curSess);
            }
        }
    }

    private class SMBDisconnectedSessionTimedRequest
    extends TimedThreadRequest {
        public SMBDisconnectedSessionTimedRequest() {
            super("SMBDisconnectedSessionExpiry", -30L, 30L);
        }

        @Override
        protected void runTimedRequest() {
            SMBServer.this.checkForExpiredSessions();
        }
    }
}

