/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.server;

import java.io.DataOutputStream;
import java.io.IOException;
import org.filesys.netbios.RFCNetBIOSProtocol;
import org.filesys.smb.server.DefaultParserFactory;
import org.filesys.smb.server.ParserFactory;
import org.filesys.smb.server.Protocol;
import org.filesys.smb.server.SMBParser;
import org.filesys.smb.server.UnsupportedSMBVersionException;
import org.filesys.util.DataPacker;

public class SMBSrvPacket {
    public static final int DEFAULT_BUFSIZE = 4096;
    public static final int SIGNATURE = 4;
    private static final int SMB_ASYNC_QUEUED = 1;
    private static final int SMB_REQUEST_PKT = 2;
    private static final int SMB_ENCRYPT = 4;
    private static final int SMB_NONPOOLEDBUFFER = 8;
    private static final byte[] SMB_V1_SIGNATURE = new byte[]{-1, 83, 77, 66};
    private static final byte[] SMB_V2_SIGNATURE = new byte[]{-2, 83, 77, 66};
    private static final byte[] SMB_V3_SIGNATURE = new byte[]{-3, 83, 77, 66};
    private static ParserFactory _parserFactory = new DefaultParserFactory();
    private byte[] m_smbbuf;
    private int m_rxLen;
    protected SMBParser m_parser;
    protected int m_pos;
    protected int m_endpos;
    private SMBSrvPacket m_assocPkt;
    private int m_flags;
    private int m_deferredCount;
    private long m_leaseTime;

    public SMBSrvPacket() {
        this.m_smbbuf = new byte[4096];
        this.InitializeBuffer(Version.V1);
    }

    public SMBSrvPacket(byte[] buf) {
        this.m_smbbuf = buf;
    }

    public SMBSrvPacket(int siz) {
        this.m_smbbuf = new byte[siz];
        this.InitializeBuffer(Version.V1);
    }

    public SMBSrvPacket(int siz, Version ver) {
        this.m_smbbuf = new byte[siz];
        this.InitializeBuffer(ver);
        this.setParser(ver);
    }

    public SMBSrvPacket(SMBSrvPacket pkt) {
        this.m_smbbuf = new byte[pkt.getBuffer().length];
        System.arraycopy(pkt.getBuffer(), 0, this.m_smbbuf, 0, this.m_smbbuf.length);
    }

    public SMBSrvPacket(SMBSrvPacket pkt, int len) {
        this.m_smbbuf = new byte[pkt.getBuffer().length];
        System.arraycopy(pkt.getBuffer(), 0, this.m_smbbuf, 0, len);
    }

    public final boolean hasParser() {
        return this.m_parser != null;
    }

    public final SMBParser getParser() {
        if (this.m_parser == null) {
            byte sigByte = (byte)(this.m_smbbuf[4] & 0xFF);
            if (sigByte == SMB_V1_SIGNATURE[0]) {
                this.setParser(Version.V1);
            } else if (sigByte == SMB_V2_SIGNATURE[0] || sigByte == SMB_V3_SIGNATURE[0]) {
                this.setParser(Version.V2);
            }
        }
        return this.m_parser;
    }

    public final SMBParser setParser(Version smbVer) {
        try {
            this.m_parser = _parserFactory.createParser(smbVer, this.m_smbbuf, this.m_rxLen);
        }
        catch (UnsupportedSMBVersionException unsupportedSMBVersionException) {
            // empty catch block
        }
        return this.m_parser;
    }

    public final byte[] getBuffer() {
        return this.m_smbbuf;
    }

    public final int getBufferLength() {
        return this.m_smbbuf.length - 4;
    }

    public final int getReceivedLength() {
        return this.m_rxLen;
    }

    public final void setReceivedLength(int len) {
        this.m_rxLen = len;
    }

    public final int getLength() {
        if (this.hasParser()) {
            return this.m_parser.getLength();
        }
        return 0;
    }

    public final int getHeaderFlags() {
        return this.m_smbbuf[1] & 0xFF;
    }

    public final int getHeaderLength() {
        return DataPacker.getIntelShort(this.m_smbbuf, 2) & 0xFFFF;
    }

    public final RFCNetBIOSProtocol.MsgType getHeaderType() {
        return RFCNetBIOSProtocol.MsgType.fromInt(this.m_smbbuf[0] & 0xFF);
    }

    public final void setHeaderFlags(int flg) {
        this.m_smbbuf[1] = (byte)(flg & 0xFF);
    }

    public final void setHeaderLength(int len) {
        DataPacker.putIntelShort(len, this.m_smbbuf, 2);
    }

    public final void setHeaderType(RFCNetBIOSProtocol.MsgType typ) {
        this.m_smbbuf[0] = (byte)(typ.intValue() & 0xFF);
    }

    public final boolean isSMB() {
        byte sig1 = this.m_smbbuf[4];
        if (sig1 != SMB_V1_SIGNATURE[0] && sig1 != SMB_V2_SIGNATURE[0] && sig1 != SMB_V3_SIGNATURE[0]) {
            return false;
        }
        for (int idx = 1; idx < SMB_V1_SIGNATURE.length; ++idx) {
            if (this.m_smbbuf[idx + 4] == SMB_V1_SIGNATURE[idx]) continue;
            return false;
        }
        return true;
    }

    public final boolean isSMB1() {
        for (int idx = 0; idx < SMB_V1_SIGNATURE.length; ++idx) {
            if (this.m_smbbuf[idx + 4] == SMB_V1_SIGNATURE[idx]) continue;
            return false;
        }
        return true;
    }

    public final boolean isSMB2() {
        for (int idx = 0; idx < SMB_V2_SIGNATURE.length; ++idx) {
            if (this.m_smbbuf[idx + 4] == SMB_V2_SIGNATURE[idx]) continue;
            return false;
        }
        return true;
    }

    public final boolean isSMB3() {
        for (int idx = 0; idx < SMB_V3_SIGNATURE.length; ++idx) {
            if (this.m_smbbuf[idx + 4] == SMB_V3_SIGNATURE[idx]) continue;
            return false;
        }
        return true;
    }

    private final void InitializeBuffer(Version ver) {
        this.m_smbbuf[4] = ver == Version.V1 ? SMB_V1_SIGNATURE[0] : (ver == Version.V2 ? SMB_V2_SIGNATURE[0] : SMB_V3_SIGNATURE[0]);
        this.m_smbbuf[5] = 83;
        this.m_smbbuf[6] = 77;
        this.m_smbbuf[7] = 66;
    }

    public final void SendResponseSMB(DataOutputStream out, Protocol proto) throws IOException {
        int siz = this.getParser().getLength();
        this.SendResponseSMB(out, proto, siz);
    }

    public final void SendResponseSMB(DataOutputStream out, Protocol proto, int len) throws IOException {
        this.getParser().setResponse();
        if (proto == Protocol.NetBIOS) {
            this.m_smbbuf[0] = (byte)RFCNetBIOSProtocol.MsgType.MESSAGE.intValue();
            this.m_smbbuf[1] = 0;
            DataPacker.putShort((short)len, this.m_smbbuf, 2);
        } else {
            DataPacker.putInt(len, this.m_smbbuf, 0);
        }
        out.write(this.m_smbbuf, 0, len += 4);
    }

    public final void SendSuccessSMB(DataOutputStream out, Protocol proto) throws IOException {
        this.m_parser.packSuccessRespone();
        this.SendResponseSMB(out, proto);
    }

    public final void setBuffer(byte[] buf) {
        this.m_smbbuf = buf;
    }

    public final boolean hasAssociatedPacket() {
        return this.m_assocPkt != null;
    }

    public final SMBSrvPacket getAssociatedPacket() {
        return this.m_assocPkt;
    }

    public final void setAssociatedPacket(SMBSrvPacket smbPkt) {
        this.m_assocPkt = smbPkt;
    }

    public final void clearAssociatedPacket() {
        this.m_assocPkt = null;
    }

    public final boolean isQueuedForAsyncIO() {
        return (this.m_flags & 1) != 0;
    }

    public final void setQueuedForAsyncIO(boolean asyncIO) {
        this.m_flags = asyncIO ? (this.m_flags |= 1) : (this.m_flags &= 0xFFFFFFFE);
    }

    public final boolean requiresEncryption() {
        return (this.m_flags & 4) != 0;
    }

    public final void setEncryptionRequired(boolean encReq) {
        this.m_flags = encReq ? (this.m_flags |= 4) : (this.m_flags &= 0xFFFFFFFB);
    }

    public final boolean usingNonPooledBuffer() {
        return (this.m_flags & 8) != 0;
    }

    public final void setUsingNonPooledBuffer(boolean nonPooled) {
        this.m_flags = nonPooled ? (this.m_flags |= 8) : (this.m_flags &= 0xFFFFFFF7);
    }

    public final void clearHeader() {
        int i = 4;
        while (i < 37) {
            this.m_smbbuf[i++] = 0;
        }
        this.InitializeBuffer(Version.V1);
    }

    public final int getDeferredCount() {
        return this.m_deferredCount;
    }

    public final void incrementDeferredCount() {
        ++this.m_deferredCount;
    }

    public final boolean hasLeaseTime() {
        return this.m_leaseTime != 0L;
    }

    public final long getLeaseTime() {
        return this.m_leaseTime;
    }

    public final void clearLeaseTime() {
        this.m_leaseTime = 0L;
    }

    public final void setLeaseTime(long tmo) {
        this.m_leaseTime = tmo;
    }

    public static final ParserFactory getParserFactory() {
        return _parserFactory;
    }

    public static final void setParserFactory(ParserFactory parserFactory) {
        _parserFactory = parserFactory;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[SMBPkt ");
        if (this.hasParser()) {
            str.append(this.getParser().getName());
        } else {
            str.append("<NoParser>");
        }
        if (this.usingNonPooledBuffer()) {
            str.append(", NonPooled");
        }
        str.append("]");
        return str.toString();
    }

    public static enum Version {
        V1,
        V2,
        V3;

    }
}

