/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.server;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.filesys.server.SrvSession;
import org.filesys.server.auth.ClientInfo;
import org.filesys.smb.server.SMBSrvSession;
import org.filesys.smb.server.VirtualCircuit;
import org.filesys.smb.server.VirtualCircuitList;

public class SMBV1VirtualCircuitList
implements VirtualCircuitList {
    public static final int DefaultCircuits = 4;
    public static final int DefMaxCircuits = 16;
    public static final int MinCircuits = 4;
    public static final int MaxCircuits = 2000;
    public static final int InitialCircuits = 16;
    private static final int UIDMask = 65535;
    private Map<Integer, VirtualCircuit> m_vcircuits;
    private int m_UID = 1;
    private int m_maxVC = 2000;

    public SMBV1VirtualCircuitList() {
        this.m_maxVC = 2000;
        this.m_vcircuits = new HashMap<Integer, VirtualCircuit>(16);
    }

    public SMBV1VirtualCircuitList(int maxVC) {
        this.m_maxVC = maxVC > 0 ? maxVC : 2000;
        this.m_vcircuits = new HashMap<Integer, VirtualCircuit>(this.getMaximumVirtualCircuits());
    }

    @Override
    public VirtualCircuit createVirtualCircuit(int vcNum, ClientInfo client) {
        return new VirtualCircuit(vcNum, client);
    }

    @Override
    public final int getMaximumVirtualCircuits() {
        return this.m_maxVC;
    }

    @Override
    public synchronized int addCircuit(VirtualCircuit vcircuit) {
        if (this.m_vcircuits == null) {
            this.m_vcircuits = new HashMap<Integer, VirtualCircuit>(4);
        }
        int uid = 0;
        if (this.m_vcircuits.size() == this.getMaximumVirtualCircuits()) {
            return -1;
        }
        uid = this.m_UID++ & 0xFFFF;
        while (this.m_vcircuits.containsKey(uid)) {
            uid = this.m_UID++ & 0xFFFF;
        }
        vcircuit.setId(uid);
        this.m_vcircuits.put(uid, vcircuit);
        return uid;
    }

    @Override
    public final synchronized VirtualCircuit findCircuit(int uid) {
        if (this.m_vcircuits == null) {
            return null;
        }
        return this.m_vcircuits.get(uid);
    }

    @Override
    public synchronized void removeCircuit(int uid, SrvSession sess) {
        if (this.m_vcircuits == null) {
            return;
        }
        VirtualCircuit vc = this.m_vcircuits.get(uid);
        if (vc != null) {
            vc.closeCircuit(sess);
            this.m_vcircuits.remove(uid);
        }
    }

    @Override
    public final synchronized int getCircuitCount() {
        return this.m_vcircuits != null ? this.m_vcircuits.size() : 0;
    }

    @Override
    public final synchronized void clearCircuitList(SMBSrvSession sess) {
        if (this.m_vcircuits != null) {
            for (VirtualCircuit vc : this.m_vcircuits.values()) {
                if (!sess.isShutdown()) {
                    sess.setClientInformation(vc.getClientInformation());
                    sess.getSMBServer().getSMBAuthenticator().setCurrentUser(vc.getClientInformation());
                }
                if (sess.hasDebug(SMBSrvSession.Dbg.STATE)) {
                    sess.debugPrintln("  Cleanup vc=" + vc);
                }
                vc.closeCircuit(sess);
            }
            this.m_vcircuits.clear();
        }
    }

    @Override
    public Iterator<VirtualCircuit> iterator() {
        return this.m_vcircuits.values().iterator();
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[VCs=");
        str.append(this.getCircuitCount());
        str.append("/");
        str.append(this.getMaximumVirtualCircuits());
        str.append("]");
        return str.toString();
    }
}

