/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.server;

import java.net.InetAddress;
import java.net.Socket;
import org.filesys.debug.Debug;
import org.filesys.server.SocketSessionHandler;
import org.filesys.server.config.ServerConfiguration;
import org.filesys.smb.server.SMBConfigSection;
import org.filesys.smb.server.SMBServer;
import org.filesys.smb.server.SMBSrvSession;
import org.filesys.smb.server.TcpipSMBPacketHandler;

public class TcpipSMBSessionSocketHandler
extends SocketSessionHandler {
    private static final ThreadGroup TcpipSMBGroup = new ThreadGroup("TcpipSMBSessions");

    public TcpipSMBSessionSocketHandler(SMBServer srv, int port, InetAddress bindAddr, boolean debug) {
        super("TCP-SMB", "SMB", srv, bindAddr, port);
        this.setDebug(debug);
    }

    @Override
    protected void acceptConnection(Socket sock) {
        block3: {
            try {
                sock.setSoTimeout(this.getSocketTimeout());
                SMBServer smbServer = (SMBServer)this.getServer();
                TcpipSMBPacketHandler pktHandler = new TcpipSMBPacketHandler(sock, smbServer.getPacketPool());
                SMBSrvSession srvSess = SMBSrvSession.createSession(pktHandler, smbServer, this.getNextSessionId());
                if (this.hasDebug()) {
                    Debug.println("[SMB] Created session " + srvSess.getUniqueId());
                }
                Thread srvThread = new Thread(TcpipSMBGroup, srvSess);
                srvThread.setDaemon(true);
                srvThread.setName("Sess_T" + srvSess.getSessionId() + "_" + sock.getInetAddress().getHostAddress());
                srvThread.start();
            }
            catch (Exception ex) {
                if (!this.hasDebug()) break block3;
                Debug.println("[SMB] TCP-SMB Failed to create session, " + ex.toString());
            }
        }
    }

    public static final void createSessionHandlers(SMBServer server, boolean sockDbg) throws Exception {
        ServerConfiguration config = server.getConfiguration();
        SMBConfigSection smbConfig = (SMBConfigSection)config.getConfigSection("SMB");
        TcpipSMBSessionSocketHandler sessHandler = new TcpipSMBSessionSocketHandler(server, smbConfig.getTcpipSMBPort(), smbConfig.getSMBBindAddress(), sockDbg);
        sessHandler.setSocketTimeout(smbConfig.getSocketTimeout());
        sessHandler.initializeSessionHandler(server);
        Thread tcpThread = new Thread(sessHandler);
        tcpThread.setName("TcpipSMB_Handler");
        tcpThread.start();
        if (sockDbg) {
            Debug.println("[SMB] Native SMB TCP session handler created");
        }
    }
}

