/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.server.disk;

import java.io.File;
import org.filesys.debug.Debug;
import org.filesys.server.core.DeviceContextException;
import org.filesys.server.filesys.DiskDeviceContext;
import org.filesys.util.MemorySize;
import org.springframework.extensions.config.ConfigElement;

public class JavaNIODeviceContext
extends DiskDeviceContext {
    private static final long MinimumLargeFileSize = 0x100000L;
    private static final long DefaultLargeFileSize = 524288000L;
    private static final String TrashcanFolderName = ".Trashcan";
    private File m_trashDir;
    private long m_largeFileSize = 524288000L;

    public JavaNIODeviceContext(ConfigElement args) throws DeviceContextException {
        this.initialize(args);
    }

    public JavaNIODeviceContext(String name, ConfigElement args) throws DeviceContextException {
        this.setShareName(name);
        this.initialize(args);
    }

    protected final void initialize(ConfigElement args) throws DeviceContextException {
        ConfigElement path = args.getChild("LocalPath");
        Object ctx = null;
        if (path != null) {
            ConfigElement trashCanPath;
            File rootDir = new File(path.getValue());
            this.setDeviceName(rootDir.getAbsolutePath());
            ConfigElement largeSize = args.getChild("LargeFileSize");
            if (largeSize != null) {
                this.m_largeFileSize = MemorySize.getByteValue(largeSize.getValue());
                if (this.m_largeFileSize < 0x100000L) {
                    this.m_largeFileSize = 0x100000L;
                }
            }
            if ((trashCanPath = args.getChild("TrashcanPath")) != null) {
                this.m_trashDir = new File(trashCanPath.getValue());
                if (!this.m_trashDir.exists()) {
                    throw new DeviceContextException("Trashcan folder does not exist - " + this.m_trashDir.getAbsolutePath());
                }
                if (this.m_trashDir.isFile()) {
                    throw new DeviceContextException("Trashcan path is not a folder - " + this.m_trashDir.getAbsolutePath());
                }
                if (!rootDir.getParent().equalsIgnoreCase(this.m_trashDir.getParent())) {
                    throw new DeviceContextException("File share and trash folders must be on the same volume");
                }
            } else {
                File trashDir = new File(rootDir, TrashcanFolderName);
                if (!trashDir.exists() && !trashDir.mkdir()) {
                    throw new DeviceContextException("Failed to create trashcan folder - " + trashDir.getAbsolutePath());
                }
                this.m_trashDir = trashDir;
            }
            if (args.getChild("Debug") != null) {
                this.setDebug(true);
            }
            this.setFilesystemAttributes(6);
            if (!rootDir.exists() || !rootDir.isDirectory() || rootDir.list() == null) {
                this.setAvailable(false);
                if (this.hasDebug()) {
                    Debug.println("Share " + this.getShareName() + ", local path=" + rootDir.getPath() + " unavailable");
                }
            }
        } else {
            throw new DeviceContextException("LocalPath parameter not specified");
        }
    }

    protected final boolean hasTrashFolder() {
        return this.m_trashDir != null;
    }

    protected final File getTrashFolder() {
        return this.m_trashDir;
    }

    protected final long getLargeFileSize() {
        return this.m_largeFileSize;
    }
}

