/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.server.disk.original;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.filesys.server.filesys.AccessMode;
import org.filesys.server.filesys.DiskFullException;
import org.filesys.server.filesys.NetworkFile;

public class JavaNetworkFile
extends NetworkFile {
    protected File m_file;
    protected RandomAccessFile m_io;
    protected boolean m_eof;

    public JavaNetworkFile(File file, String netPath) {
        super(file.getName());
        this.m_file = file;
        this.setFileSize(this.m_file.length());
        this.m_eof = false;
        long modDate = this.m_file.lastModified();
        this.setModifyDate(modDate);
        this.setCreationDate(modDate);
        this.setFileId(netPath.hashCode());
    }

    public JavaNetworkFile(String name, String netPath) {
        super(name);
        File newFile = new File(name);
        if (newFile.exists()) {
            this.m_file = newFile;
        } else {
            String lowerName = name.toLowerCase();
            File newFile2 = new File(lowerName);
            if (newFile2.exists()) {
                this.m_file = newFile2;
            } else {
                this.m_file = newFile;
                try {
                    FileOutputStream outFile = new FileOutputStream(newFile);
                    outFile.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.setFileSize(this.m_file.length());
        this.m_eof = false;
        long modDate = this.m_file.lastModified();
        this.setModifyDate(modDate);
        this.setCreationDate(modDate);
        this.setFileId(netPath.hashCode());
    }

    public JavaNetworkFile(String name, int mode) {
        super(name);
        File newFile = new File(name);
        if (!newFile.exists()) {
            String lowerName = name.toLowerCase();
            File newFile2 = new File(lowerName);
            if (newFile2.exists()) {
                this.m_file = newFile2;
            } else {
                this.m_file = newFile;
                if (AccessMode.getAccessMode(mode) != 0) {
                    try {
                        FileOutputStream outFile = new FileOutputStream(newFile);
                        outFile.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        this.setFileSize(this.m_file.length());
        this.m_eof = false;
        long modDate = this.m_file.lastModified();
        this.setModifyDate(modDate);
        this.setCreationDate(modDate);
    }

    @Override
    public void closeFile() throws IOException {
        if (this.m_io != null) {
            this.m_io.close();
            this.m_io = null;
            if (this.getWriteCount() > 0) {
                this.m_file.setLastModified(System.currentTimeMillis());
            }
            this.setClosed(true);
        }
    }

    public long currentPosition() {
        try {
            if (this.m_io != null) {
                return this.m_io.getFilePointer();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0L;
    }

    @Override
    public void flushFile() throws IOException {
        if (this.m_io != null) {
            this.m_io.getFD().sync();
        }
    }

    public boolean isEndOfFile() throws IOException {
        return this.m_io != null && this.m_io.getFilePointer() == this.m_io.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openFile(boolean createFlag) throws IOException {
        File file = this.m_file;
        synchronized (file) {
            if (this.m_io == null) {
                this.m_io = new RandomAccessFile(this.m_file, this.getGrantedAccess() == NetworkFile.Access.READ_WRITE ? "rw" : "r");
                this.setClosed(false);
            }
        }
    }

    @Override
    public int readFile(byte[] buf, int len, int pos, long fileOff) throws IOException {
        if (this.m_io == null) {
            this.openFile(false);
        }
        if (this.currentPosition() != fileOff) {
            this.seekFile(fileOff, 0);
        }
        int rdlen = this.m_io.read(buf, pos, len);
        return rdlen;
    }

    @Override
    public long seekFile(long pos, int typ) throws IOException {
        if (this.m_io == null) {
            this.openFile(false);
        }
        switch (typ) {
            case 0: {
                if (this.currentPosition() == pos) break;
                this.m_io.seek(pos);
                break;
            }
            case 1: {
                this.m_io.seek(this.currentPosition() + pos);
                break;
            }
            case 2: {
                long newPos = this.m_io.length() + pos;
                this.m_io.seek(newPos);
            }
        }
        return this.currentPosition();
    }

    @Override
    public void truncateFile(long siz) throws IOException {
        if (this.m_io == null) {
            this.openFile(true);
        } else {
            this.m_io.getFD().sync();
        }
        boolean extendFile = siz > this.getFileSize();
        try {
            this.m_io.setLength(siz);
            this.setFileSize(siz);
        }
        catch (IOException ex) {
            if (extendFile) {
                throw new DiskFullException("Failed to extend file, " + this.getFullName());
            }
            throw ex;
        }
    }

    public void writeFile(byte[] buf, int len, int pos) throws IOException {
        if (this.m_io == null) {
            this.openFile(true);
        }
        this.m_io.write(buf, pos, len);
        this.incrementWriteCount();
    }

    @Override
    public void writeFile(byte[] buf, int len, int pos, long offset) throws IOException {
        long fileLen;
        if (this.m_io == null) {
            this.openFile(true);
        }
        if (offset > (fileLen = this.m_io.length())) {
            this.m_io.setLength(offset + (long)len);
        }
        if (len == 0) {
            return;
        }
        this.m_io.seek(offset);
        this.m_io.write(buf, pos, len);
        this.incrementWriteCount();
    }
}

