/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.server.nio;

import java.nio.channels.SelectionKey;
import org.filesys.debug.Debug;
import org.filesys.server.thread.ThreadRequest;
import org.filesys.smb.server.PacketHandler;
import org.filesys.smb.server.SMBSrvPacket;
import org.filesys.smb.server.SMBSrvSession;

public class NIOSMBThreadRequest
implements ThreadRequest {
    private static final int MaxPacketsPerRun = 4;
    private SMBSrvSession m_sess;
    private SelectionKey m_selectionKey;

    public NIOSMBThreadRequest(SMBSrvSession sess, SelectionKey selKey) {
        this.m_sess = sess;
        this.m_selectionKey = selKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runRequest() {
        if (!this.m_sess.isShutdown()) {
            int asyncCnt;
            int pktCount = 0;
            boolean morePkts = true;
            boolean pktError = false;
            boolean asyncPkt = false;
            SMBSrvPacket smbPkt = null;
            while (pktCount < 4 && morePkts && !pktError) {
                try {
                    PacketHandler pktHandler = this.m_sess.getPacketHandler();
                    if (pktHandler == null) {
                        smbPkt = null;
                        morePkts = false;
                        continue;
                    }
                    smbPkt = pktHandler.readPacket();
                    if (smbPkt == null) {
                        if (pktCount == 0) {
                            if (this.m_sess.hasDebug(SMBSrvSession.Dbg.SOCKET)) {
                                Debug.println("Received null packet, closing session sess=" + this.m_sess.getUniqueId() + ", addr=" + this.m_sess.getRemoteAddress().getHostAddress());
                            }
                            this.m_sess.hangupSession("Client closed socket");
                            this.m_sess.processPacket(null);
                            this.m_selectionKey.cancel();
                            this.m_selectionKey.selector().wakeup();
                            pktError = true;
                        }
                        morePkts = false;
                        continue;
                    }
                    ++pktCount;
                    if (!asyncPkt && this.m_sess.hasAsyncResponseQueued()) {
                        asyncPkt = true;
                    } else if (pktCount == 4 && !asyncPkt) {
                        this.m_selectionKey.interestOps(this.m_selectionKey.interestOps() | 1);
                        this.m_selectionKey.selector().wakeup();
                    }
                    this.m_sess.processPacket(smbPkt);
                    smbPkt = null;
                }
                catch (Throwable ex) {
                    if (this.m_sess.hasDebug(SMBSrvSession.Dbg.SOCKET) && ex.getMessage() != null && !ex.getMessage().startsWith("Connection reset by peer")) {
                        Debug.println("Error during packet receive, closing session sess=" + this.m_sess.getUniqueId() + ", addr=" + this.m_sess.getRemoteAddressString() + " ex=" + ex.getMessage());
                        Debug.println(ex);
                    }
                    this.m_sess.hangupSession("Client closed socket");
                    this.m_sess.processPacket(null);
                    this.m_selectionKey.cancel();
                    this.m_selectionKey.selector().wakeup();
                    pktError = true;
                }
                finally {
                    if (smbPkt == null) continue;
                    this.m_sess.getPacketPool().releasePacket(smbPkt);
                }
            }
            if (asyncPkt && (asyncCnt = this.m_sess.sendQueuedAsyncResponses()) > 0 && this.m_sess.hasDebug(SMBSrvSession.Dbg.SOCKET)) {
                Debug.println("Sent queued async packets (NIO) count=" + asyncCnt + ", sess=" + this.m_sess.getUniqueId() + ", addr=" + this.m_sess.getRemoteAddress().getHostAddress());
            }
            if (!pktError && (pktCount < 4 || asyncPkt)) {
                this.m_selectionKey.interestOps(this.m_selectionKey.interestOps() | 1);
                this.m_selectionKey.selector().wakeup();
            }
            if (this.m_sess.hasDebug(SMBSrvSession.Dbg.THREADPOOL) && pktCount > 1) {
                Debug.println("Processed " + pktCount + " packets for addr=" + this.m_sess.getRemoteAddress().getHostAddress() + " in one thread run (max=" + 4 + ")");
            }
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[NIO SMB Sess=");
        str.append(this.m_sess.getUniqueId());
        str.append("]");
        return str.toString();
    }
}

