/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.server.nio;

import java.io.IOException;
import java.nio.channels.SocketChannel;
import org.filesys.netbios.RFCNetBIOSProtocol;
import org.filesys.smb.server.Protocol;
import org.filesys.smb.server.SMBPacketPool;
import org.filesys.smb.server.SMBSrvPacket;
import org.filesys.smb.server.nio.ChannelPacketHandler;
import org.filesys.util.DataPacker;

public class NetBIOSSMBChannelHandler
extends ChannelPacketHandler {
    public NetBIOSSMBChannelHandler(SocketChannel sockChannel, SMBPacketPool packetPool) throws IOException {
        super(sockChannel, Protocol.NetBIOS, "NetBIOS", "N", packetPool);
    }

    @Override
    public SMBSrvPacket readPacket() throws IOException {
        int offset;
        int len = this.readBytes(this.m_headerBuf, 0, 4);
        if (len <= 0) {
            return null;
        }
        if (len < 4) {
            throw new IOException("Invalid NetBIOS header, len=" + len);
        }
        RFCNetBIOSProtocol.MsgType typ = RFCNetBIOSProtocol.MsgType.fromInt(this.m_headerBuf[0] & 0xFF);
        byte flags = this.m_headerBuf[1];
        int dlen = DataPacker.getShort(this.m_headerBuf, 2);
        if ((flags & 1) != 0) {
            dlen += 65536;
        }
        if (typ == RFCNetBIOSProtocol.MsgType.KEEPALIVE) {
            return null;
        }
        SMBSrvPacket pkt = this.getPacketPool().allocatePacket(dlen + this.getEncryptionOverhead() + 4);
        int totlen = offset = 4;
        try {
            while (dlen > 0) {
                len = this.readBytes(pkt.getBuffer(), offset, dlen);
                if (len == -1) {
                    throw new IOException("Connection closed (request read)");
                }
                totlen += len;
                dlen -= len;
                offset += len;
            }
        }
        catch (Throwable ex) {
            this.getPacketPool().releasePacket(pkt);
            this.rethrowException(ex);
        }
        System.arraycopy(this.m_headerBuf, 0, pkt.getBuffer(), 0, 4);
        pkt.setReceivedLength(totlen);
        return pkt;
    }

    @Override
    public void writePacket(SMBSrvPacket pkt, int len, boolean writeRaw) throws IOException {
        byte[] buf = pkt.getBuffer();
        if (!writeRaw) {
            buf[0] = (byte)RFCNetBIOSProtocol.MsgType.MESSAGE.intValue();
            buf[1] = 0;
            if (len > 65535) {
                buf[1] = 1;
                DataPacker.putShort((short)(len & 0xFFFF), buf, 2);
            } else {
                DataPacker.putShort((short)len, buf, 2);
            }
            len += 4;
        }
        this.writeBytes(buf, 0, len);
    }
}

