/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.server.nio;

import java.io.IOException;
import java.nio.channels.SocketChannel;
import org.filesys.smb.server.Protocol;
import org.filesys.smb.server.SMBPacketPool;
import org.filesys.smb.server.SMBSrvPacket;
import org.filesys.smb.server.nio.ChannelPacketHandler;
import org.filesys.util.DataPacker;

public class TcpipSMBChannelHandler
extends ChannelPacketHandler {
    public TcpipSMBChannelHandler(SocketChannel sockChannel, SMBPacketPool packetPool) throws IOException {
        super(sockChannel, Protocol.TCPIP, "TCP-SMB", "T", packetPool);
    }

    @Override
    public SMBSrvPacket readPacket() throws IOException {
        int offset;
        int len = this.readBytes(this.m_headerBuf, 0, 4);
        if (len <= 0) {
            return null;
        }
        if (len < 4) {
            int pos = len;
            while (len < 4) {
                int rxlen = this.readBytes(this.m_headerBuf, pos, 4 - pos);
                if (rxlen == -1) {
                    throw new IOException("Connection closed (header read)");
                }
                len += rxlen;
                pos += rxlen;
            }
        }
        int dlen = DataPacker.getShort(this.m_headerBuf, 2);
        if (this.m_headerBuf[1] != 0) {
            byte llen = this.m_headerBuf[1];
            dlen += llen << 16;
        }
        SMBSrvPacket pkt = this.getPacketPool().allocatePacket(dlen + this.getEncryptionOverhead() + 4);
        int totlen = offset = 4;
        try {
            while (dlen > 0) {
                len = this.readBytes(pkt.getBuffer(), offset, dlen);
                if (len == -1) {
                    throw new IOException("Connection closed (request read)");
                }
                totlen += len;
                dlen -= len;
                offset += len;
            }
        }
        catch (Throwable ex) {
            this.getPacketPool().releasePacket(pkt);
            this.rethrowException(ex);
        }
        pkt.setReceivedLength(totlen);
        return pkt;
    }

    @Override
    public void writePacket(SMBSrvPacket pkt, int len, boolean writeRaw) throws IOException {
        byte[] buf = pkt.getBuffer();
        DataPacker.putInt(len, buf, 0);
        int bufSiz = len + 4;
        this.writeBytes(buf, 0, bufSiz);
    }
}

