/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.server.notify;

import java.util.EnumSet;
import java.util.Set;
import org.filesys.server.filesys.NotifyAction;
import org.filesys.server.filesys.NotifyChange;

public class NotifyChangeEvent {
    private NotifyAction m_action;
    private Set<NotifyChange> m_filter = EnumSet.noneOf(NotifyChange.class);
    private String m_fileName;
    private boolean m_dir;
    private String m_oldName;

    public NotifyChangeEvent(NotifyChange filter, NotifyAction action, String fname, boolean dir) {
        this.m_filter.add(filter);
        this.m_action = action;
        this.m_fileName = fname;
        this.m_dir = dir;
        if (this.m_fileName.indexOf(47) != -1) {
            this.m_fileName = this.m_fileName.replace('/', '\\');
        }
    }

    public NotifyChangeEvent(NotifyChange filter, NotifyAction action, String fname, String oldname, boolean dir) {
        this.m_filter.add(filter);
        this.m_action = action;
        this.m_fileName = fname;
        this.m_oldName = oldname;
        this.m_dir = dir;
        if (this.m_fileName.indexOf(47) != -1) {
            this.m_fileName = this.m_fileName.replace('/', '\\');
        }
        if (this.m_oldName.indexOf(47) != -1) {
            this.m_oldName.replace('/', '\\');
        }
    }

    public final Set<NotifyChange> getFilter() {
        return this.m_filter;
    }

    public final NotifyAction getAction() {
        return this.m_action;
    }

    public final String getFileName() {
        return this.m_fileName;
    }

    public final String getShortFileName() {
        int pos = this.m_fileName.lastIndexOf("\\");
        if (pos != -1) {
            return this.m_fileName.substring(pos + 1);
        }
        return this.m_fileName;
    }

    public final String getOldFileName() {
        return this.m_oldName;
    }

    public final String getShortOldFileName() {
        if (this.m_oldName == null) {
            return null;
        }
        int pos = this.m_oldName.lastIndexOf("\\");
        if (pos != -1) {
            return this.m_oldName.substring(pos + 1);
        }
        return this.m_oldName;
    }

    public final boolean hasOldFileName() {
        return this.m_oldName != null;
    }

    public final boolean isDirectory() {
        return this.m_dir;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(this.getFilter().toString());
        str.append("-");
        str.append(this.getAction().name());
        str.append(":");
        str.append(this.getFileName());
        if (this.isDirectory()) {
            str.append(",DIR");
        }
        if (this.hasOldFileName()) {
            str.append(",Old=");
            str.append(this.getOldFileName());
        }
        str.append("]");
        return str.toString();
    }
}

