/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.server.notify;

import java.util.Date;
import java.util.Set;
import org.filesys.server.filesys.DiskDeviceContext;
import org.filesys.server.filesys.NetworkFile;
import org.filesys.server.filesys.NotifyChange;
import org.filesys.smb.server.SMBSrvSession;
import org.filesys.smb.server.notify.NotifyChangeEvent;
import org.filesys.smb.server.notify.NotifyChangeEventList;

public class NotifyRequest {
    public static final long DefaultRequestTimeout = 10000L;
    private Set<NotifyChange> m_filter;
    private boolean m_watchTree;
    private SMBSrvSession m_sess;
    private NetworkFile m_watchDir;
    private String m_watchPath;
    private long m_id;
    private int m_tid;
    private int m_pid;
    private int m_uid;
    private int m_maxQueueLen;
    private DiskDeviceContext m_diskCtx;
    private NotifyChangeEventList m_bufferedEvents;
    private boolean m_completed;
    private long m_expiresAt;
    private boolean m_notifyEnum;
    private int m_maxRespLen;

    public NotifyRequest(Set<NotifyChange> filter, boolean watchTree, SMBSrvSession sess, NetworkFile dir, int mid, int tid, int pid, int uid, int qlen) {
        this.m_filter = filter;
        this.m_watchTree = watchTree;
        this.m_sess = sess;
        this.m_watchDir = dir;
        this.m_id = mid;
        this.m_tid = tid;
        this.m_pid = pid;
        this.m_uid = uid;
        this.m_maxQueueLen = qlen;
        this.m_watchPath = this.m_watchDir.getFullName().toUpperCase();
        if (this.m_watchPath.length() == 0) {
            this.m_watchPath = "\\";
        } else if (this.m_watchPath.indexOf(47) != -1) {
            this.m_watchPath = this.m_watchPath.replace('/', '\\');
        }
    }

    public NotifyRequest(Set<NotifyChange> filter, boolean watchTree, SMBSrvSession sess, NetworkFile dir, long id, int treeId, int procId, int vcId, int maxRespLen) {
        this.m_filter = filter;
        this.m_watchTree = watchTree;
        this.m_sess = sess;
        this.m_watchDir = dir;
        this.m_id = id;
        this.m_tid = treeId;
        this.m_pid = procId;
        this.m_uid = vcId;
        this.m_maxRespLen = maxRespLen;
        this.m_watchPath = this.m_watchDir.getFullName().toUpperCase();
        if (this.m_watchPath.length() == 0) {
            this.m_watchPath = "\\";
        } else if (this.m_watchPath.indexOf(47) != -1) {
            this.m_watchPath = this.m_watchPath.replace('/', '\\');
        }
    }

    public final Set<NotifyChange> getFilter() {
        return this.m_filter;
    }

    public final boolean isCompleted() {
        return this.m_completed;
    }

    public final boolean hasExpired(long curTime) {
        if (!this.isCompleted()) {
            return false;
        }
        return this.m_expiresAt < curTime;
    }

    public final boolean hasFileNameChange() {
        return this.m_filter.contains((Object)NotifyChange.FileName);
    }

    public final boolean hasDirectoryNameChange() {
        return this.m_filter.contains((Object)NotifyChange.DirectoryName);
    }

    public final boolean hasAttributeChange() {
        return this.m_filter.contains((Object)NotifyChange.Attributes);
    }

    public final boolean hasFileSizeChange() {
        return this.m_filter.contains((Object)NotifyChange.Size);
    }

    public final boolean hasFileWriteTimeChange() {
        return this.m_filter.contains((Object)NotifyChange.LastWrite);
    }

    public final boolean hasFileAccessTimeChange() {
        return this.m_filter.contains((Object)NotifyChange.LastAccess);
    }

    public final boolean hasFileCreateTimeChange() {
        return this.m_filter.contains((Object)NotifyChange.Creation);
    }

    public final boolean hasSecurityDescriptorChange() {
        return this.m_filter.contains((Object)NotifyChange.Security);
    }

    public final boolean hasFilter(NotifyChange flag) {
        return this.m_filter.contains((Object)flag);
    }

    public final boolean containsFilter(Set<NotifyChange> filter) {
        for (NotifyChange changeType : filter) {
            if (!this.m_filter.contains((Object)changeType)) continue;
            return true;
        }
        return false;
    }

    public final boolean hasNotifyEnum() {
        return this.m_notifyEnum;
    }

    public final boolean hasWatchTree() {
        return this.m_watchTree;
    }

    public final SMBSrvSession getSession() {
        return this.m_sess;
    }

    public final NetworkFile getDirectory() {
        return this.m_watchDir;
    }

    public final String getWatchPath() {
        return this.m_watchPath;
    }

    public final long getId() {
        return this.m_id;
    }

    public final int getIdAsInt() {
        return (int)this.m_id & 0xFFFFFFFF;
    }

    public final int getTreeId() {
        return this.m_tid;
    }

    public final int getProcessId() {
        return this.m_pid;
    }

    public final int getUserId() {
        return this.m_uid;
    }

    public final int getVirtualCircuitId() {
        return this.m_uid;
    }

    public final long getExpiryTime() {
        return this.m_expiresAt;
    }

    public final DiskDeviceContext getDiskContext() {
        return this.m_diskCtx;
    }

    public final int getMaximumQueueLength() {
        return this.m_maxQueueLen;
    }

    public final int getMaximumResponseLength() {
        return this.m_maxRespLen;
    }

    public final boolean hasBufferedEvents() {
        return this.m_bufferedEvents != null && this.m_bufferedEvents.numberOfEvents() > 0;
    }

    public final NotifyChangeEventList getBufferedEventList() {
        return this.m_bufferedEvents;
    }

    public final void addEvent(NotifyChangeEvent evt) {
        if (this.hasNotifyEnum()) {
            return;
        }
        if (this.m_bufferedEvents == null) {
            this.m_bufferedEvents = new NotifyChangeEventList();
        }
        if (this.m_bufferedEvents.numberOfEvents() < this.getMaximumQueueLength()) {
            this.m_bufferedEvents.addEvent(evt);
        } else {
            this.removeAllEvents();
            this.setNotifyEnum(true);
        }
    }

    public final void removeAllEvents() {
        if (this.m_bufferedEvents != null) {
            this.m_bufferedEvents.removeAllEvents();
            this.m_bufferedEvents = null;
        }
    }

    public final void clearBufferedEvents() {
        this.m_bufferedEvents = null;
    }

    public final void setNotifyEnum(boolean ena) {
        this.m_notifyEnum = ena;
    }

    protected final void setDiskContext(DiskDeviceContext ctx) {
        this.m_diskCtx = ctx;
    }

    public final void setId(long id) {
        this.m_id = id;
    }

    public final void setCompleted(boolean comp) {
        this.m_completed = comp;
        if (comp) {
            this.m_expiresAt = System.currentTimeMillis() + 10000L;
        }
    }

    public final void setCompleted(boolean comp, long expires) {
        this.m_completed = comp;
        this.m_expiresAt = expires;
    }

    public final String makeWatchRelativePath(String evtPath) {
        if (evtPath == null || evtPath.length() == 0 || !evtPath.startsWith("\\")) {
            return evtPath;
        }
        String relPath = null;
        if (evtPath.toUpperCase().startsWith(this.m_watchPath) && (relPath = evtPath.substring(this.m_watchPath.length())).length() > 1 && relPath.startsWith("\\")) {
            relPath = relPath.substring(1);
        }
        return relPath;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(this.getSession().getUniqueId());
        str.append(":");
        if (this.getWatchPath().length() == 0) {
            str.append("Root");
        } else {
            str.append(this.getWatchPath());
        }
        str.append(":Filter");
        str.append(this.m_filter.toString());
        if (this.hasWatchTree()) {
            str.append(", Tree");
        } else {
            str.append(", NoTree");
        }
        if (this.getProcessId() != 0 && this.getUserId() != 0) {
            str.append(" MID=");
            str.append(this.getId());
            str.append(" PID=");
            str.append(this.getProcessId());
            str.append(" TID=");
            str.append(this.getTreeId());
            str.append(" UID=");
            str.append(this.getUserId());
            if (this.getMaximumQueueLength() > 0) {
                str.append(", maxQueue=");
                str.append(this.getMaximumQueueLength());
            }
        } else {
            str.append(" ID=");
            str.append(this.getId());
            str.append(" treeId=");
            str.append(this.getTreeId());
            str.append(" procId=");
            str.append(this.getProcessId());
            str.append(", maxRespLen=");
            str.append(this.getMaximumResponseLength());
        }
        if (this.isCompleted()) {
            str.append(",Completed,TMO=");
            str.append(new Date(this.getExpiryTime()).toString());
        }
        if (this.hasBufferedEvents()) {
            str.append(", buf=");
            str.append(this.getBufferedEventList().numberOfEvents());
        }
        if (this.m_sess.getRemoteAddress() != null) {
            str.append(", addr=");
            str.append(this.m_sess.getRemoteAddress());
        }
        if (this.hasNotifyEnum()) {
            str.append(",ENUM");
        }
        str.append("]");
        return str.toString();
    }
}

