/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.smb.util;

import java.util.ArrayList;
import java.util.List;
import org.filesys.smb.util.DriveMapping;

public class DriveMappingList {
    private List<DriveMapping> m_mappings = new ArrayList<DriveMapping>();

    public final void addMapping(DriveMapping mapping) {
        this.m_mappings.add(mapping);
    }

    public final int numberOfMappings() {
        return this.m_mappings.size();
    }

    public final DriveMapping getMappingAt(int idx) {
        if (idx < 0 || idx >= this.m_mappings.size()) {
            return null;
        }
        return this.m_mappings.get(idx);
    }

    public final DriveMapping findMapping(String localDrive) {
        for (int i = 0; i < this.m_mappings.size(); ++i) {
            DriveMapping driveMap = this.m_mappings.get(i);
            if (!driveMap.getLocalDrive().equalsIgnoreCase(localDrive)) continue;
            return driveMap;
        }
        return null;
    }

    public final void removeMapping(int idx) {
        if (idx < 0 || idx >= this.m_mappings.size()) {
            return;
        }
        this.m_mappings.remove(idx);
    }

    public final void removeAllMappings() {
        this.m_mappings.clear();
    }
}

