/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.util;

import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.Netapi32Util;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.filesys.netbios.NetBIOSName;
import org.filesys.netbios.NetBIOSNameList;
import org.filesys.netbios.NetBIOSSession;
import org.filesys.util.PlatformType;

public class LocalServer {
    private static String m_localName;
    private static String m_localDomain;

    public static final String getLocalServerName(boolean trimDomain) {
        int pos;
        if (m_localName != null) {
            return m_localName;
        }
        String srvName = null;
        if (PlatformType.isPlatformType() == PlatformType.Type.WINDOWS) {
            srvName = Kernel32Util.getComputerName();
        } else {
            try {
                srvName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        if (trimDomain && srvName != null && (pos = srvName.indexOf(".")) != -1) {
            srvName = srvName.substring(0, pos);
        }
        m_localName = srvName;
        return srvName;
    }

    public static final String getLocalDomainName() {
        if (m_localDomain != null) {
            return m_localDomain;
        }
        String domainName = null;
        if (PlatformType.isPlatformType() == PlatformType.Type.WINDOWS) {
            String computerName = Kernel32Util.getComputerName();
            domainName = Netapi32Util.getDomainName((String)computerName);
        } else {
            NetBIOSName nbName = null;
            try {
                nbName = NetBIOSSession.FindName("\u0001\u0002__MSBROWSE__\u0002", '\u0001', 5000);
                NetBIOSNameList nbNameList = NetBIOSSession.FindNamesForAddress(nbName.getIPAddressString(0));
                if (nbNameList != null && (nbName = nbNameList.findName('\u001d', false)) != null) {
                    domainName = nbName.getName();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        m_localDomain = domainName;
        return domainName;
    }
}

