/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.util;

public class NameValue {
    private String m_name;
    private Object m_value;

    public NameValue(String name, Object val) {
        this.m_name = name;
        this.m_value = val;
    }

    public final String getName() {
        return this.m_name;
    }

    public final String getValue() {
        if (this.m_value instanceof String) {
            return (String)this.m_value;
        }
        return this.m_value.toString();
    }

    public final Object getObject() {
        return this.m_value;
    }

    public final int getInteger(int low, int high) throws NumberFormatException {
        if (this.m_value == null) {
            throw new NumberFormatException("No value");
        }
        int ival = Integer.parseInt(this.getValue());
        if (ival < low || ival > high) {
            throw new NumberFormatException("Out of valid range");
        }
        return ival;
    }

    public final long getLong(long low, long high) throws NumberFormatException {
        if (this.m_value == null) {
            throw new NumberFormatException("No value");
        }
        long lval = Long.parseLong(this.getValue());
        if (lval < low || lval > high) {
            throw new NumberFormatException("Out of valid range");
        }
        return lval;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(this.getName());
        str.append(",");
        str.append(this.getValue());
        str.append("]");
        return str.toString();
    }
}

