/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.util;

import com.sun.jna.Platform;

public class PlatformType {
    private static Type _platformType = Type.Unchecked;

    public static final Type isPlatformType() {
        if (_platformType == Type.Unchecked) {
            if (Platform.isWindows()) {
                _platformType = Type.WINDOWS;
            } else if (Platform.isLinux()) {
                _platformType = Type.LINUX;
            } else if (Platform.isMac()) {
                _platformType = Type.MACOSX;
            } else if (Platform.isSolaris()) {
                _platformType = Type.SOLARIS;
            } else if (Platform.isAIX()) {
                _platformType = Type.AIX;
            }
        }
        return _platformType;
    }

    public static final boolean isWindowsNTOnwards() {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            return !osName.endsWith("95") && !osName.endsWith("98") && !osName.endsWith("ME");
        }
        return false;
    }

    public static enum Type {
        Unchecked,
        Unknown,
        WINDOWS,
        LINUX,
        SOLARIS,
        MACOSX,
        AIX;

    }
}

