/*
 * Decompiled with CFR 0.152.
 */
package org.filesys.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class StringList {
    private List<String> m_list = new ArrayList<String>();

    public StringList() {
    }

    public StringList(Vector list) {
        for (int i = 0; i < list.size(); ++i) {
            Object obj = list.get(i);
            if (obj instanceof String) {
                this.addString((String)obj);
                continue;
            }
            this.addString(obj.toString());
        }
    }

    public final int numberOfStrings() {
        return this.m_list.size();
    }

    public final void addString(String str) {
        this.m_list.add(str);
    }

    public final String getStringAt(int idx) {
        if (idx < 0 || idx >= this.m_list.size()) {
            return null;
        }
        return this.m_list.get(idx);
    }

    public final boolean containsString(String str) {
        return this.m_list.contains(str);
    }

    public final int findString(String str) {
        return this.m_list.indexOf(str);
    }

    public final boolean removeString(String str) {
        return this.m_list.remove(str);
    }

    public final String removeStringAt(int idx) {
        if (idx < 0 || idx >= this.m_list.size()) {
            return null;
        }
        return this.m_list.remove(idx);
    }

    public final void remoteAllStrings() {
        this.m_list.clear();
    }

    public String toString() {
        if (this.numberOfStrings() == 0) {
            return "";
        }
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < this.m_list.size(); ++i) {
            str.append(this.getStringAt(i));
            str.append(",");
        }
        if (str.length() > 0) {
            str.setLength(str.length() - 1);
        }
        return str.toString();
    }
}

