/*
 * Copyright (C) 2006-2010 Alfresco Software Limited.
 *
 * This file is part of Alfresco
 *
 * Alfresco is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Alfresco is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Alfresco. If not, see <http://www.gnu.org/licenses/>.
 */

package org.filesys.server.filesys.loader;

import org.filesys.server.filesys.DiskDeviceContext;
import org.filesys.server.filesys.cache.FileState;

/**
 * File Processor Interface
 *
 * <p>Allows post-processing of a cached file before being stored by the FileLoader or when a file load has just
 * completed.
 *
 * @author gkspencer
 */
public interface FileProcessor {

    /**
     * Process a cached file just before it is to be stored.
     *
     * @param context DiskDeviceContext
     * @param state   FileState
     * @param segment FileSegment
     */
    void processStoredFile(DiskDeviceContext context, FileState state, FileSegment segment);

    /**
     * Process a cached file just after being loaded.
     *
     * @param context DiskDeviceContext
     * @param state   FileState
     * @param segment FileSegment
     */
    void processLoadedFile(DiskDeviceContext context, FileState state, FileSegment segment);
}
