/*
 * Decompiled with CFR 0.152.
 */
package org.finnpic;

import java.time.LocalDate;
import org.finnpic.Female$;
import org.finnpic.Gender;
import org.finnpic.Male$;
import org.finnpic.Parsable;
import org.finnpic.Parsable$class;
import org.finnpic.Pic;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class Pic$
implements Parsable<Pic> {
    public static final Pic$ MODULE$;
    private final int finnishLegalAge;
    private final Pic.ValidationRule birthDatePartMustBeNumeric;
    private final Pic.ValidationRule dayOfBirthDatePartMustBeInRangeOf1To31;
    private final Pic.ValidationRule monthOfBirthDatePartMustBeInRangeOf1To12;
    private final Pic.ValidationRule signMustHaveAcceptableValue;
    private final Pic.ValidationRule individualNumberMustBeNumeric;
    private final List<Pic.ValidationRule> validationRules;
    private final char[] controlChars;

    static {
        new Pic$();
    }

    @Override
    public Object fromStringUnsafe(String input) {
        return Parsable$class.fromStringUnsafe(this, input);
    }

    @Override
    public Object fromStringU(String input) {
        return Parsable$class.fromStringU(this, input);
    }

    public int finnishLegalAge() {
        return this.finnishLegalAge;
    }

    public Either<String, Pic> apply(String input) {
        return this.fromString(input);
    }

    @Override
    public Either<String, Pic> fromString(String input) {
        String string;
        block4: {
            Left left;
            block3: {
                String string2;
                block2: {
                    String string3;
                    string = input.trim().toUpperCase();
                    if (string == null || (string3 = string).length() == 11) break block2;
                    left = package$.MODULE$.Left().apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid PIC: '", "'. PIC should have 11 characters, but was ", " characters."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string3, BoxesRunTime.boxToInteger((int)string3.length())})));
                    break block3;
                }
                if (string == null || (string2 = string).length() != 11) break block4;
                left = this.createFromStringOfCorrectLength(input, string2);
            }
            return left;
        }
        throw new MatchError((Object)string);
    }

    private Either<String, Pic> createFromStringOfCorrectLength(String originalInput, String cleanedInput) {
        String birthDatePart = cleanedInput.substring(0, 6);
        String sign = cleanedInput.substring(6, 7);
        String individualNumber = cleanedInput.substring(7, 10);
        String controlCharacter = cleanedInput.substring(10, 11);
        return this.createFromSubstrings(new Pic.PicParts(originalInput, cleanedInput, birthDatePart, sign, individualNumber, controlCharacter));
    }

    private Pic.ValidationRule birthDatePartMustBeNumeric() {
        return this.birthDatePartMustBeNumeric;
    }

    private Pic.ValidationRule dayOfBirthDatePartMustBeInRangeOf1To31() {
        return this.dayOfBirthDatePartMustBeInRangeOf1To31;
    }

    private Pic.ValidationRule monthOfBirthDatePartMustBeInRangeOf1To12() {
        return this.monthOfBirthDatePartMustBeInRangeOf1To12;
    }

    private Pic.ValidationRule signMustHaveAcceptableValue() {
        return this.signMustHaveAcceptableValue;
    }

    private Pic.ValidationRule individualNumberMustBeNumeric() {
        return this.individualNumberMustBeNumeric;
    }

    private List<Pic.ValidationRule> validationRules() {
        return this.validationRules;
    }

    private Either<String, Pic> createFromSubstrings(Pic.PicParts pp) {
        Option option;
        block4: {
            Left left;
            block3: {
                block2: {
                    Option failedValidationRule = this.validationRules().find((Function1)new Serializable(pp){
                        public static final long serialVersionUID = 0L;
                        private final Pic.PicParts pp$1;

                        public final boolean apply(Pic.ValidationRule vr) {
                            return !BoxesRunTime.unboxToBoolean((Object)vr.predicate().apply((Object)this.pp$1));
                        }
                        {
                            this.pp$1 = pp$1;
                        }
                    });
                    option = failedValidationRule;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    Pic.ValidationRule rule = (Pic.ValidationRule)some.x();
                    left = package$.MODULE$.Left().apply(rule.errorMessageGenerator().apply((Object)pp));
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                left = this.createFromValidParts(pp);
            }
            return left;
        }
        throw new MatchError((Object)option);
    }

    private Either<String, Pic> createFromValidParts(Pic.PicParts pp) {
        Try try_;
        block11: {
            Left left;
            block8: {
                Right right;
                block10: {
                    block9: {
                        int n;
                        block7: {
                            char expectedControlCharacter = this.calculateExpectedControlCharacter(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder().append((Object)pp.birthDatePart()).append((Object)pp.individualNumber()).toString())).toLong());
                            if (pp.controlCharacter().charAt(0) == expectedControlCharacter) break block7;
                            left = package$.MODULE$.Left().apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid PIC: '", "'. The control character ('", "') is wrong: it should be '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pp.originalInput(), pp.controlCharacter(), BoxesRunTime.boxToCharacter((char)expectedControlCharacter)})));
                            break block8;
                        }
                        Product gender = new StringOps(Predef$.MODULE$.augmentString(pp.individualNumber())).toInt() % 2 == 0 ? Female$.MODULE$ : Male$.MODULE$;
                        char c = pp.sign().charAt(0);
                        switch (c) {
                            default: {
                                throw new MatchError((Object)BoxesRunTime.boxToCharacter((char)c));
                            }
                            case 'A': {
                                n = 2000;
                                break;
                            }
                            case '-': {
                                n = 1900;
                                break;
                            }
                            case '+': {
                                n = 1800;
                            }
                        }
                        int century = n;
                        int yearWithinCentury = new StringOps(Predef$.MODULE$.augmentString(pp.birthDatePart().toString().substring(4, 6))).toInt();
                        int birthYear = century + yearWithinCentury;
                        int birthMonth = new StringOps(Predef$.MODULE$.augmentString(pp.birthDatePart().toString().substring(2, 4))).toInt();
                        int birthDay = new StringOps(Predef$.MODULE$.augmentString(pp.birthDatePart().toString().substring(0, 2))).toInt();
                        Pic candidate = new Pic(pp.cleanedInput(), (Gender)gender, birthYear, birthMonth, birthDay);
                        try_ = Try$.MODULE$.apply((Function0)new Serializable(candidate){
                            public static final long serialVersionUID = 0L;
                            private final Pic candidate$1;

                            public final LocalDate apply() {
                                return this.candidate$1.birthDate();
                            }
                            {
                                this.candidate$1 = candidate$1;
                            }
                        });
                        if (!(try_ instanceof Success)) break block9;
                        right = package$.MODULE$.Right().apply((Object)candidate);
                        break block10;
                    }
                    if (!(try_ instanceof Failure)) break block11;
                    right = package$.MODULE$.Left().apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid PIC: '", "'. The birth date is impossible, this day does not exist on the calendar: '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pp.originalInput(), pp.birthDatePart()})));
                }
                left = right;
            }
            return left;
        }
        throw new MatchError((Object)try_);
    }

    public char[] controlChars() {
        return this.controlChars;
    }

    public char calculateExpectedControlCharacter(long input) {
        int remainder = (int)(input % 31L);
        return this.controlChars()[remainder];
    }

    private Pic$() {
        MODULE$ = this;
        Parsable$class.$init$(this);
        this.finnishLegalAge = 18;
        this.birthDatePartMustBeNumeric = new Pic.ValidationRule((Function1<Pic.PicParts, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Pic.PicParts pp) {
                return pp.birthDatePart().matches("\\d{6}");
            }
        }, (Function1<Pic.PicParts, String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Pic.PicParts pp) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid PIC: '", "'. The first six characters have to be numeric, but they were: '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pp.originalInput(), pp.birthDatePart()}));
            }
        });
        this.dayOfBirthDatePartMustBeInRangeOf1To31 = new Pic.ValidationRule((Function1<Pic.PicParts, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Pic.PicParts pp) {
                int day = new StringOps(Predef$.MODULE$.augmentString(pp.birthDatePart().substring(0, 2))).toInt();
                return day >= 1 && day <= 31;
            }
        }, (Function1<Pic.PicParts, String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Pic.PicParts pp) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid PIC: '", "'. The day part of the birth date is wrong: it should be 01-31, but was: '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pp.originalInput(), pp.birthDatePart().substring(0, 2)}));
            }
        });
        this.monthOfBirthDatePartMustBeInRangeOf1To12 = new Pic.ValidationRule((Function1<Pic.PicParts, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Pic.PicParts pp) {
                int month = new StringOps(Predef$.MODULE$.augmentString(pp.birthDatePart().substring(2, 4))).toInt();
                return month >= 1 && month <= 12;
            }
        }, (Function1<Pic.PicParts, String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Pic.PicParts pp) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid PIC: '", "'. The month part of the birth date is wrong: it should be 01-12, but was: '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pp.originalInput(), pp.birthDatePart().substring(2, 4)}));
            }
        });
        this.signMustHaveAcceptableValue = new Pic.ValidationRule((Function1<Pic.PicParts, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Pic.PicParts pp) {
                return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapCharArray(new char[]{'+', '-', 'A'})).contains((Object)BoxesRunTime.boxToCharacter((char)pp.sign().charAt(0)));
            }
        }, (Function1<Pic.PicParts, String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Pic.PicParts pp) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid PIC: '", "'. The sign (7th character) must be +, - or A, now it was: '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pp.originalInput(), pp.sign()}));
            }
        });
        this.individualNumberMustBeNumeric = new Pic.ValidationRule((Function1<Pic.PicParts, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Pic.PicParts pp) {
                return Try$.MODULE$.apply((Function0)new Serializable(this, pp){
                    public static final long serialVersionUID = 0L;
                    private final Pic.PicParts pp$2;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return new StringOps(Predef$.MODULE$.augmentString(this.pp$2.individualNumber())).toInt();
                    }
                    {
                        this.pp$2 = pp$2;
                    }
                }).toOption().isDefined();
            }
        }, (Function1<Pic.PicParts, String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Pic.PicParts pp) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid PIC: '", "'. The individual number (characters 8-10) must be numeric, now it was: '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pp.originalInput(), pp.individualNumber()}));
            }
        });
        this.validationRules = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pic.ValidationRule[]{this.birthDatePartMustBeNumeric(), this.dayOfBirthDatePartMustBeInRangeOf1To31(), this.monthOfBirthDatePartMustBeInRangeOf1To12(), this.signMustHaveAcceptableValue(), this.individualNumberMustBeNumeric()}));
        this.controlChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'H', 'J', 'K', 'L', 'M', 'N', 'P', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y'};
    }
}

