/*
 * Decompiled with CFR 0.152.
 */
package org.finnpic.businessid;

import org.finnpic.Parsable;
import org.finnpic.Parsable$class;
import org.finnpic.businessid.BusinessId;
import org.finnpic.businessid.BusinessId$ChecksumOk$;
import org.finnpic.businessid.BusinessId$SumMod11ResultsIn1$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.runtime.RichInt$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class BusinessId$
implements Parsable<BusinessId> {
    public static final BusinessId$ MODULE$;

    static {
        new BusinessId$();
    }

    @Override
    public Object fromStringUnsafe(String input) {
        return Parsable$class.fromStringUnsafe(this, input);
    }

    @Override
    public Object fromStringU(String input) {
        return Parsable$class.fromStringU(this, input);
    }

    public Either<String, BusinessId> apply(String input) {
        return this.fromString(input);
    }

    @Override
    public Either<String, BusinessId> fromString(String input) {
        String string;
        block4: {
            Left left;
            block3: {
                String string2;
                String canonized;
                block2: {
                    String string3;
                    canonized = input.trim();
                    string = canonized;
                    if (string == null || (string3 = string).length() == 9) break block2;
                    left = package$.MODULE$.Left().apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid business id: ''. Business id should have 9 characters, but was 0 characters."})).s((Seq)Nil$.MODULE$));
                    break block3;
                }
                if (string == null || (string2 = string).length() != 9) break block4;
                left = this.createFromStringOfCorrectLength(input, canonized);
            }
            return left;
        }
        throw new MatchError((Object)string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Either<String, BusinessId> createFromStringOfCorrectLength(String originalInput, String canonizedInput) {
        Right right;
        Predef$.MODULE$.assert(canonizedInput.length() == 9);
        if (canonizedInput.matches("[\\d]{7}-[\\d]")) {
            Right right2;
            BusinessId.ChecksumValidationResult checksumValidationResult = this.checksum(canonizedInput);
            if (BusinessId$ChecksumOk$.MODULE$.equals(checksumValidationResult)) {
                right2 = package$.MODULE$.Right().apply((Object)new BusinessId(canonizedInput));
            } else if (checksumValidationResult instanceof BusinessId.InvalidChecksumDigitInInput) {
                BusinessId.InvalidChecksumDigitInInput invalidChecksumDigitInInput = (BusinessId.InvalidChecksumDigitInInput)checksumValidationResult;
                int was = invalidChecksumDigitInInput.was();
                int shouldHaveBeen = invalidChecksumDigitInInput.shouldHaveBeen();
                right2 = package$.MODULE$.Left().apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid business id: '", "'. The checksum character '", "' is wrong: it should be '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{originalInput, BoxesRunTime.boxToInteger((int)was), BoxesRunTime.boxToInteger((int)shouldHaveBeen)})));
            } else {
                if (!BusinessId$SumMod11ResultsIn1$.MODULE$.equals(checksumValidationResult)) throw new MatchError((Object)checksumValidationResult);
                right2 = package$.MODULE$.Left().apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid business id: '", "'. The checksum value of 1 is not allowed."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{originalInput})));
            }
            right = right2;
            return right;
        } else {
            right = package$.MODULE$.Left().apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid business id: '", "'. Business id should contain only digits and a dash."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{originalInput})));
        }
        return right;
    }

    public BusinessId.ChecksumValidationResult checksum(String input) {
        Left left;
        block11: {
            BusinessId.ChecksumValidationResult checksumValidationResult;
            block9: {
                Right right;
                boolean bl;
                int inputChecksumDigit;
                block10: {
                    block8: {
                        BusinessId.ChecksumValidationResult invalidResult;
                        Left left2;
                        List weights = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 9, 10, 5, 8, 4, 2}));
                        int[] numbers = (int[])Predef$.MODULE$.charArrayOps(input.substring(0, 7).toCharArray()).map((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final int apply(char x$1) {
                                return RichChar$.MODULE$.asDigit$extension(Predef$.MODULE$.charWrapper(x$1));
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
                        scala.collection.immutable.Seq zipped = (scala.collection.immutable.Seq)weights.zip((GenIterable)Predef$.MODULE$.wrapIntArray(numbers), List$.MODULE$.canBuildFrom());
                        scala.collection.immutable.Seq multiplied = (scala.collection.immutable.Seq)zipped.map((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final int apply(Tuple2<Object, Object> x0$1) {
                                Tuple2<Object, Object> tuple2 = x0$1;
                                if (tuple2 != null) {
                                    int w = tuple2._1$mcI$sp();
                                    int n = tuple2._2$mcI$sp();
                                    int n2 = w * n;
                                    return n2;
                                }
                                throw new MatchError(tuple2);
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        int sum = BoxesRunTime.unboxToInt((Object)multiplied.sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                        int sumMod11 = sum % 11;
                        inputChecksumDigit = RichChar$.MODULE$.asDigit$extension(Predef$.MODULE$.charWrapper(input.charAt(input.length() - 1)));
                        int n = sumMod11;
                        switch (n) {
                            default: {
                                if (RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(2), 10).contains(n)) {
                                    left2 = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)(11 - n)));
                                    break;
                                }
                                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                            }
                            case 1: {
                                left2 = package$.MODULE$.Left().apply((Object)BusinessId$SumMod11ResultsIn1$.MODULE$);
                                break;
                            }
                            case 0: {
                                left2 = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)0));
                            }
                        }
                        Left expectedChecksumDigit = left2;
                        bl = false;
                        right = null;
                        left = expectedChecksumDigit;
                        if (!(left instanceof Left)) break block8;
                        Left left3 = left;
                        checksumValidationResult = invalidResult = (BusinessId.ChecksumValidationResult)left3.a();
                        break block9;
                    }
                    if (!(left instanceof Right)) break block10;
                    bl = true;
                    right = (Right)left;
                    int expectedDigit = BoxesRunTime.unboxToInt((Object)right.b());
                    if (inputChecksumDigit != expectedDigit) break block10;
                    checksumValidationResult = BusinessId$ChecksumOk$.MODULE$;
                    break block9;
                }
                if (!bl) break block11;
                int expectedDigit = BoxesRunTime.unboxToInt((Object)right.b());
                checksumValidationResult = new BusinessId.InvalidChecksumDigitInInput(inputChecksumDigit, expectedDigit);
            }
            return checksumValidationResult;
        }
        throw new MatchError((Object)left);
    }

    private BusinessId$() {
        MODULE$ = this;
        Parsable$class.$init$(this);
    }
}

