/*
 * Decompiled with CFR 0.152.
 */
package org.finos.legend.sdlc.entities;

import java.io.File;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.impl.utility.Iterate;
import org.finos.legend.sdlc.entities.EntityReserializer;
import org.finos.legend.sdlc.serialization.EntitySerializer;
import org.finos.legend.sdlc.serialization.EntitySerializers;
import org.finos.legend.sdlc.serialization.EntityTextSerializer;

@Mojo(name="process-entities", defaultPhase=LifecyclePhase.COMPILE)
public class EntityMojo
extends AbstractMojo {
    @Parameter
    public List<SourceDirectory> sourceDirectories;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    public File outputDirectory;
    @Parameter(defaultValue="${project.basedir}", readonly=true)
    public File baseDir;

    public void execute() throws MojoExecutionException {
        long start = System.nanoTime();
        this.getLog().info((CharSequence)"Starting entity processing");
        this.getLog().info((CharSequence)("source directories: " + this.sourceDirectories));
        this.getLog().info((CharSequence)("output directory: " + this.outputDirectory));
        this.getLog().info((CharSequence)("base directory: " + this.baseDir));
        EntityTextSerializer outputSerializer = EntitySerializers.getDefaultJsonSerializer();
        List<SerializationSpec> serializationSpecs = this.getSerializationSpecs();
        int totalCount = 0;
        for (SerializationSpec serializationSpec : serializationSpecs) {
            long sourceEnd;
            long sourceStart = System.nanoTime();
            this.getLog().info((CharSequence)("Reserializing entities from " + serializationSpec.directory + " using serializer \"" + serializationSpec.serializer.getName() + "\" to " + this.outputDirectory));
            EntityReserializer reserializer = EntityReserializer.newReserializer(serializationSpec.serializer, (EntitySerializer)outputSerializer);
            Predicate<Path> filter = serializationSpec.fileExtensions == null ? null : EntityReserializer.getExtensionsFilter(serializationSpec.fileExtensions);
            try {
                List<String> paths = reserializer.reserializeDirectoryTree(serializationSpec.directory, filter, this.outputDirectory.toPath());
                sourceEnd = System.nanoTime();
                this.getLog().info((CharSequence)String.format("Finished reserializing %,d entities from %s using serializer \"%s\" to %s (%.9fs)", paths.size(), serializationSpec.directory, serializationSpec.serializer.getName(), this.outputDirectory, EntityMojo.nanoDuration(sourceStart, sourceEnd)));
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)Iterate.makeString(paths, (String)"Reserialized: ", (String)", ", (String)""));
                }
                totalCount += paths.size();
            }
            catch (Exception e) {
                sourceEnd = System.nanoTime();
                this.getLog().info((CharSequence)String.format("Error reserializing entities from %s using serializer \"%s\" to %s (%.9fs)", serializationSpec.directory, serializationSpec.serializer.getName(), this.outputDirectory, EntityMojo.nanoDuration(sourceStart, sourceEnd)), (Throwable)e);
                StringBuilder builder = new StringBuilder("Error reserializing entities from ").append(serializationSpec.directory).append(" using serializer \"").append(serializationSpec.serializer.getName()).append('\"').append(" to ").append(this.outputDirectory);
                String eMessage = e.getMessage();
                if (eMessage != null) {
                    builder.append(": ").append(eMessage);
                }
                throw new MojoExecutionException(builder.toString(), e);
            }
        }
        long end = System.nanoTime();
        this.getLog().info((CharSequence)String.format("Finished processing %,d entities (%.9fs)", totalCount, EntityMojo.nanoDuration(start, end)));
    }

    private List<SerializationSpec> getSerializationSpecs() throws MojoExecutionException {
        Map entitySerializers = EntitySerializers.getAvailableSerializersByName();
        if (this.sourceDirectories == null) {
            return this.getDefaultSerializationSpecs(entitySerializers);
        }
        MutableList serializationSpecs = Lists.mutable.empty();
        for (SourceDirectory sourceDirectory : this.sourceDirectories) {
            SerializationSpec serializationSpec = this.getSerializationSpec(sourceDirectory, entitySerializers);
            serializationSpecs.add(serializationSpec);
        }
        return serializationSpecs;
    }

    private SerializationSpec getSerializationSpec(SourceDirectory sourceDirectory, Map<String, EntitySerializer> entitySerializers) throws MojoExecutionException {
        EntitySerializer serializer;
        Path dir = this.resolveSourceDirectoryPath(sourceDirectory);
        String serializerName = sourceDirectory.serializer;
        if (serializerName == null || serializerName.isEmpty()) {
            serializerName = sourceDirectory.directory.getName();
        }
        if ((serializer = entitySerializers.get(serializerName)) == null) {
            throw new MojoExecutionException("Unknown entity serializer: " + serializerName);
        }
        return new SerializationSpec(dir, serializer, sourceDirectory.extensions);
    }

    private Path resolveSourceDirectoryPath(SourceDirectory sourceDirectory) throws MojoExecutionException {
        BasicFileAttributes attributes;
        Path path = this.baseDir.toPath().resolve(sourceDirectory.directory.toPath());
        try {
            attributes = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (NoSuchFileException e) {
            return path;
        }
        catch (Exception e) {
            StringBuilder builder = new StringBuilder("Error accessing source directory \"").append(sourceDirectory.directory).append("\" (").append(path).append(')');
            String eMessage = e.getMessage();
            if (eMessage != null) {
                builder.append(": ").append(eMessage);
            }
            throw new MojoExecutionException(builder.toString(), e);
        }
        if (!attributes.isDirectory()) {
            throw new MojoExecutionException("Invalid source directory \"" + sourceDirectory.directory + "\": " + path + " is not a directory");
        }
        return path;
    }

    private List<SerializationSpec> getDefaultSerializationSpecs(Map<String, EntitySerializer> entitySerializers) throws MojoExecutionException {
        MutableList mutableList;
        block11: {
            Path srcMain = this.baseDir.toPath().resolve("src").resolve("main");
            if (!Files.isDirectory(srcMain, new LinkOption[0])) {
                this.getLog().info((CharSequence)"using default source directories: []");
                return Collections.emptyList();
            }
            DirectoryStream<Path> dirStream = Files.newDirectoryStream(srcMain, x$0 -> Files.isDirectory(x$0, new LinkOption[0]));
            try {
                MutableList serializationSpecs = Lists.mutable.empty();
                for (Path dir : dirStream) {
                    EntitySerializer serializer = entitySerializers.get(dir.getFileName().toString());
                    if (serializer == null) continue;
                    serializationSpecs.add(new SerializationSpec(dir, serializer));
                }
                this.getLog().info((CharSequence)("using default source directories: " + serializationSpecs));
                mutableList = serializationSpecs;
                if (dirStream == null) break block11;
            }
            catch (Throwable serializationSpecs) {
                try {
                    if (dirStream != null) {
                        try {
                            dirStream.close();
                        }
                        catch (Throwable throwable) {
                            serializationSpecs.addSuppressed(throwable);
                        }
                    }
                    throw serializationSpecs;
                }
                catch (Exception e) {
                    StringBuilder builder = new StringBuilder("Error accessing source directories");
                    String eMessage = e.getMessage();
                    if (eMessage != null) {
                        builder.append(": ").append(eMessage);
                    }
                    throw new MojoExecutionException(builder.toString(), e);
                }
            }
            dirStream.close();
        }
        return mutableList;
    }

    private static double nanoDuration(long nanoStart, long nanoEnd) {
        return (double)(nanoEnd - nanoStart) / 1.0E9;
    }

    private static class SerializationSpec {
        private final Path directory;
        private final EntitySerializer serializer;
        private final Set<String> fileExtensions;

        private SerializationSpec(Path directory, EntitySerializer serializer, Set<String> fileExtensions) {
            this.directory = directory;
            this.serializer = serializer;
            this.fileExtensions = fileExtensions;
        }

        private SerializationSpec(Path directory, EntitySerializer serializer) {
            this(directory, serializer, (Set<String>)null);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("<directory=").append(this.directory);
            if (this.serializer != null) {
                builder.append(" serializer=\"").append(this.serializer.getName()).append('\"');
            }
            if (this.fileExtensions != null) {
                builder.append(" fileExtensions=");
                if (this.fileExtensions.isEmpty()) {
                    builder.append("[]");
                } else {
                    Iterate.appendString(this.fileExtensions, (Appendable)builder, (String)"[\"", (String)"\", \"", (String)"\"]");
                }
            }
            return builder.append('>').toString();
        }
    }

    public static class SourceDirectory {
        @Parameter(required=true)
        public File directory;
        @Parameter
        public String serializer;
        @Parameter
        public Set<String> extensions;

        public String toString() {
            StringBuilder builder = new StringBuilder("<directory=").append(this.directory);
            if (this.serializer != null) {
                builder.append(" serializer=\"").append(this.serializer).append('\"');
            }
            if (this.extensions != null) {
                builder.append(" fileExtensions=");
                if (this.extensions.isEmpty()) {
                    builder.append("[]");
                } else {
                    Iterate.appendString(this.extensions, (Appendable)builder, (String)"[\"", (String)"\", \"", (String)"\"]");
                }
            }
            return builder.append('>').toString();
        }
    }
}

