/*
 * Decompiled with CFR 0.152.
 */
package org.finos.legend.sdlc.serialization;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.finos.legend.sdlc.domain.model.entity.Entity;
import org.finos.legend.sdlc.serialization.EntitySerializer;

public interface EntityTextSerializer
extends EntitySerializer {
    public void serialize(Entity var1, Writer var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    default public void serialize(Entity entity, OutputStream stream) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(stream, StandardCharsets.UTF_8);
        try {
            this.serialize(entity, writer);
        }
        finally {
            writer.flush();
        }
    }

    default public String serializeToString(Entity entity) throws IOException {
        StringWriter writer = new StringWriter();
        this.serialize(entity, writer);
        return writer.toString();
    }

    public Entity deserialize(Reader var1) throws IOException;

    @Override
    default public Entity deserialize(InputStream stream) throws IOException {
        return this.deserialize(new InputStreamReader(stream, StandardCharsets.UTF_8));
    }

    default public Entity deserialize(String content) throws IOException {
        return this.deserialize(new StringReader(content));
    }
}

