/*
 * Decompiled with CFR 0.152.
 */
package org.finos.legend.sdlc.serialization;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.StreamReadFeature;
import com.fasterxml.jackson.core.StreamWriteFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import org.finos.legend.sdlc.domain.model.entity.Entity;
import org.finos.legend.sdlc.serialization.EntityTextSerializer;

public class DefaultJsonEntitySerializer
implements EntityTextSerializer {
    private static final JsonMapper JSON_MAPPER = (JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().enable(new SerializationFeature[]{SerializationFeature.INDENT_OUTPUT})).enable(new SerializationFeature[]{SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS})).enable(new MapperFeature[]{MapperFeature.SORT_PROPERTIES_ALPHABETICALLY})).disable(new StreamWriteFeature[]{StreamWriteFeature.AUTO_CLOSE_TARGET})).disable(new StreamReadFeature[]{StreamReadFeature.AUTO_CLOSE_SOURCE})).build();
    private static final JavaType ENTITY_FILE_TYPE = JSON_MAPPER.getTypeFactory().constructType(EntityFile.class);

    @Override
    public String getName() {
        return "legend";
    }

    @Override
    public String getDefaultFileExtension() {
        return "json";
    }

    @Override
    public boolean canSerialize(Entity entity) {
        return true;
    }

    @Override
    public void serialize(Entity entity, OutputStream stream) throws IOException {
        JSON_MAPPER.writeValue(stream, (Object)DefaultJsonEntitySerializer.toEntityFile(entity));
    }

    @Override
    public void serialize(Entity entity, Writer writer) throws IOException {
        JSON_MAPPER.writeValue(writer, (Object)DefaultJsonEntitySerializer.toEntityFile(entity));
    }

    @Override
    public byte[] serializeToBytes(Entity entity) throws IOException {
        return JSON_MAPPER.writeValueAsBytes((Object)DefaultJsonEntitySerializer.toEntityFile(entity));
    }

    @Override
    public String serializeToString(Entity entity) throws IOException {
        return JSON_MAPPER.writeValueAsString((Object)DefaultJsonEntitySerializer.toEntityFile(entity));
    }

    @Override
    public Entity deserialize(InputStream stream) throws IOException {
        return DefaultJsonEntitySerializer.toEntity((EntityFile)JSON_MAPPER.readValue(stream, ENTITY_FILE_TYPE));
    }

    @Override
    public Entity deserialize(Reader reader) throws IOException {
        return DefaultJsonEntitySerializer.toEntity((EntityFile)JSON_MAPPER.readValue(reader, ENTITY_FILE_TYPE));
    }

    @Override
    public Entity deserialize(byte[] content) throws IOException {
        return DefaultJsonEntitySerializer.toEntity((EntityFile)JSON_MAPPER.readValue(content, ENTITY_FILE_TYPE));
    }

    @Override
    public Entity deserialize(String content) throws IOException {
        return DefaultJsonEntitySerializer.toEntity((EntityFile)JSON_MAPPER.readValue(content, ENTITY_FILE_TYPE));
    }

    private static EntityFile toEntityFile(Entity entity) {
        return EntityFile.newEntityFile(entity.getClassifierPath(), entity.getContent());
    }

    private static Entity toEntity(EntityFile entityFile) {
        return Entity.newEntity((String)DefaultJsonEntitySerializer.computeEntityPath(entityFile), (String)entityFile.classifierPath, (Map)entityFile.content);
    }

    private static String computeEntityPath(EntityFile entityFile) {
        Object name;
        Map content = entityFile.content;
        if (content != null && (name = content.get("name")) instanceof String) {
            Object pkg = content.get("package");
            if (pkg == null) {
                return (String)name;
            }
            if (pkg instanceof String) {
                return pkg + "::" + name;
            }
        }
        throw new RuntimeException("Could not compute entity path");
    }

    private static class EntityFile {
        @JsonProperty
        private final String classifierPath;
        @JsonProperty
        private final Map<String, ?> content;

        private EntityFile(String classifierPath, Map<String, ?> content) {
            this.classifierPath = classifierPath;
            this.content = content;
        }

        @JsonCreator
        static EntityFile newEntityFile(@JsonProperty(value="classifierPath") String classifierPath, @JsonProperty(value="content") Map<String, ?> content) {
            return new EntityFile(classifierPath, content);
        }
    }
}

