/*
 * Decompiled with CFR 0.152.
 */
package org.finos.legend.sdlc.serialization;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.finos.legend.sdlc.serialization.DefaultJsonEntitySerializer;
import org.finos.legend.sdlc.serialization.EntitySerializer;
import org.finos.legend.sdlc.serialization.EntityTextSerializer;

public class EntitySerializers {
    private EntitySerializers() {
    }

    public static EntityTextSerializer getDefaultJsonSerializer() {
        return new DefaultJsonEntitySerializer();
    }

    public static Iterable<EntitySerializer> getAvailableSerializers() {
        ArrayList<EntitySerializer> serializers = new ArrayList<EntitySerializer>();
        ServiceLoader.load(EntitySerializer.class).forEach(serializers::add);
        return serializers;
    }

    public static Iterable<EntityTextSerializer> getAvailableTextSerializers() {
        ArrayList<EntityTextSerializer> serializers = new ArrayList<EntityTextSerializer>();
        ServiceLoader.load(EntitySerializer.class).forEach(s -> {
            if (s instanceof EntityTextSerializer) {
                serializers.add((EntityTextSerializer)s);
            }
        });
        return serializers;
    }

    public static Map<String, EntitySerializer> getAvailableSerializersByName() {
        HashMap<String, EntitySerializer> result = new HashMap<String, EntitySerializer>();
        ServiceLoader.load(EntitySerializer.class).forEach(s -> {
            String name = s.getName();
            EntitySerializer old = result.put(name, (EntitySerializer)s);
            if (old != null) {
                throw new IllegalArgumentException("Multiple serializers named \"" + name + "\"");
            }
        });
        return result;
    }

    public static Map<String, EntityTextSerializer> getAvailableTextSerializersByName() {
        HashMap<String, EntityTextSerializer> result = new HashMap<String, EntityTextSerializer>();
        ServiceLoader.load(EntitySerializer.class).forEach(s -> {
            String name;
            EntitySerializer old;
            if (s instanceof EntityTextSerializer && (old = (EntitySerializer)result.put(name = s.getName(), (EntityTextSerializer)s)) != null) {
                throw new IllegalArgumentException("Multiple serializers named \"" + name + "\"");
            }
        });
        return result;
    }
}

