/*
 * Decompiled with CFR 0.152.
 */
package org.finos.legend.sdlc.serialization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.finos.legend.sdlc.domain.model.entity.Entity;

public interface EntitySerializer {
    public String getName();

    public String getDefaultFileExtension();

    public boolean canSerialize(Entity var1);

    public void serialize(Entity var1, OutputStream var2) throws IOException;

    default public byte[] serializeToBytes(Entity entity) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.serialize(entity, stream);
        return stream.toByteArray();
    }

    public Entity deserialize(InputStream var1) throws IOException;

    default public Entity deserialize(byte[] content) throws IOException {
        return this.deserialize(new ByteArrayInputStream(content));
    }
}

