/*
 * Decompiled with CFR 0.152.
 */
package org.finos.legend.sdlc.serialization;

import java.util.Map;
import java.util.ServiceLoader;
import org.eclipse.collections.api.factory.Maps;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.impl.utility.LazyIterate;
import org.finos.legend.sdlc.serialization.DefaultJsonEntitySerializer;
import org.finos.legend.sdlc.serialization.EntitySerializer;
import org.finos.legend.sdlc.serialization.EntityTextSerializer;

public class EntitySerializers {
    private EntitySerializers() {
    }

    public static EntityTextSerializer getDefaultJsonSerializer() {
        return new DefaultJsonEntitySerializer();
    }

    public static Iterable<EntitySerializer> getAvailableSerializers() {
        return ServiceLoader.load(EntitySerializer.class);
    }

    public static Iterable<EntityTextSerializer> getAvailableTextSerializers() {
        return LazyIterate.selectInstancesOf(EntitySerializers.getAvailableSerializers(), EntityTextSerializer.class);
    }

    public static Map<String, EntitySerializer> getAvailableSerializersByName() {
        return EntitySerializers.indexByName(EntitySerializers.getAvailableSerializers());
    }

    public static Map<String, EntityTextSerializer> getAvailableTextSerializersByName() {
        return EntitySerializers.indexByName(EntitySerializers.getAvailableTextSerializers());
    }

    private static <T extends EntitySerializer> Map<String, T> indexByName(Iterable<T> serializers) {
        MutableMap result = Maps.mutable.empty();
        for (EntitySerializer serializer : serializers) {
            String name = serializer.getName();
            EntitySerializer old = result.put(name, serializer);
            if (old == null) continue;
            throw new IllegalArgumentException("Multiple serializers named \"" + name + "\"");
        }
        return result;
    }
}

