/*
 * Decompiled with CFR 0.152.
 */
package org.finos.legend.sdlc.serialization;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import org.finos.legend.sdlc.domain.model.entity.Entity;

public interface EntitySerializer {
    public String getName();

    public String getDefaultFileExtension();

    public boolean canSerialize(Entity var1);

    public void serialize(Entity var1, OutputStream var2) throws IOException;

    default public byte[] serializeToBytes(Entity entity) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.serialize(entity, stream);
        return stream.toByteArray();
    }

    default public Path serializeToFile(Entity entity, Path rootDirectory, OpenOption ... openOptions) throws IOException {
        return this.serializeToFile(entity, rootDirectory, this.getDefaultFileExtension(), openOptions);
    }

    default public Path serializeToFile(Entity entity, Path rootDirectory, String fileExtension, OpenOption ... openOptions) throws IOException {
        Path filePath = this.filePathForEntity(entity, rootDirectory, fileExtension);
        Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
        try (BufferedOutputStream stream = new BufferedOutputStream(Files.newOutputStream(filePath, openOptions));){
            this.serialize(entity, stream);
        }
        return filePath;
    }

    default public Path filePathForEntity(Entity entity, Path rootDirectory) {
        return this.filePathForEntity(entity, rootDirectory, this.getDefaultFileExtension());
    }

    default public Path filePathForEntity(Entity entity, Path rootDirectory, String extension) {
        String relativePath = entity.getPath().replace("::", rootDirectory.getFileSystem().getSeparator()) + (extension == null ? "" : "." + extension);
        return rootDirectory.resolve(relativePath);
    }

    public Entity deserialize(InputStream var1) throws IOException;

    default public Entity deserialize(byte[] content) throws IOException {
        return this.deserialize(new ByteArrayInputStream(content));
    }

    default public List<Entity> deserializeMany(InputStream stream) throws IOException {
        return Collections.singletonList(this.deserialize(stream));
    }

    default public List<Entity> deserializeMany(byte[] content) throws IOException {
        return this.deserializeMany(new ByteArrayInputStream(content));
    }
}

