// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: tracdap/api/data.proto

package org.finos.tracdap.api;

/**
 * <pre>
 **
 * Request to create or update a FILE and store content to the platform.
 * &#64;see TracDataApi.createFile
 * &#64;see TracDataApi.updateFile
 * </pre>
 *
 * Protobuf type {@code tracdap.api.FileWriteRequest}
 */
public final class FileWriteRequest extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:tracdap.api.FileWriteRequest)
    FileWriteRequestOrBuilder {
private static final long serialVersionUID = 0L;
  // Use FileWriteRequest.newBuilder() to construct.
  private FileWriteRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private FileWriteRequest() {
    tenant_ = "";
    tagUpdates_ = java.util.Collections.emptyList();
    name_ = "";
    mimeType_ = "";
    content_ = com.google.protobuf.ByteString.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new FileWriteRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return org.finos.tracdap.api.Data.internal_static_tracdap_api_FileWriteRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return org.finos.tracdap.api.Data.internal_static_tracdap_api_FileWriteRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            org.finos.tracdap.api.FileWriteRequest.class, org.finos.tracdap.api.FileWriteRequest.Builder.class);
  }

  private int bitField0_;
  public static final int TENANT_FIELD_NUMBER = 1;
  @SuppressWarnings("serial")
  private volatile java.lang.Object tenant_ = "";
  /**
   * <pre>
   **
   * Tenant code for the requested operation, always required
   * </pre>
   *
   * <code>string tenant = 1;</code>
   * @return The tenant.
   */
  @java.lang.Override
  public java.lang.String getTenant() {
    java.lang.Object ref = tenant_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      tenant_ = s;
      return s;
    }
  }
  /**
   * <pre>
   **
   * Tenant code for the requested operation, always required
   * </pre>
   *
   * <code>string tenant = 1;</code>
   * @return The bytes for tenant.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getTenantBytes() {
    java.lang.Object ref = tenant_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      tenant_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PRIORVERSION_FIELD_NUMBER = 2;
  private org.finos.tracdap.metadata.TagSelector priorVersion_;
  /**
   * <pre>
   **
   * Prior object/tag version to use for update operations
   * This field should be omitted when creating a new file.
   * </pre>
   *
   * <code>optional .tracdap.metadata.TagSelector priorVersion = 2;</code>
   * @return Whether the priorVersion field is set.
   */
  @java.lang.Override
  public boolean hasPriorVersion() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   * <pre>
   **
   * Prior object/tag version to use for update operations
   * This field should be omitted when creating a new file.
   * </pre>
   *
   * <code>optional .tracdap.metadata.TagSelector priorVersion = 2;</code>
   * @return The priorVersion.
   */
  @java.lang.Override
  public org.finos.tracdap.metadata.TagSelector getPriorVersion() {
    return priorVersion_ == null ? org.finos.tracdap.metadata.TagSelector.getDefaultInstance() : priorVersion_;
  }
  /**
   * <pre>
   **
   * Prior object/tag version to use for update operations
   * This field should be omitted when creating a new file.
   * </pre>
   *
   * <code>optional .tracdap.metadata.TagSelector priorVersion = 2;</code>
   */
  @java.lang.Override
  public org.finos.tracdap.metadata.TagSelectorOrBuilder getPriorVersionOrBuilder() {
    return priorVersion_ == null ? org.finos.tracdap.metadata.TagSelector.getDefaultInstance() : priorVersion_;
  }

  public static final int TAGUPDATES_FIELD_NUMBER = 3;
  @SuppressWarnings("serial")
  private java.util.List<org.finos.tracdap.metadata.TagUpdate> tagUpdates_;
  /**
   * <pre>
   **
   * Tag update operations to be applied
   * Tag updates are applied in exactly the same way as for metadata write requests.
   * &#64;see MetadataWriteRequest
   * &#64;see TracMetadataApi
   * </pre>
   *
   * <code>repeated .tracdap.metadata.TagUpdate tagUpdates = 3;</code>
   */
  @java.lang.Override
  public java.util.List<org.finos.tracdap.metadata.TagUpdate> getTagUpdatesList() {
    return tagUpdates_;
  }
  /**
   * <pre>
   **
   * Tag update operations to be applied
   * Tag updates are applied in exactly the same way as for metadata write requests.
   * &#64;see MetadataWriteRequest
   * &#64;see TracMetadataApi
   * </pre>
   *
   * <code>repeated .tracdap.metadata.TagUpdate tagUpdates = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends org.finos.tracdap.metadata.TagUpdateOrBuilder> 
      getTagUpdatesOrBuilderList() {
    return tagUpdates_;
  }
  /**
   * <pre>
   **
   * Tag update operations to be applied
   * Tag updates are applied in exactly the same way as for metadata write requests.
   * &#64;see MetadataWriteRequest
   * &#64;see TracMetadataApi
   * </pre>
   *
   * <code>repeated .tracdap.metadata.TagUpdate tagUpdates = 3;</code>
   */
  @java.lang.Override
  public int getTagUpdatesCount() {
    return tagUpdates_.size();
  }
  /**
   * <pre>
   **
   * Tag update operations to be applied
   * Tag updates are applied in exactly the same way as for metadata write requests.
   * &#64;see MetadataWriteRequest
   * &#64;see TracMetadataApi
   * </pre>
   *
   * <code>repeated .tracdap.metadata.TagUpdate tagUpdates = 3;</code>
   */
  @java.lang.Override
  public org.finos.tracdap.metadata.TagUpdate getTagUpdates(int index) {
    return tagUpdates_.get(index);
  }
  /**
   * <pre>
   **
   * Tag update operations to be applied
   * Tag updates are applied in exactly the same way as for metadata write requests.
   * &#64;see MetadataWriteRequest
   * &#64;see TracMetadataApi
   * </pre>
   *
   * <code>repeated .tracdap.metadata.TagUpdate tagUpdates = 3;</code>
   */
  @java.lang.Override
  public org.finos.tracdap.metadata.TagUpdateOrBuilder getTagUpdatesOrBuilder(
      int index) {
    return tagUpdates_.get(index);
  }

  public static final int NAME_FIELD_NUMBER = 4;
  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   * <pre>
   **
   * File name of the file being saved, always required
   * Must be a valid file name with no path component (i.e. the name may not contain slashes).
   * If the name contains a period character, the file extension will be set as the
   * portion of the name following the last period. Otherwise the file extension will be blank.
   * For update requests the name may change but the extension must stay the same. E.g. a file
   * can be created as "my_file_v1.txt" and updated as "my_file_v2.txt", but updating with the
   * name as "my_file_v1.doc" would not be allowed. Attempting to change the extension in an
   * update will result in an error status of FAILED_PRECONDITION.
   * Fle name and extension are stored in the file definition, and in the trac_file_name
   * and trac_file_extension attributes.
   * </pre>
   *
   * <code>string name = 4;</code>
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   * <pre>
   **
   * File name of the file being saved, always required
   * Must be a valid file name with no path component (i.e. the name may not contain slashes).
   * If the name contains a period character, the file extension will be set as the
   * portion of the name following the last period. Otherwise the file extension will be blank.
   * For update requests the name may change but the extension must stay the same. E.g. a file
   * can be created as "my_file_v1.txt" and updated as "my_file_v2.txt", but updating with the
   * name as "my_file_v1.doc" would not be allowed. Attempting to change the extension in an
   * update will result in an error status of FAILED_PRECONDITION.
   * Fle name and extension are stored in the file definition, and in the trac_file_name
   * and trac_file_extension attributes.
   * </pre>
   *
   * <code>string name = 4;</code>
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MIMETYPE_FIELD_NUMBER = 5;
  @SuppressWarnings("serial")
  private volatile java.lang.Object mimeType_ = "";
  /**
   * <pre>
   **
   * Mime type of the file being saved, always required
   * Must be a valid mime type. For update requests, the mime type must match exactly
   * with the mime type supplied when the file was originally created. Attempting to change
   * the mime type in an update will result in an error status of FAILED_PRECONDITION.
   * Mime type is stored in the file definition and in the trac_file_mime_type attribute.
   * </pre>
   *
   * <code>string mimeType = 5;</code>
   * @return The mimeType.
   */
  @java.lang.Override
  public java.lang.String getMimeType() {
    java.lang.Object ref = mimeType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      mimeType_ = s;
      return s;
    }
  }
  /**
   * <pre>
   **
   * Mime type of the file being saved, always required
   * Must be a valid mime type. For update requests, the mime type must match exactly
   * with the mime type supplied when the file was originally created. Attempting to change
   * the mime type in an update will result in an error status of FAILED_PRECONDITION.
   * Mime type is stored in the file definition and in the trac_file_mime_type attribute.
   * </pre>
   *
   * <code>string mimeType = 5;</code>
   * @return The bytes for mimeType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getMimeTypeBytes() {
    java.lang.Object ref = mimeType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      mimeType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SIZE_FIELD_NUMBER = 6;
  private long size_ = 0L;
  /**
   * <pre>
   **
   * Size of the file being saved, if known in advance
   * When a size is supplied, TRAC will check the size against the number of bytes stored.
   * If the stored file size does not match the supplied value, the error will be reported
   * with an error status of DATA_LOSS. When no size is supplied the check cannot be performed.
   * File size is stored in the created file definition and in the trac_file_size attribute.
   * </pre>
   *
   * <code>optional uint64 size = 6;</code>
   * @return Whether the size field is set.
   */
  @java.lang.Override
  public boolean hasSize() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   * <pre>
   **
   * Size of the file being saved, if known in advance
   * When a size is supplied, TRAC will check the size against the number of bytes stored.
   * If the stored file size does not match the supplied value, the error will be reported
   * with an error status of DATA_LOSS. When no size is supplied the check cannot be performed.
   * File size is stored in the created file definition and in the trac_file_size attribute.
   * </pre>
   *
   * <code>optional uint64 size = 6;</code>
   * @return The size.
   */
  @java.lang.Override
  public long getSize() {
    return size_;
  }

  public static final int CONTENT_FIELD_NUMBER = 1000;
  private com.google.protobuf.ByteString content_ = com.google.protobuf.ByteString.EMPTY;
  /**
   * <pre>
   **
   * A chunk of the file content
   * The file content should be sent as a stream of chunks (byte buffers), with one chunk in each message.
   * Empty chunks can be included at any point in the request stream and will be ignored.
   * </pre>
   *
   * <code>bytes content = 1000;</code>
   * @return The content.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getContent() {
    return content_;
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tenant_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, tenant_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getPriorVersion());
    }
    for (int i = 0; i < tagUpdates_.size(); i++) {
      output.writeMessage(3, tagUpdates_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(mimeType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, mimeType_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeUInt64(6, size_);
    }
    if (!content_.isEmpty()) {
      output.writeBytes(1000, content_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tenant_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, tenant_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(2, getPriorVersion());
    }
    for (int i = 0; i < tagUpdates_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(3, tagUpdates_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(mimeType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, mimeType_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeUInt64Size(6, size_);
    }
    if (!content_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream
        .computeBytesSize(1000, content_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof org.finos.tracdap.api.FileWriteRequest)) {
      return super.equals(obj);
    }
    org.finos.tracdap.api.FileWriteRequest other = (org.finos.tracdap.api.FileWriteRequest) obj;

    if (!getTenant()
        .equals(other.getTenant())) return false;
    if (hasPriorVersion() != other.hasPriorVersion()) return false;
    if (hasPriorVersion()) {
      if (!getPriorVersion()
          .equals(other.getPriorVersion())) return false;
    }
    if (!getTagUpdatesList()
        .equals(other.getTagUpdatesList())) return false;
    if (!getName()
        .equals(other.getName())) return false;
    if (!getMimeType()
        .equals(other.getMimeType())) return false;
    if (hasSize() != other.hasSize()) return false;
    if (hasSize()) {
      if (getSize()
          != other.getSize()) return false;
    }
    if (!getContent()
        .equals(other.getContent())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TENANT_FIELD_NUMBER;
    hash = (53 * hash) + getTenant().hashCode();
    if (hasPriorVersion()) {
      hash = (37 * hash) + PRIORVERSION_FIELD_NUMBER;
      hash = (53 * hash) + getPriorVersion().hashCode();
    }
    if (getTagUpdatesCount() > 0) {
      hash = (37 * hash) + TAGUPDATES_FIELD_NUMBER;
      hash = (53 * hash) + getTagUpdatesList().hashCode();
    }
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + MIMETYPE_FIELD_NUMBER;
    hash = (53 * hash) + getMimeType().hashCode();
    if (hasSize()) {
      hash = (37 * hash) + SIZE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getSize());
    }
    hash = (37 * hash) + CONTENT_FIELD_NUMBER;
    hash = (53 * hash) + getContent().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static org.finos.tracdap.api.FileWriteRequest parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static org.finos.tracdap.api.FileWriteRequest parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static org.finos.tracdap.api.FileWriteRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static org.finos.tracdap.api.FileWriteRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static org.finos.tracdap.api.FileWriteRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static org.finos.tracdap.api.FileWriteRequest parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static org.finos.tracdap.api.FileWriteRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static org.finos.tracdap.api.FileWriteRequest parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static org.finos.tracdap.api.FileWriteRequest parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static org.finos.tracdap.api.FileWriteRequest parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static org.finos.tracdap.api.FileWriteRequest parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static org.finos.tracdap.api.FileWriteRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(org.finos.tracdap.api.FileWriteRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   **
   * Request to create or update a FILE and store content to the platform.
   * &#64;see TracDataApi.createFile
   * &#64;see TracDataApi.updateFile
   * </pre>
   *
   * Protobuf type {@code tracdap.api.FileWriteRequest}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:tracdap.api.FileWriteRequest)
      org.finos.tracdap.api.FileWriteRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.finos.tracdap.api.Data.internal_static_tracdap_api_FileWriteRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.finos.tracdap.api.Data.internal_static_tracdap_api_FileWriteRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.finos.tracdap.api.FileWriteRequest.class, org.finos.tracdap.api.FileWriteRequest.Builder.class);
    }

    // Construct using org.finos.tracdap.api.FileWriteRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
        getPriorVersionFieldBuilder();
        getTagUpdatesFieldBuilder();
      }
    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      tenant_ = "";
      priorVersion_ = null;
      if (priorVersionBuilder_ != null) {
        priorVersionBuilder_.dispose();
        priorVersionBuilder_ = null;
      }
      if (tagUpdatesBuilder_ == null) {
        tagUpdates_ = java.util.Collections.emptyList();
      } else {
        tagUpdates_ = null;
        tagUpdatesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      name_ = "";
      mimeType_ = "";
      size_ = 0L;
      content_ = com.google.protobuf.ByteString.EMPTY;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return org.finos.tracdap.api.Data.internal_static_tracdap_api_FileWriteRequest_descriptor;
    }

    @java.lang.Override
    public org.finos.tracdap.api.FileWriteRequest getDefaultInstanceForType() {
      return org.finos.tracdap.api.FileWriteRequest.getDefaultInstance();
    }

    @java.lang.Override
    public org.finos.tracdap.api.FileWriteRequest build() {
      org.finos.tracdap.api.FileWriteRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public org.finos.tracdap.api.FileWriteRequest buildPartial() {
      org.finos.tracdap.api.FileWriteRequest result = new org.finos.tracdap.api.FileWriteRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) { buildPartial0(result); }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(org.finos.tracdap.api.FileWriteRequest result) {
      if (tagUpdatesBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          tagUpdates_ = java.util.Collections.unmodifiableList(tagUpdates_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.tagUpdates_ = tagUpdates_;
      } else {
        result.tagUpdates_ = tagUpdatesBuilder_.build();
      }
    }

    private void buildPartial0(org.finos.tracdap.api.FileWriteRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.tenant_ = tenant_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.priorVersion_ = priorVersionBuilder_ == null
            ? priorVersion_
            : priorVersionBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.mimeType_ = mimeType_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.size_ = size_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.content_ = content_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof org.finos.tracdap.api.FileWriteRequest) {
        return mergeFrom((org.finos.tracdap.api.FileWriteRequest)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(org.finos.tracdap.api.FileWriteRequest other) {
      if (other == org.finos.tracdap.api.FileWriteRequest.getDefaultInstance()) return this;
      if (!other.getTenant().isEmpty()) {
        tenant_ = other.tenant_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasPriorVersion()) {
        mergePriorVersion(other.getPriorVersion());
      }
      if (tagUpdatesBuilder_ == null) {
        if (!other.tagUpdates_.isEmpty()) {
          if (tagUpdates_.isEmpty()) {
            tagUpdates_ = other.tagUpdates_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureTagUpdatesIsMutable();
            tagUpdates_.addAll(other.tagUpdates_);
          }
          onChanged();
        }
      } else {
        if (!other.tagUpdates_.isEmpty()) {
          if (tagUpdatesBuilder_.isEmpty()) {
            tagUpdatesBuilder_.dispose();
            tagUpdatesBuilder_ = null;
            tagUpdates_ = other.tagUpdates_;
            bitField0_ = (bitField0_ & ~0x00000004);
            tagUpdatesBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getTagUpdatesFieldBuilder() : null;
          } else {
            tagUpdatesBuilder_.addAllMessages(other.tagUpdates_);
          }
        }
      }
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getMimeType().isEmpty()) {
        mimeType_ = other.mimeType_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasSize()) {
        setSize(other.getSize());
      }
      if (other.getContent() != com.google.protobuf.ByteString.EMPTY) {
        setContent(other.getContent());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              tenant_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000001;
              break;
            } // case 10
            case 18: {
              input.readMessage(
                  getPriorVersionFieldBuilder().getBuilder(),
                  extensionRegistry);
              bitField0_ |= 0x00000002;
              break;
            } // case 18
            case 26: {
              org.finos.tracdap.metadata.TagUpdate m =
                  input.readMessage(
                      org.finos.tracdap.metadata.TagUpdate.parser(),
                      extensionRegistry);
              if (tagUpdatesBuilder_ == null) {
                ensureTagUpdatesIsMutable();
                tagUpdates_.add(m);
              } else {
                tagUpdatesBuilder_.addMessage(m);
              }
              break;
            } // case 26
            case 34: {
              name_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000008;
              break;
            } // case 34
            case 42: {
              mimeType_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000010;
              break;
            } // case 42
            case 48: {
              size_ = input.readUInt64();
              bitField0_ |= 0x00000020;
              break;
            } // case 48
            case 8002: {
              content_ = input.readBytes();
              bitField0_ |= 0x00000040;
              break;
            } // case 8002
            default: {
              if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                done = true; // was an endgroup tag
              }
              break;
            } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }
    private int bitField0_;

    private java.lang.Object tenant_ = "";
    /**
     * <pre>
     **
     * Tenant code for the requested operation, always required
     * </pre>
     *
     * <code>string tenant = 1;</code>
     * @return The tenant.
     */
    public java.lang.String getTenant() {
      java.lang.Object ref = tenant_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        tenant_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     **
     * Tenant code for the requested operation, always required
     * </pre>
     *
     * <code>string tenant = 1;</code>
     * @return The bytes for tenant.
     */
    public com.google.protobuf.ByteString
        getTenantBytes() {
      java.lang.Object ref = tenant_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        tenant_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     **
     * Tenant code for the requested operation, always required
     * </pre>
     *
     * <code>string tenant = 1;</code>
     * @param value The tenant to set.
     * @return This builder for chaining.
     */
    public Builder setTenant(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      tenant_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <pre>
     **
     * Tenant code for the requested operation, always required
     * </pre>
     *
     * <code>string tenant = 1;</code>
     * @return This builder for chaining.
     */
    public Builder clearTenant() {
      tenant_ = getDefaultInstance().getTenant();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     * <pre>
     **
     * Tenant code for the requested operation, always required
     * </pre>
     *
     * <code>string tenant = 1;</code>
     * @param value The bytes for tenant to set.
     * @return This builder for chaining.
     */
    public Builder setTenantBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      tenant_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private org.finos.tracdap.metadata.TagSelector priorVersion_;
    private com.google.protobuf.SingleFieldBuilderV3<
        org.finos.tracdap.metadata.TagSelector, org.finos.tracdap.metadata.TagSelector.Builder, org.finos.tracdap.metadata.TagSelectorOrBuilder> priorVersionBuilder_;
    /**
     * <pre>
     **
     * Prior object/tag version to use for update operations
     * This field should be omitted when creating a new file.
     * </pre>
     *
     * <code>optional .tracdap.metadata.TagSelector priorVersion = 2;</code>
     * @return Whether the priorVersion field is set.
     */
    public boolean hasPriorVersion() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     **
     * Prior object/tag version to use for update operations
     * This field should be omitted when creating a new file.
     * </pre>
     *
     * <code>optional .tracdap.metadata.TagSelector priorVersion = 2;</code>
     * @return The priorVersion.
     */
    public org.finos.tracdap.metadata.TagSelector getPriorVersion() {
      if (priorVersionBuilder_ == null) {
        return priorVersion_ == null ? org.finos.tracdap.metadata.TagSelector.getDefaultInstance() : priorVersion_;
      } else {
        return priorVersionBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     **
     * Prior object/tag version to use for update operations
     * This field should be omitted when creating a new file.
     * </pre>
     *
     * <code>optional .tracdap.metadata.TagSelector priorVersion = 2;</code>
     */
    public Builder setPriorVersion(org.finos.tracdap.metadata.TagSelector value) {
      if (priorVersionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        priorVersion_ = value;
      } else {
        priorVersionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     **
     * Prior object/tag version to use for update operations
     * This field should be omitted when creating a new file.
     * </pre>
     *
     * <code>optional .tracdap.metadata.TagSelector priorVersion = 2;</code>
     */
    public Builder setPriorVersion(
        org.finos.tracdap.metadata.TagSelector.Builder builderForValue) {
      if (priorVersionBuilder_ == null) {
        priorVersion_ = builderForValue.build();
      } else {
        priorVersionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     **
     * Prior object/tag version to use for update operations
     * This field should be omitted when creating a new file.
     * </pre>
     *
     * <code>optional .tracdap.metadata.TagSelector priorVersion = 2;</code>
     */
    public Builder mergePriorVersion(org.finos.tracdap.metadata.TagSelector value) {
      if (priorVersionBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0) &&
          priorVersion_ != null &&
          priorVersion_ != org.finos.tracdap.metadata.TagSelector.getDefaultInstance()) {
          getPriorVersionBuilder().mergeFrom(value);
        } else {
          priorVersion_ = value;
        }
      } else {
        priorVersionBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     **
     * Prior object/tag version to use for update operations
     * This field should be omitted when creating a new file.
     * </pre>
     *
     * <code>optional .tracdap.metadata.TagSelector priorVersion = 2;</code>
     */
    public Builder clearPriorVersion() {
      bitField0_ = (bitField0_ & ~0x00000002);
      priorVersion_ = null;
      if (priorVersionBuilder_ != null) {
        priorVersionBuilder_.dispose();
        priorVersionBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     * <pre>
     **
     * Prior object/tag version to use for update operations
     * This field should be omitted when creating a new file.
     * </pre>
     *
     * <code>optional .tracdap.metadata.TagSelector priorVersion = 2;</code>
     */
    public org.finos.tracdap.metadata.TagSelector.Builder getPriorVersionBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getPriorVersionFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     **
     * Prior object/tag version to use for update operations
     * This field should be omitted when creating a new file.
     * </pre>
     *
     * <code>optional .tracdap.metadata.TagSelector priorVersion = 2;</code>
     */
    public org.finos.tracdap.metadata.TagSelectorOrBuilder getPriorVersionOrBuilder() {
      if (priorVersionBuilder_ != null) {
        return priorVersionBuilder_.getMessageOrBuilder();
      } else {
        return priorVersion_ == null ?
            org.finos.tracdap.metadata.TagSelector.getDefaultInstance() : priorVersion_;
      }
    }
    /**
     * <pre>
     **
     * Prior object/tag version to use for update operations
     * This field should be omitted when creating a new file.
     * </pre>
     *
     * <code>optional .tracdap.metadata.TagSelector priorVersion = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        org.finos.tracdap.metadata.TagSelector, org.finos.tracdap.metadata.TagSelector.Builder, org.finos.tracdap.metadata.TagSelectorOrBuilder> 
        getPriorVersionFieldBuilder() {
      if (priorVersionBuilder_ == null) {
        priorVersionBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            org.finos.tracdap.metadata.TagSelector, org.finos.tracdap.metadata.TagSelector.Builder, org.finos.tracdap.metadata.TagSelectorOrBuilder>(
                getPriorVersion(),
                getParentForChildren(),
                isClean());
        priorVersion_ = null;
      }
      return priorVersionBuilder_;
    }

    private java.util.List<org.finos.tracdap.metadata.TagUpdate> tagUpdates_ =
      java.util.Collections.emptyList();
    private void ensureTagUpdatesIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        tagUpdates_ = new java.util.ArrayList<org.finos.tracdap.metadata.TagUpdate>(tagUpdates_);
        bitField0_ |= 0x00000004;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        org.finos.tracdap.metadata.TagUpdate, org.finos.tracdap.metadata.TagUpdate.Builder, org.finos.tracdap.metadata.TagUpdateOrBuilder> tagUpdatesBuilder_;

    /**
     * <pre>
     **
     * Tag update operations to be applied
     * Tag updates are applied in exactly the same way as for metadata write requests.
     * &#64;see MetadataWriteRequest
     * &#64;see TracMetadataApi
     * </pre>
     *
     * <code>repeated .tracdap.metadata.TagUpdate tagUpdates = 3;</code>
     */
    public java.util.List<org.finos.tracdap.metadata.TagUpdate> getTagUpdatesList() {
      if (tagUpdatesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(tagUpdates_);
      } else {
        return tagUpdatesBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     **
     * Tag update operations to be applied
     * Tag updates are applied in exactly the same way as for metadata write requests.
     * &#64;see MetadataWriteRequest
     * &#64;see TracMetadataApi
     * </pre>
     *
     * <code>repeated .tracdap.metadata.TagUpdate tagUpdates = 3;</code>
     */
    public int getTagUpdatesCount() {
      if (tagUpdatesBuilder_ == null) {
        return tagUpdates_.size();
      } else {
        return tagUpdatesBuilder_.getCount();
      }
    }
    /**
     * <pre>
     **
     * Tag update operations to be applied
     * Tag updates are applied in exactly the same way as for metadata write requests.
     * &#64;see MetadataWriteRequest
     * &#64;see TracMetadataApi
     * </pre>
     *
     * <code>repeated .tracdap.metadata.TagUpdate tagUpdates = 3;</code>
     */
    public org.finos.tracdap.metadata.TagUpdate getTagUpdates(int index) {
      if (tagUpdatesBuilder_ == null) {
        return tagUpdates_.get(index);
      } else {
        return tagUpdatesBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     **
     * Tag update operations to be applied
     * Tag updates are applied in exactly the same way as for metadata write requests.
     * &#64;see MetadataWriteRequest
     * &#64;see TracMetadataApi
     * </pre>
     *
     * <code>repeated .tracdap.metadata.TagUpdate tagUpdates = 3;</code>
     */
    public Builder setTagUpdates(
        int index, org.finos.tracdap.metadata.TagUpdate value) {
      if (tagUpdatesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTagUpdatesIsMutable();
        tagUpdates_.set(index, value);
        onChanged();
      } else {
        tagUpdatesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     **
     * Tag update operations to be applied
     * Tag updates are applied in exactly the same way as for metadata write requests.
     * &#64;see MetadataWriteRequest
     * &#64;see TracMetadataApi
     * </pre>
     *
     * <code>repeated .tracdap.metadata.TagUpdate tagUpdates = 3;</code>
     */
    public Builder setTagUpdates(
        int index, org.finos.tracdap.metadata.TagUpdate.Builder builderForValue) {
      if (tagUpdatesBuilder_ == null) {
        ensureTagUpdatesIsMutable();
        tagUpdates_.set(index, builderForValue.build());
        onChanged();
      } else {
        tagUpdatesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     **
     * Tag update operations to be applied
     * Tag updates are applied in exactly the same way as for metadata write requests.
     * &#64;see MetadataWriteRequest
     * &#64;see TracMetadataApi
     * </pre>
     *
     * <code>repeated .tracdap.metadata.TagUpdate tagUpdates = 3;</code>
     */
    public Builder addTagUpdates(org.finos.tracdap.metadata.TagUpdate value) {
      if (tagUpdatesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTagUpdatesIsMutable();
        tagUpdates_.add(value);
        onChanged();
      } else {
        tagUpdatesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     **
     * Tag update operations to be applied
     * Tag updates are applied in exactly the same way as for metadata write requests.
     * &#64;see MetadataWriteRequest
     * &#64;see TracMetadataApi
     * </pre>
     *
     * <code>repeated .tracdap.metadata.TagUpdate tagUpdates = 3;</code>
     */
    public Builder addTagUpdates(
        int index, org.finos.tracdap.metadata.TagUpdate value) {
      if (tagUpdatesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTagUpdatesIsMutable();
        tagUpdates_.add(index, value);
        onChanged();
      } else {
        tagUpdatesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     **
     * Tag update operations to be applied
     * Tag updates are applied in exactly the same way as for metadata write requests.
     * &#64;see MetadataWriteRequest
     * &#64;see TracMetadataApi
     * </pre>
     *
     * <code>repeated .tracdap.metadata.TagUpdate tagUpdates = 3;</code>
     */
    public Builder addTagUpdates(
        org.finos.tracdap.metadata.TagUpdate.Builder builderForValue) {
      if (tagUpdatesBuilder_ == null) {
        ensureTagUpdatesIsMutable();
        tagUpdates_.add(builderForValue.build());
        onChanged();
      } else {
        tagUpdatesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     **
     * Tag update operations to be applied
     * Tag updates are applied in exactly the same way as for metadata write requests.
     * &#64;see MetadataWriteRequest
     * &#64;see TracMetadataApi
     * </pre>
     *
     * <code>repeated .tracdap.metadata.TagUpdate tagUpdates = 3;</code>
     */
    public Builder addTagUpdates(
        int index, org.finos.tracdap.metadata.TagUpdate.Builder builderForValue) {
      if (tagUpdatesBuilder_ == null) {
        ensureTagUpdatesIsMutable();
        tagUpdates_.add(index, builderForValue.build());
        onChanged();
      } else {
        tagUpdatesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     **
     * Tag update operations to be applied
     * Tag updates are applied in exactly the same way as for metadata write requests.
     * &#64;see MetadataWriteRequest
     * &#64;see TracMetadataApi
     * </pre>
     *
     * <code>repeated .tracdap.metadata.TagUpdate tagUpdates = 3;</code>
     */
    public Builder addAllTagUpdates(
        java.lang.Iterable<? extends org.finos.tracdap.metadata.TagUpdate> values) {
      if (tagUpdatesBuilder_ == null) {
        ensureTagUpdatesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, tagUpdates_);
        onChanged();
      } else {
        tagUpdatesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     **
     * Tag update operations to be applied
     * Tag updates are applied in exactly the same way as for metadata write requests.
     * &#64;see MetadataWriteRequest
     * &#64;see TracMetadataApi
     * </pre>
     *
     * <code>repeated .tracdap.metadata.TagUpdate tagUpdates = 3;</code>
     */
    public Builder clearTagUpdates() {
      if (tagUpdatesBuilder_ == null) {
        tagUpdates_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        tagUpdatesBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     **
     * Tag update operations to be applied
     * Tag updates are applied in exactly the same way as for metadata write requests.
     * &#64;see MetadataWriteRequest
     * &#64;see TracMetadataApi
     * </pre>
     *
     * <code>repeated .tracdap.metadata.TagUpdate tagUpdates = 3;</code>
     */
    public Builder removeTagUpdates(int index) {
      if (tagUpdatesBuilder_ == null) {
        ensureTagUpdatesIsMutable();
        tagUpdates_.remove(index);
        onChanged();
      } else {
        tagUpdatesBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     **
     * Tag update operations to be applied
     * Tag updates are applied in exactly the same way as for metadata write requests.
     * &#64;see MetadataWriteRequest
     * &#64;see TracMetadataApi
     * </pre>
     *
     * <code>repeated .tracdap.metadata.TagUpdate tagUpdates = 3;</code>
     */
    public org.finos.tracdap.metadata.TagUpdate.Builder getTagUpdatesBuilder(
        int index) {
      return getTagUpdatesFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     **
     * Tag update operations to be applied
     * Tag updates are applied in exactly the same way as for metadata write requests.
     * &#64;see MetadataWriteRequest
     * &#64;see TracMetadataApi
     * </pre>
     *
     * <code>repeated .tracdap.metadata.TagUpdate tagUpdates = 3;</code>
     */
    public org.finos.tracdap.metadata.TagUpdateOrBuilder getTagUpdatesOrBuilder(
        int index) {
      if (tagUpdatesBuilder_ == null) {
        return tagUpdates_.get(index);  } else {
        return tagUpdatesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     **
     * Tag update operations to be applied
     * Tag updates are applied in exactly the same way as for metadata write requests.
     * &#64;see MetadataWriteRequest
     * &#64;see TracMetadataApi
     * </pre>
     *
     * <code>repeated .tracdap.metadata.TagUpdate tagUpdates = 3;</code>
     */
    public java.util.List<? extends org.finos.tracdap.metadata.TagUpdateOrBuilder> 
         getTagUpdatesOrBuilderList() {
      if (tagUpdatesBuilder_ != null) {
        return tagUpdatesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(tagUpdates_);
      }
    }
    /**
     * <pre>
     **
     * Tag update operations to be applied
     * Tag updates are applied in exactly the same way as for metadata write requests.
     * &#64;see MetadataWriteRequest
     * &#64;see TracMetadataApi
     * </pre>
     *
     * <code>repeated .tracdap.metadata.TagUpdate tagUpdates = 3;</code>
     */
    public org.finos.tracdap.metadata.TagUpdate.Builder addTagUpdatesBuilder() {
      return getTagUpdatesFieldBuilder().addBuilder(
          org.finos.tracdap.metadata.TagUpdate.getDefaultInstance());
    }
    /**
     * <pre>
     **
     * Tag update operations to be applied
     * Tag updates are applied in exactly the same way as for metadata write requests.
     * &#64;see MetadataWriteRequest
     * &#64;see TracMetadataApi
     * </pre>
     *
     * <code>repeated .tracdap.metadata.TagUpdate tagUpdates = 3;</code>
     */
    public org.finos.tracdap.metadata.TagUpdate.Builder addTagUpdatesBuilder(
        int index) {
      return getTagUpdatesFieldBuilder().addBuilder(
          index, org.finos.tracdap.metadata.TagUpdate.getDefaultInstance());
    }
    /**
     * <pre>
     **
     * Tag update operations to be applied
     * Tag updates are applied in exactly the same way as for metadata write requests.
     * &#64;see MetadataWriteRequest
     * &#64;see TracMetadataApi
     * </pre>
     *
     * <code>repeated .tracdap.metadata.TagUpdate tagUpdates = 3;</code>
     */
    public java.util.List<org.finos.tracdap.metadata.TagUpdate.Builder> 
         getTagUpdatesBuilderList() {
      return getTagUpdatesFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        org.finos.tracdap.metadata.TagUpdate, org.finos.tracdap.metadata.TagUpdate.Builder, org.finos.tracdap.metadata.TagUpdateOrBuilder> 
        getTagUpdatesFieldBuilder() {
      if (tagUpdatesBuilder_ == null) {
        tagUpdatesBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            org.finos.tracdap.metadata.TagUpdate, org.finos.tracdap.metadata.TagUpdate.Builder, org.finos.tracdap.metadata.TagUpdateOrBuilder>(
                tagUpdates_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        tagUpdates_ = null;
      }
      return tagUpdatesBuilder_;
    }

    private java.lang.Object name_ = "";
    /**
     * <pre>
     **
     * File name of the file being saved, always required
     * Must be a valid file name with no path component (i.e. the name may not contain slashes).
     * If the name contains a period character, the file extension will be set as the
     * portion of the name following the last period. Otherwise the file extension will be blank.
     * For update requests the name may change but the extension must stay the same. E.g. a file
     * can be created as "my_file_v1.txt" and updated as "my_file_v2.txt", but updating with the
     * name as "my_file_v1.doc" would not be allowed. Attempting to change the extension in an
     * update will result in an error status of FAILED_PRECONDITION.
     * Fle name and extension are stored in the file definition, and in the trac_file_name
     * and trac_file_extension attributes.
     * </pre>
     *
     * <code>string name = 4;</code>
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     **
     * File name of the file being saved, always required
     * Must be a valid file name with no path component (i.e. the name may not contain slashes).
     * If the name contains a period character, the file extension will be set as the
     * portion of the name following the last period. Otherwise the file extension will be blank.
     * For update requests the name may change but the extension must stay the same. E.g. a file
     * can be created as "my_file_v1.txt" and updated as "my_file_v2.txt", but updating with the
     * name as "my_file_v1.doc" would not be allowed. Attempting to change the extension in an
     * update will result in an error status of FAILED_PRECONDITION.
     * Fle name and extension are stored in the file definition, and in the trac_file_name
     * and trac_file_extension attributes.
     * </pre>
     *
     * <code>string name = 4;</code>
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     **
     * File name of the file being saved, always required
     * Must be a valid file name with no path component (i.e. the name may not contain slashes).
     * If the name contains a period character, the file extension will be set as the
     * portion of the name following the last period. Otherwise the file extension will be blank.
     * For update requests the name may change but the extension must stay the same. E.g. a file
     * can be created as "my_file_v1.txt" and updated as "my_file_v2.txt", but updating with the
     * name as "my_file_v1.doc" would not be allowed. Attempting to change the extension in an
     * update will result in an error status of FAILED_PRECONDITION.
     * Fle name and extension are stored in the file definition, and in the trac_file_name
     * and trac_file_extension attributes.
     * </pre>
     *
     * <code>string name = 4;</code>
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      name_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <pre>
     **
     * File name of the file being saved, always required
     * Must be a valid file name with no path component (i.e. the name may not contain slashes).
     * If the name contains a period character, the file extension will be set as the
     * portion of the name following the last period. Otherwise the file extension will be blank.
     * For update requests the name may change but the extension must stay the same. E.g. a file
     * can be created as "my_file_v1.txt" and updated as "my_file_v2.txt", but updating with the
     * name as "my_file_v1.doc" would not be allowed. Attempting to change the extension in an
     * update will result in an error status of FAILED_PRECONDITION.
     * Fle name and extension are stored in the file definition, and in the trac_file_name
     * and trac_file_extension attributes.
     * </pre>
     *
     * <code>string name = 4;</code>
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     * <pre>
     **
     * File name of the file being saved, always required
     * Must be a valid file name with no path component (i.e. the name may not contain slashes).
     * If the name contains a period character, the file extension will be set as the
     * portion of the name following the last period. Otherwise the file extension will be blank.
     * For update requests the name may change but the extension must stay the same. E.g. a file
     * can be created as "my_file_v1.txt" and updated as "my_file_v2.txt", but updating with the
     * name as "my_file_v1.doc" would not be allowed. Attempting to change the extension in an
     * update will result in an error status of FAILED_PRECONDITION.
     * Fle name and extension are stored in the file definition, and in the trac_file_name
     * and trac_file_extension attributes.
     * </pre>
     *
     * <code>string name = 4;</code>
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object mimeType_ = "";
    /**
     * <pre>
     **
     * Mime type of the file being saved, always required
     * Must be a valid mime type. For update requests, the mime type must match exactly
     * with the mime type supplied when the file was originally created. Attempting to change
     * the mime type in an update will result in an error status of FAILED_PRECONDITION.
     * Mime type is stored in the file definition and in the trac_file_mime_type attribute.
     * </pre>
     *
     * <code>string mimeType = 5;</code>
     * @return The mimeType.
     */
    public java.lang.String getMimeType() {
      java.lang.Object ref = mimeType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        mimeType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     **
     * Mime type of the file being saved, always required
     * Must be a valid mime type. For update requests, the mime type must match exactly
     * with the mime type supplied when the file was originally created. Attempting to change
     * the mime type in an update will result in an error status of FAILED_PRECONDITION.
     * Mime type is stored in the file definition and in the trac_file_mime_type attribute.
     * </pre>
     *
     * <code>string mimeType = 5;</code>
     * @return The bytes for mimeType.
     */
    public com.google.protobuf.ByteString
        getMimeTypeBytes() {
      java.lang.Object ref = mimeType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        mimeType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     **
     * Mime type of the file being saved, always required
     * Must be a valid mime type. For update requests, the mime type must match exactly
     * with the mime type supplied when the file was originally created. Attempting to change
     * the mime type in an update will result in an error status of FAILED_PRECONDITION.
     * Mime type is stored in the file definition and in the trac_file_mime_type attribute.
     * </pre>
     *
     * <code>string mimeType = 5;</code>
     * @param value The mimeType to set.
     * @return This builder for chaining.
     */
    public Builder setMimeType(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      mimeType_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     * <pre>
     **
     * Mime type of the file being saved, always required
     * Must be a valid mime type. For update requests, the mime type must match exactly
     * with the mime type supplied when the file was originally created. Attempting to change
     * the mime type in an update will result in an error status of FAILED_PRECONDITION.
     * Mime type is stored in the file definition and in the trac_file_mime_type attribute.
     * </pre>
     *
     * <code>string mimeType = 5;</code>
     * @return This builder for chaining.
     */
    public Builder clearMimeType() {
      mimeType_ = getDefaultInstance().getMimeType();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     * <pre>
     **
     * Mime type of the file being saved, always required
     * Must be a valid mime type. For update requests, the mime type must match exactly
     * with the mime type supplied when the file was originally created. Attempting to change
     * the mime type in an update will result in an error status of FAILED_PRECONDITION.
     * Mime type is stored in the file definition and in the trac_file_mime_type attribute.
     * </pre>
     *
     * <code>string mimeType = 5;</code>
     * @param value The bytes for mimeType to set.
     * @return This builder for chaining.
     */
    public Builder setMimeTypeBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      mimeType_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private long size_ ;
    /**
     * <pre>
     **
     * Size of the file being saved, if known in advance
     * When a size is supplied, TRAC will check the size against the number of bytes stored.
     * If the stored file size does not match the supplied value, the error will be reported
     * with an error status of DATA_LOSS. When no size is supplied the check cannot be performed.
     * File size is stored in the created file definition and in the trac_file_size attribute.
     * </pre>
     *
     * <code>optional uint64 size = 6;</code>
     * @return Whether the size field is set.
     */
    @java.lang.Override
    public boolean hasSize() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     * <pre>
     **
     * Size of the file being saved, if known in advance
     * When a size is supplied, TRAC will check the size against the number of bytes stored.
     * If the stored file size does not match the supplied value, the error will be reported
     * with an error status of DATA_LOSS. When no size is supplied the check cannot be performed.
     * File size is stored in the created file definition and in the trac_file_size attribute.
     * </pre>
     *
     * <code>optional uint64 size = 6;</code>
     * @return The size.
     */
    @java.lang.Override
    public long getSize() {
      return size_;
    }
    /**
     * <pre>
     **
     * Size of the file being saved, if known in advance
     * When a size is supplied, TRAC will check the size against the number of bytes stored.
     * If the stored file size does not match the supplied value, the error will be reported
     * with an error status of DATA_LOSS. When no size is supplied the check cannot be performed.
     * File size is stored in the created file definition and in the trac_file_size attribute.
     * </pre>
     *
     * <code>optional uint64 size = 6;</code>
     * @param value The size to set.
     * @return This builder for chaining.
     */
    public Builder setSize(long value) {
      
      size_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     * <pre>
     **
     * Size of the file being saved, if known in advance
     * When a size is supplied, TRAC will check the size against the number of bytes stored.
     * If the stored file size does not match the supplied value, the error will be reported
     * with an error status of DATA_LOSS. When no size is supplied the check cannot be performed.
     * File size is stored in the created file definition and in the trac_file_size attribute.
     * </pre>
     *
     * <code>optional uint64 size = 6;</code>
     * @return This builder for chaining.
     */
    public Builder clearSize() {
      bitField0_ = (bitField0_ & ~0x00000020);
      size_ = 0L;
      onChanged();
      return this;
    }

    private com.google.protobuf.ByteString content_ = com.google.protobuf.ByteString.EMPTY;
    /**
     * <pre>
     **
     * A chunk of the file content
     * The file content should be sent as a stream of chunks (byte buffers), with one chunk in each message.
     * Empty chunks can be included at any point in the request stream and will be ignored.
     * </pre>
     *
     * <code>bytes content = 1000;</code>
     * @return The content.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getContent() {
      return content_;
    }
    /**
     * <pre>
     **
     * A chunk of the file content
     * The file content should be sent as a stream of chunks (byte buffers), with one chunk in each message.
     * Empty chunks can be included at any point in the request stream and will be ignored.
     * </pre>
     *
     * <code>bytes content = 1000;</code>
     * @param value The content to set.
     * @return This builder for chaining.
     */
    public Builder setContent(com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      content_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     * <pre>
     **
     * A chunk of the file content
     * The file content should be sent as a stream of chunks (byte buffers), with one chunk in each message.
     * Empty chunks can be included at any point in the request stream and will be ignored.
     * </pre>
     *
     * <code>bytes content = 1000;</code>
     * @return This builder for chaining.
     */
    public Builder clearContent() {
      bitField0_ = (bitField0_ & ~0x00000040);
      content_ = getDefaultInstance().getContent();
      onChanged();
      return this;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:tracdap.api.FileWriteRequest)
  }

  // @@protoc_insertion_point(class_scope:tracdap.api.FileWriteRequest)
  private static final org.finos.tracdap.api.FileWriteRequest DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new org.finos.tracdap.api.FileWriteRequest();
  }

  public static org.finos.tracdap.api.FileWriteRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<FileWriteRequest>
      PARSER = new com.google.protobuf.AbstractParser<FileWriteRequest>() {
    @java.lang.Override
    public FileWriteRequest parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e)
            .setUnfinishedMessage(builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<FileWriteRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<FileWriteRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public org.finos.tracdap.api.FileWriteRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

