package org.finos.tracdap.api;

import static io.grpc.MethodDescriptor.generateFullMethodName;

/**
 * <pre>
 **
 * Public API for creating, updating, reading and searching for objects in the TRAC metadata store.
 * The TRAC metadata API is expressed in terms of Objects and Tags. Objects are
 * structural items (nouns and verbs) such as data, models and jobs that describe
 * resources and operations on the TRAC platform. Tags contain descriptive and
 * informational data and provide a means to classify, catalogue and control objects.
 * Tags can also be used to describe the structure of applications built on the TRAC
 * platform. For more information on the TRAC metadata model, refer to the
 * documentation for ObjectDefinition and Tag.
 * The write API allows objects to be created directly, by supplying an object
 * definition and a set of tags. These definitions and tags are validated,
 * assigned an ID and version (in a tag header) then saved as they are. Only
 * certain types of objects can be created / updated directly via the public API
 * (currently FLOW and CUSTOM objects). Other types of objects are created by TRAC
 * as a result of operations on the platform, for example a model import job will
 * create a model definition.
 * Creating a new version of an object is very similar to creating a new object,
 * in that the entire metadata definition must be supplied. TRAC will perform
 * validation to make sure the new definition is a valid version update from the
 * previous version - the semantics of versioning depend on the particular object
 * type.
 * The metadata write API also provides a means for updating tags (i.e. creating
 * a new tag version); tag updates are allowed for all object types via the public
 * API. The current API requires a whole new tag to be supplied, this will be
 * replaced in a future version with an API that supplies attributes changes as a
 * set of add/modify/remove operations.
 * The read API is for reading metadata from the metadata store when the IDs of the
 * metadata items are known. The easiest way to read metadata is using TagSelectors,
 * which may be present in other metadata items (e.g. job definitions record tag
 * selectors to indicate which versions of resources were used in a job) or can be
 * easily constructed from an object ID or tag header. HTTP GET calls are also
 * available for REST clients (REST clients can still use selectors with POST
 * requests).
 * Metadata searches are performed using tag attributes, as well as an object type
 * and a few top-level parameters to handle versioning and temporality. See the
 * SearchParameters object for a more detailed description. The result of a search
 * call is a list of matching tags, which are always arranged with the most recent
 * tags first. A search that matches no results will return an empty list.
 * This API is a multi-tenant API. For gRPC requests every request includes a
 * tenant code, for REST requests the tenant code is the first element of every
 * path.
 * &#64;see tracdap.metadata.ObjectDefinition
 * &#64;see tracdap.metadata.Tag
 * &#64;see tracdap.metadata.TagHeader
 * &#64;see tracdap.metadata.TagSelector
 * &#64;see tracdap.metadata.TagUpdate
 * &#64;see tracdap.metadata.SearchParameters
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.49.0)",
    comments = "Source: tracdap/api/metadata.proto")
@io.grpc.stub.annotations.GrpcGenerated
public final class TracMetadataApiGrpc {

  private TracMetadataApiGrpc() {}

  public static final String SERVICE_NAME = "tracdap.api.TracMetadataApi";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<org.finos.tracdap.api.PlatformInfoRequest,
      org.finos.tracdap.api.PlatformInfoResponse> getPlatformInfoMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "platformInfo",
      requestType = org.finos.tracdap.api.PlatformInfoRequest.class,
      responseType = org.finos.tracdap.api.PlatformInfoResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<org.finos.tracdap.api.PlatformInfoRequest,
      org.finos.tracdap.api.PlatformInfoResponse> getPlatformInfoMethod() {
    io.grpc.MethodDescriptor<org.finos.tracdap.api.PlatformInfoRequest, org.finos.tracdap.api.PlatformInfoResponse> getPlatformInfoMethod;
    if ((getPlatformInfoMethod = TracMetadataApiGrpc.getPlatformInfoMethod) == null) {
      synchronized (TracMetadataApiGrpc.class) {
        if ((getPlatformInfoMethod = TracMetadataApiGrpc.getPlatformInfoMethod) == null) {
          TracMetadataApiGrpc.getPlatformInfoMethod = getPlatformInfoMethod =
              io.grpc.MethodDescriptor.<org.finos.tracdap.api.PlatformInfoRequest, org.finos.tracdap.api.PlatformInfoResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "platformInfo"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.finos.tracdap.api.PlatformInfoRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.finos.tracdap.api.PlatformInfoResponse.getDefaultInstance()))
              .setSchemaDescriptor(new TracMetadataApiMethodDescriptorSupplier("platformInfo"))
              .build();
        }
      }
    }
    return getPlatformInfoMethod;
  }

  private static volatile io.grpc.MethodDescriptor<org.finos.tracdap.api.ListTenantsRequest,
      org.finos.tracdap.api.ListTenantsResponse> getListTenantsMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "listTenants",
      requestType = org.finos.tracdap.api.ListTenantsRequest.class,
      responseType = org.finos.tracdap.api.ListTenantsResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<org.finos.tracdap.api.ListTenantsRequest,
      org.finos.tracdap.api.ListTenantsResponse> getListTenantsMethod() {
    io.grpc.MethodDescriptor<org.finos.tracdap.api.ListTenantsRequest, org.finos.tracdap.api.ListTenantsResponse> getListTenantsMethod;
    if ((getListTenantsMethod = TracMetadataApiGrpc.getListTenantsMethod) == null) {
      synchronized (TracMetadataApiGrpc.class) {
        if ((getListTenantsMethod = TracMetadataApiGrpc.getListTenantsMethod) == null) {
          TracMetadataApiGrpc.getListTenantsMethod = getListTenantsMethod =
              io.grpc.MethodDescriptor.<org.finos.tracdap.api.ListTenantsRequest, org.finos.tracdap.api.ListTenantsResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "listTenants"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.finos.tracdap.api.ListTenantsRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.finos.tracdap.api.ListTenantsResponse.getDefaultInstance()))
              .setSchemaDescriptor(new TracMetadataApiMethodDescriptorSupplier("listTenants"))
              .build();
        }
      }
    }
    return getListTenantsMethod;
  }

  private static volatile io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataWriteRequest,
      org.finos.tracdap.metadata.TagHeader> getCreateObjectMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "createObject",
      requestType = org.finos.tracdap.api.MetadataWriteRequest.class,
      responseType = org.finos.tracdap.metadata.TagHeader.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataWriteRequest,
      org.finos.tracdap.metadata.TagHeader> getCreateObjectMethod() {
    io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataWriteRequest, org.finos.tracdap.metadata.TagHeader> getCreateObjectMethod;
    if ((getCreateObjectMethod = TracMetadataApiGrpc.getCreateObjectMethod) == null) {
      synchronized (TracMetadataApiGrpc.class) {
        if ((getCreateObjectMethod = TracMetadataApiGrpc.getCreateObjectMethod) == null) {
          TracMetadataApiGrpc.getCreateObjectMethod = getCreateObjectMethod =
              io.grpc.MethodDescriptor.<org.finos.tracdap.api.MetadataWriteRequest, org.finos.tracdap.metadata.TagHeader>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "createObject"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.finos.tracdap.api.MetadataWriteRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.finos.tracdap.metadata.TagHeader.getDefaultInstance()))
              .setSchemaDescriptor(new TracMetadataApiMethodDescriptorSupplier("createObject"))
              .build();
        }
      }
    }
    return getCreateObjectMethod;
  }

  private static volatile io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataWriteBatchRequest,
      org.finos.tracdap.api.MetadataWriteBatchResponse> getCreateObjectBatchMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "createObjectBatch",
      requestType = org.finos.tracdap.api.MetadataWriteBatchRequest.class,
      responseType = org.finos.tracdap.api.MetadataWriteBatchResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataWriteBatchRequest,
      org.finos.tracdap.api.MetadataWriteBatchResponse> getCreateObjectBatchMethod() {
    io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataWriteBatchRequest, org.finos.tracdap.api.MetadataWriteBatchResponse> getCreateObjectBatchMethod;
    if ((getCreateObjectBatchMethod = TracMetadataApiGrpc.getCreateObjectBatchMethod) == null) {
      synchronized (TracMetadataApiGrpc.class) {
        if ((getCreateObjectBatchMethod = TracMetadataApiGrpc.getCreateObjectBatchMethod) == null) {
          TracMetadataApiGrpc.getCreateObjectBatchMethod = getCreateObjectBatchMethod =
              io.grpc.MethodDescriptor.<org.finos.tracdap.api.MetadataWriteBatchRequest, org.finos.tracdap.api.MetadataWriteBatchResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "createObjectBatch"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.finos.tracdap.api.MetadataWriteBatchRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.finos.tracdap.api.MetadataWriteBatchResponse.getDefaultInstance()))
              .setSchemaDescriptor(new TracMetadataApiMethodDescriptorSupplier("createObjectBatch"))
              .build();
        }
      }
    }
    return getCreateObjectBatchMethod;
  }

  private static volatile io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataWriteRequest,
      org.finos.tracdap.metadata.TagHeader> getUpdateObjectMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "updateObject",
      requestType = org.finos.tracdap.api.MetadataWriteRequest.class,
      responseType = org.finos.tracdap.metadata.TagHeader.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataWriteRequest,
      org.finos.tracdap.metadata.TagHeader> getUpdateObjectMethod() {
    io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataWriteRequest, org.finos.tracdap.metadata.TagHeader> getUpdateObjectMethod;
    if ((getUpdateObjectMethod = TracMetadataApiGrpc.getUpdateObjectMethod) == null) {
      synchronized (TracMetadataApiGrpc.class) {
        if ((getUpdateObjectMethod = TracMetadataApiGrpc.getUpdateObjectMethod) == null) {
          TracMetadataApiGrpc.getUpdateObjectMethod = getUpdateObjectMethod =
              io.grpc.MethodDescriptor.<org.finos.tracdap.api.MetadataWriteRequest, org.finos.tracdap.metadata.TagHeader>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "updateObject"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.finos.tracdap.api.MetadataWriteRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.finos.tracdap.metadata.TagHeader.getDefaultInstance()))
              .setSchemaDescriptor(new TracMetadataApiMethodDescriptorSupplier("updateObject"))
              .build();
        }
      }
    }
    return getUpdateObjectMethod;
  }

  private static volatile io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataWriteBatchRequest,
      org.finos.tracdap.api.MetadataWriteBatchResponse> getUpdateObjectBatchMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "updateObjectBatch",
      requestType = org.finos.tracdap.api.MetadataWriteBatchRequest.class,
      responseType = org.finos.tracdap.api.MetadataWriteBatchResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataWriteBatchRequest,
      org.finos.tracdap.api.MetadataWriteBatchResponse> getUpdateObjectBatchMethod() {
    io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataWriteBatchRequest, org.finos.tracdap.api.MetadataWriteBatchResponse> getUpdateObjectBatchMethod;
    if ((getUpdateObjectBatchMethod = TracMetadataApiGrpc.getUpdateObjectBatchMethod) == null) {
      synchronized (TracMetadataApiGrpc.class) {
        if ((getUpdateObjectBatchMethod = TracMetadataApiGrpc.getUpdateObjectBatchMethod) == null) {
          TracMetadataApiGrpc.getUpdateObjectBatchMethod = getUpdateObjectBatchMethod =
              io.grpc.MethodDescriptor.<org.finos.tracdap.api.MetadataWriteBatchRequest, org.finos.tracdap.api.MetadataWriteBatchResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "updateObjectBatch"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.finos.tracdap.api.MetadataWriteBatchRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.finos.tracdap.api.MetadataWriteBatchResponse.getDefaultInstance()))
              .setSchemaDescriptor(new TracMetadataApiMethodDescriptorSupplier("updateObjectBatch"))
              .build();
        }
      }
    }
    return getUpdateObjectBatchMethod;
  }

  private static volatile io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataWriteRequest,
      org.finos.tracdap.metadata.TagHeader> getUpdateTagMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "updateTag",
      requestType = org.finos.tracdap.api.MetadataWriteRequest.class,
      responseType = org.finos.tracdap.metadata.TagHeader.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataWriteRequest,
      org.finos.tracdap.metadata.TagHeader> getUpdateTagMethod() {
    io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataWriteRequest, org.finos.tracdap.metadata.TagHeader> getUpdateTagMethod;
    if ((getUpdateTagMethod = TracMetadataApiGrpc.getUpdateTagMethod) == null) {
      synchronized (TracMetadataApiGrpc.class) {
        if ((getUpdateTagMethod = TracMetadataApiGrpc.getUpdateTagMethod) == null) {
          TracMetadataApiGrpc.getUpdateTagMethod = getUpdateTagMethod =
              io.grpc.MethodDescriptor.<org.finos.tracdap.api.MetadataWriteRequest, org.finos.tracdap.metadata.TagHeader>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "updateTag"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.finos.tracdap.api.MetadataWriteRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.finos.tracdap.metadata.TagHeader.getDefaultInstance()))
              .setSchemaDescriptor(new TracMetadataApiMethodDescriptorSupplier("updateTag"))
              .build();
        }
      }
    }
    return getUpdateTagMethod;
  }

  private static volatile io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataWriteBatchRequest,
      org.finos.tracdap.api.MetadataWriteBatchResponse> getUpdateTagBatchMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "updateTagBatch",
      requestType = org.finos.tracdap.api.MetadataWriteBatchRequest.class,
      responseType = org.finos.tracdap.api.MetadataWriteBatchResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataWriteBatchRequest,
      org.finos.tracdap.api.MetadataWriteBatchResponse> getUpdateTagBatchMethod() {
    io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataWriteBatchRequest, org.finos.tracdap.api.MetadataWriteBatchResponse> getUpdateTagBatchMethod;
    if ((getUpdateTagBatchMethod = TracMetadataApiGrpc.getUpdateTagBatchMethod) == null) {
      synchronized (TracMetadataApiGrpc.class) {
        if ((getUpdateTagBatchMethod = TracMetadataApiGrpc.getUpdateTagBatchMethod) == null) {
          TracMetadataApiGrpc.getUpdateTagBatchMethod = getUpdateTagBatchMethod =
              io.grpc.MethodDescriptor.<org.finos.tracdap.api.MetadataWriteBatchRequest, org.finos.tracdap.api.MetadataWriteBatchResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "updateTagBatch"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.finos.tracdap.api.MetadataWriteBatchRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.finos.tracdap.api.MetadataWriteBatchResponse.getDefaultInstance()))
              .setSchemaDescriptor(new TracMetadataApiMethodDescriptorSupplier("updateTagBatch"))
              .build();
        }
      }
    }
    return getUpdateTagBatchMethod;
  }

  private static volatile io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataReadRequest,
      org.finos.tracdap.metadata.Tag> getReadObjectMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "readObject",
      requestType = org.finos.tracdap.api.MetadataReadRequest.class,
      responseType = org.finos.tracdap.metadata.Tag.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataReadRequest,
      org.finos.tracdap.metadata.Tag> getReadObjectMethod() {
    io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataReadRequest, org.finos.tracdap.metadata.Tag> getReadObjectMethod;
    if ((getReadObjectMethod = TracMetadataApiGrpc.getReadObjectMethod) == null) {
      synchronized (TracMetadataApiGrpc.class) {
        if ((getReadObjectMethod = TracMetadataApiGrpc.getReadObjectMethod) == null) {
          TracMetadataApiGrpc.getReadObjectMethod = getReadObjectMethod =
              io.grpc.MethodDescriptor.<org.finos.tracdap.api.MetadataReadRequest, org.finos.tracdap.metadata.Tag>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "readObject"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.finos.tracdap.api.MetadataReadRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.finos.tracdap.metadata.Tag.getDefaultInstance()))
              .setSchemaDescriptor(new TracMetadataApiMethodDescriptorSupplier("readObject"))
              .build();
        }
      }
    }
    return getReadObjectMethod;
  }

  private static volatile io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataBatchRequest,
      org.finos.tracdap.api.MetadataBatchResponse> getReadBatchMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "readBatch",
      requestType = org.finos.tracdap.api.MetadataBatchRequest.class,
      responseType = org.finos.tracdap.api.MetadataBatchResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataBatchRequest,
      org.finos.tracdap.api.MetadataBatchResponse> getReadBatchMethod() {
    io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataBatchRequest, org.finos.tracdap.api.MetadataBatchResponse> getReadBatchMethod;
    if ((getReadBatchMethod = TracMetadataApiGrpc.getReadBatchMethod) == null) {
      synchronized (TracMetadataApiGrpc.class) {
        if ((getReadBatchMethod = TracMetadataApiGrpc.getReadBatchMethod) == null) {
          TracMetadataApiGrpc.getReadBatchMethod = getReadBatchMethod =
              io.grpc.MethodDescriptor.<org.finos.tracdap.api.MetadataBatchRequest, org.finos.tracdap.api.MetadataBatchResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "readBatch"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.finos.tracdap.api.MetadataBatchRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.finos.tracdap.api.MetadataBatchResponse.getDefaultInstance()))
              .setSchemaDescriptor(new TracMetadataApiMethodDescriptorSupplier("readBatch"))
              .build();
        }
      }
    }
    return getReadBatchMethod;
  }

  private static volatile io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataSearchRequest,
      org.finos.tracdap.api.MetadataSearchResponse> getSearchMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "search",
      requestType = org.finos.tracdap.api.MetadataSearchRequest.class,
      responseType = org.finos.tracdap.api.MetadataSearchResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataSearchRequest,
      org.finos.tracdap.api.MetadataSearchResponse> getSearchMethod() {
    io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataSearchRequest, org.finos.tracdap.api.MetadataSearchResponse> getSearchMethod;
    if ((getSearchMethod = TracMetadataApiGrpc.getSearchMethod) == null) {
      synchronized (TracMetadataApiGrpc.class) {
        if ((getSearchMethod = TracMetadataApiGrpc.getSearchMethod) == null) {
          TracMetadataApiGrpc.getSearchMethod = getSearchMethod =
              io.grpc.MethodDescriptor.<org.finos.tracdap.api.MetadataSearchRequest, org.finos.tracdap.api.MetadataSearchResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "search"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.finos.tracdap.api.MetadataSearchRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.finos.tracdap.api.MetadataSearchResponse.getDefaultInstance()))
              .setSchemaDescriptor(new TracMetadataApiMethodDescriptorSupplier("search"))
              .build();
        }
      }
    }
    return getSearchMethod;
  }

  private static volatile io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataGetRequest,
      org.finos.tracdap.metadata.Tag> getGetObjectMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "getObject",
      requestType = org.finos.tracdap.api.MetadataGetRequest.class,
      responseType = org.finos.tracdap.metadata.Tag.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataGetRequest,
      org.finos.tracdap.metadata.Tag> getGetObjectMethod() {
    io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataGetRequest, org.finos.tracdap.metadata.Tag> getGetObjectMethod;
    if ((getGetObjectMethod = TracMetadataApiGrpc.getGetObjectMethod) == null) {
      synchronized (TracMetadataApiGrpc.class) {
        if ((getGetObjectMethod = TracMetadataApiGrpc.getGetObjectMethod) == null) {
          TracMetadataApiGrpc.getGetObjectMethod = getGetObjectMethod =
              io.grpc.MethodDescriptor.<org.finos.tracdap.api.MetadataGetRequest, org.finos.tracdap.metadata.Tag>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "getObject"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.finos.tracdap.api.MetadataGetRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.finos.tracdap.metadata.Tag.getDefaultInstance()))
              .setSchemaDescriptor(new TracMetadataApiMethodDescriptorSupplier("getObject"))
              .build();
        }
      }
    }
    return getGetObjectMethod;
  }

  private static volatile io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataGetRequest,
      org.finos.tracdap.metadata.Tag> getGetLatestObjectMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "getLatestObject",
      requestType = org.finos.tracdap.api.MetadataGetRequest.class,
      responseType = org.finos.tracdap.metadata.Tag.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataGetRequest,
      org.finos.tracdap.metadata.Tag> getGetLatestObjectMethod() {
    io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataGetRequest, org.finos.tracdap.metadata.Tag> getGetLatestObjectMethod;
    if ((getGetLatestObjectMethod = TracMetadataApiGrpc.getGetLatestObjectMethod) == null) {
      synchronized (TracMetadataApiGrpc.class) {
        if ((getGetLatestObjectMethod = TracMetadataApiGrpc.getGetLatestObjectMethod) == null) {
          TracMetadataApiGrpc.getGetLatestObjectMethod = getGetLatestObjectMethod =
              io.grpc.MethodDescriptor.<org.finos.tracdap.api.MetadataGetRequest, org.finos.tracdap.metadata.Tag>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "getLatestObject"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.finos.tracdap.api.MetadataGetRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.finos.tracdap.metadata.Tag.getDefaultInstance()))
              .setSchemaDescriptor(new TracMetadataApiMethodDescriptorSupplier("getLatestObject"))
              .build();
        }
      }
    }
    return getGetLatestObjectMethod;
  }

  private static volatile io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataGetRequest,
      org.finos.tracdap.metadata.Tag> getGetLatestTagMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "getLatestTag",
      requestType = org.finos.tracdap.api.MetadataGetRequest.class,
      responseType = org.finos.tracdap.metadata.Tag.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataGetRequest,
      org.finos.tracdap.metadata.Tag> getGetLatestTagMethod() {
    io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataGetRequest, org.finos.tracdap.metadata.Tag> getGetLatestTagMethod;
    if ((getGetLatestTagMethod = TracMetadataApiGrpc.getGetLatestTagMethod) == null) {
      synchronized (TracMetadataApiGrpc.class) {
        if ((getGetLatestTagMethod = TracMetadataApiGrpc.getGetLatestTagMethod) == null) {
          TracMetadataApiGrpc.getGetLatestTagMethod = getGetLatestTagMethod =
              io.grpc.MethodDescriptor.<org.finos.tracdap.api.MetadataGetRequest, org.finos.tracdap.metadata.Tag>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "getLatestTag"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.finos.tracdap.api.MetadataGetRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.finos.tracdap.metadata.Tag.getDefaultInstance()))
              .setSchemaDescriptor(new TracMetadataApiMethodDescriptorSupplier("getLatestTag"))
              .build();
        }
      }
    }
    return getGetLatestTagMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static TracMetadataApiStub newStub(io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<TracMetadataApiStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<TracMetadataApiStub>() {
        @java.lang.Override
        public TracMetadataApiStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new TracMetadataApiStub(channel, callOptions);
        }
      };
    return TracMetadataApiStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static TracMetadataApiBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<TracMetadataApiBlockingStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<TracMetadataApiBlockingStub>() {
        @java.lang.Override
        public TracMetadataApiBlockingStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new TracMetadataApiBlockingStub(channel, callOptions);
        }
      };
    return TracMetadataApiBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static TracMetadataApiFutureStub newFutureStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<TracMetadataApiFutureStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<TracMetadataApiFutureStub>() {
        @java.lang.Override
        public TracMetadataApiFutureStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new TracMetadataApiFutureStub(channel, callOptions);
        }
      };
    return TracMetadataApiFutureStub.newStub(factory, channel);
  }

  /**
   * <pre>
   **
   * Public API for creating, updating, reading and searching for objects in the TRAC metadata store.
   * The TRAC metadata API is expressed in terms of Objects and Tags. Objects are
   * structural items (nouns and verbs) such as data, models and jobs that describe
   * resources and operations on the TRAC platform. Tags contain descriptive and
   * informational data and provide a means to classify, catalogue and control objects.
   * Tags can also be used to describe the structure of applications built on the TRAC
   * platform. For more information on the TRAC metadata model, refer to the
   * documentation for ObjectDefinition and Tag.
   * The write API allows objects to be created directly, by supplying an object
   * definition and a set of tags. These definitions and tags are validated,
   * assigned an ID and version (in a tag header) then saved as they are. Only
   * certain types of objects can be created / updated directly via the public API
   * (currently FLOW and CUSTOM objects). Other types of objects are created by TRAC
   * as a result of operations on the platform, for example a model import job will
   * create a model definition.
   * Creating a new version of an object is very similar to creating a new object,
   * in that the entire metadata definition must be supplied. TRAC will perform
   * validation to make sure the new definition is a valid version update from the
   * previous version - the semantics of versioning depend on the particular object
   * type.
   * The metadata write API also provides a means for updating tags (i.e. creating
   * a new tag version); tag updates are allowed for all object types via the public
   * API. The current API requires a whole new tag to be supplied, this will be
   * replaced in a future version with an API that supplies attributes changes as a
   * set of add/modify/remove operations.
   * The read API is for reading metadata from the metadata store when the IDs of the
   * metadata items are known. The easiest way to read metadata is using TagSelectors,
   * which may be present in other metadata items (e.g. job definitions record tag
   * selectors to indicate which versions of resources were used in a job) or can be
   * easily constructed from an object ID or tag header. HTTP GET calls are also
   * available for REST clients (REST clients can still use selectors with POST
   * requests).
   * Metadata searches are performed using tag attributes, as well as an object type
   * and a few top-level parameters to handle versioning and temporality. See the
   * SearchParameters object for a more detailed description. The result of a search
   * call is a list of matching tags, which are always arranged with the most recent
   * tags first. A search that matches no results will return an empty list.
   * This API is a multi-tenant API. For gRPC requests every request includes a
   * tenant code, for REST requests the tenant code is the first element of every
   * path.
   * &#64;see tracdap.metadata.ObjectDefinition
   * &#64;see tracdap.metadata.Tag
   * &#64;see tracdap.metadata.TagHeader
   * &#64;see tracdap.metadata.TagSelector
   * &#64;see tracdap.metadata.TagUpdate
   * &#64;see tracdap.metadata.SearchParameters
   * </pre>
   */
  public static abstract class TracMetadataApiImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     **
     * Get some general information about the TRAC platform.
     * Information returned includes what environment you are connected to
     * and what version of TRAC is running. Useful for displaying in "about"
     * boxes in a UI or client tool, and for submitting error reports.
     * </pre>
     */
    public void platformInfo(org.finos.tracdap.api.PlatformInfoRequest request,
        io.grpc.stub.StreamObserver<org.finos.tracdap.api.PlatformInfoResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getPlatformInfoMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Get a list of tenants that the current user has access to.
     * Information returned includes the available tenant codes, as well
     * as human readable descriptions. Client tools that support multiple
     * tenants and tenant switching will need to fetch this list.
     * Only tenants accessible to the current user are returned.
     * </pre>
     */
    public void listTenants(org.finos.tracdap.api.ListTenantsRequest request,
        io.grpc.stub.StreamObserver<org.finos.tracdap.api.ListTenantsResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getListTenantsMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Create a new object in the TRAC metadata store.
     * To create an object, supply a metadata write request with the tenant code,
     * object type and a definition for the item you want to save. The tag should contain
     * all the attributes you want to set and the object definition, without an
     * object header. TRAC will create a header when it assigns and ID for the new
     * object. Only FLOW and CUSTOM objects can be created by this API call.
     * Validation is performed on new objects before they are saved. Objects can
     * fail validation because they are semantically invalid (e.g. missing
     * required fields or inconsistencies within the object definition) or due to
     * consistency errors (referring to other metadata items that don't exist or
     * don't meet certain requirements).
     * NOTE: Validation is only partially implemented in the current release.
     * The call returns an ID response to indicate the ID of the newly created
     * object, as well as the object and tag version (which will always be 1).
     * Error conditions include: Invalid request, unknown tenant, object type does
     * not match the supplied definition, validation failure.
     * &#64;see tracdap.metadata.ObjectDefinition
     * &#64;see tracdap.metadata.TagUpdate
     * </pre>
     */
    public void createObject(org.finos.tracdap.api.MetadataWriteRequest request,
        io.grpc.stub.StreamObserver<org.finos.tracdap.metadata.TagHeader> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getCreateObjectMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Create new objects in batch in the TRAC metadata store.
     * To create an object, supply a metadata write request with the tenant code,
     * object type and a definition for the item you want to save. The tag should contain
     * all the attributes you want to set and the object definition, without an
     * object header. TRAC will create a header when it assigns and ID for the new
     * object. Only FLOW and CUSTOM objects can be created by this API call.
     * Validation is performed on new objects before they are saved. Objects can
     * fail validation because they are semantically invalid (e.g. missing
     * required fields or inconsistencies within the object definition) or due to
     * consistency errors (referring to other metadata items that don't exist or
     * don't meet certain requirements).
     * NOTE: Validation is only partially implemented in the current release.
     * The call returns an ID responses to indicate the IDs of the newly created
     * objects, as well as the objects and tag versions (which will always be 1).
     * Error conditions include: Invalid request, unknown tenant, object type does
     * not match the supplied definition, validation failure.
     * &#64;see TracMetadataApi.createObject()
     * &#64;see tracdap.metadata.ObjectDefinition
     * &#64;see tracdap.metadata.TagUpdate
     * </pre>
     */
    public void createObjectBatch(org.finos.tracdap.api.MetadataWriteBatchRequest request,
        io.grpc.stub.StreamObserver<org.finos.tracdap.api.MetadataWriteBatchResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getCreateObjectBatchMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Update an existing object in the TRAC metadata store.
     * To save a new version, supply a metadata write request with the tenant code,
     * object type and a tag for the item you want to save. The tag should contain
     * all the attributes you want to set and the updated object definition, which
     * must be supplied with the header from the *previous* version of the object.
     * TRAC will apply the new version number when it creates the new version of
     * the object. Only the latest version of an object can be updated and only
     * CUSTOM objects can be updated by this API call.
     * Validation is performed on new objects before they are saved. Objects can
     * fail validation because they are semantically invalid (e.g. missing
     * required fields or inconsistencies within the object definition) or due to
     * consistency errors (referring to other metadata items that don't exist or
     * don't meet certain requirements). For new versions, validation also covers
     * checking for compatibility with the previous version of the object.
     * NOTE: Validation is only partially implemented in the current release.
     * The call returns an ID response with the ID object and the newly assigned
     * version number, as well as the tag version (which will always be 1).
     * Error conditions include: Invalid request, unknown tenant, unknown object
     * ID or version, wrong object type (not the same as the prior version), object
     * version is superseded.
     * &#64;see tracdap.metadata.ObjectDefinition
     * &#64;see tracdap.metadata.TagSelector
     * &#64;see tracdap.metadata.TagUpdate
     * </pre>
     */
    public void updateObject(org.finos.tracdap.api.MetadataWriteRequest request,
        io.grpc.stub.StreamObserver<org.finos.tracdap.metadata.TagHeader> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getUpdateObjectMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Update existing objects in batch in the TRAC metadata store.
     * To save a new version, supply a metadata write request with the tenant code,
     * object type and a tag for the item you want to save. The tag should contain
     * all the attributes you want to set and the updated object definition, which
     * must be supplied with the header from the *previous* version of the object.
     * TRAC will apply the new version number when it creates the new version of
     * the object. Only the latest version of an object can be updated and only
     * CUSTOM objects can be updated by this API call.
     * Validation is performed on new objects before they are saved. Objects can
     * fail validation because they are semantically invalid (e.g. missing
     * required fields or inconsistencies within the object definition) or due to
     * consistency errors (referring to other metadata items that don't exist or
     * don't meet certain requirements). For new versions, validation also covers
     * checking for compatibility with the previous version of the object.
     * NOTE: Validation is only partially implemented in the current release.
     * The call returns an ID response with the ID object and the newly assigned
     * version number, as well as the tag version (which will always be 1).
     * Error conditions include: Invalid request, unknown tenant, unknown object
     * ID or version, wrong object type (not the same as the prior version), object
     * version is superseded.
     * &#64;see TracMetadataApi.updateObject()
     * &#64;see tracdap.metadata.ObjectDefinition
     * &#64;see tracdap.metadata.TagUpdate
     * </pre>
     */
    public void updateObjectBatch(org.finos.tracdap.api.MetadataWriteBatchRequest request,
        io.grpc.stub.StreamObserver<org.finos.tracdap.api.MetadataWriteBatchResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getUpdateObjectBatchMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Update the tag for an existing object in the TRAC metadata store.
     * To save a new tag, supply a metadata write request with the tenant code,
     * object type and a tag for the item you want to save. The tag should contain
     * all the attributes you want to include in the new tag, even if they have
     * not been changed. The object definition must be supplied with a header only,
     * supplying an object body is an invalid request. Tags for any type of object
     * can be updated by this API call. Only the latest version of a tag can be
     * updated.
     * The call returns an ID response with the ID and version of the object and
     * the newly assigned tag number.
     * Error conditions include: Invalid request, unknown tenant, unknown object
     * ID, object version or tag version, wrong object type (does not match what
     * is stored in TRAC), tag version is superseded.
     * &#64;see tracdap.metadata.TagSelector
     * &#64;see tracdap.metadata.TagUpdate
     * </pre>
     */
    public void updateTag(org.finos.tracdap.api.MetadataWriteRequest request,
        io.grpc.stub.StreamObserver<org.finos.tracdap.metadata.TagHeader> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getUpdateTagMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Update tags in batch for existing objects in the TRAC metadata store.
     * To save a new tag, supply a metadata write request with the tenant code,
     * object type and a tag for the item you want to save. The tag should contain
     * all the attributes you want to include in the new tag, even if they have
     * not been changed. The object definition must be supplied with a header only,
     * supplying an object body is an invalid request. Tags for any type of object
     * can be updated by this API call. Only the latest version of a tag can be
     * updated.
     * The call returns an ID response with the ID and version of the object and
     * the newly assigned tag number.
     * Error conditions include: Invalid request, unknown tenant, unknown object
     * ID, object version or tag version, wrong object type (does not match what
     * is stored in TRAC), tag version is superseded.
     * &#64;see TracMetadataApi.updateTag()
     * &#64;see tracdap.metadata.ObjectDefinition
     * &#64;see tracdap.metadata.TagUpdate
     * </pre>
     */
    public void updateTagBatch(org.finos.tracdap.api.MetadataWriteBatchRequest request,
        io.grpc.stub.StreamObserver<org.finos.tracdap.api.MetadataWriteBatchResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getUpdateTagBatchMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Read a single object from the TRAC metadata store using a tag selector.
     * Tag selectors are used throughout the TRAC metadata structures and API
     * calls to refer to objects. For example, a job definition includes
     * selectors to define the data sets and models that were selected for the
     * job. Those selectors can be passed directly into this call.
     * Tag selectors can refer to object and tag versions either using explicit
     * version numbers, with as-of times or by referring to the current latest
     * version. Combinations are also possible (e.g. object version x, latest
     * tag).
     * This call takes a single selector and returns a single Tag, including the
     * object definition. Error conditions include: Invalid request, unknown
     * tenant, unknown object ID, object type does not match ID, unknown object
     * version, unknown tag version.
     * &#64;see tracdap.metadata.TagSelector
     * </pre>
     */
    public void readObject(org.finos.tracdap.api.MetadataReadRequest request,
        io.grpc.stub.StreamObserver<org.finos.tracdap.metadata.Tag> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getReadObjectMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Read multiple objects from the TRAC metadata store using tag selectors.
     * Tag selectors are used throughout the TRAC metadata structures and API
     * calls to refer to objects. For example, a job definition includes
     * selectors to define the data sets and models that were selected for the
     * job. Those selectors can be passed directly into this call.
     * Tag selectors can refer to object and tag versions either using explicit
     * version numbers, with as-of times or by referring to the current latest
     * version. Combinations are also possible (e.g. object version x, latest
     * tag).
     * This call takes multiple selectors and returns multiple Tags in the same
     * order, including their object definitions. Selectors for different object
     * types and with different criteria for selecting versions can be mixed
     * freely in a single request. Error conditions include: Invalid request,
     * unknown tenant, unknown object ID, object type does not match ID, unknown
     * object version, unknown tag version. If there is an error for any of the
     * selectors the whole request will fail.
     * &#64;see tracdap.metadata.TagSelector
     * </pre>
     */
    public void readBatch(org.finos.tracdap.api.MetadataBatchRequest request,
        io.grpc.stub.StreamObserver<org.finos.tracdap.api.MetadataBatchResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getReadBatchMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Perform a search against the TRAC metadata store.
     * Searches are always for a specific tenant and object type. For details of the
     * available search parameters, see SearchParameters.
     * In gRPC calls, a MetadataSearchRequest specifies the tenant and includes the
     * SearchParameters, where object type and the search expression are set. For
     * REST calls the tenant is passed in the URL and searchParameters are supplied
     * as the request body.
     * &#64;see tracdap.metadata.SearchParameters
     * </pre>
     */
    public void search(org.finos.tracdap.api.MetadataSearchRequest request,
        io.grpc.stub.StreamObserver<org.finos.tracdap.api.MetadataSearchResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getSearchMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Get a single metadata object using an HTTP GET request.
     * This call is intended for use by REST clients to provide TRAC metadata
     * objects as RESTFUL resources. For gRPC clients it is recommended to use
     * readObject instead and supply a TagSelector.
     * &#64;see readObject
     * To use this call, supply a tenant code, object type, ID, object version
     * and tag version. The call will return a tag for the exact object version
     * and tag version specified, including the full object definition.
     * Error conditions include: Invalid request, unknown tenant, unknown object
     * ID, object type does not match ID, unknown object version, unknown tag
     * version.
     * </pre>
     */
    public void getObject(org.finos.tracdap.api.MetadataGetRequest request,
        io.grpc.stub.StreamObserver<org.finos.tracdap.metadata.Tag> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetObjectMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Get the latest version of a metadata object using an HTTP GET request.
     * This call is intended for use by REST clients to provide TRAC metadata
     * objects as RESTFUL resources. For gRPC clients it is recommended to use
     * readObject instead and supply a TagSelector.
     * &#64;see readObject
     * To use this call, supply a tenant code, object type and ID. The call will
     * return the latest version of the object with its latest tag, including
     * the full object definition.
     * Error conditions include: Invalid request, unknown tenant, unknown object
     * ID, object type does not match ID.
     * </pre>
     */
    public void getLatestObject(org.finos.tracdap.api.MetadataGetRequest request,
        io.grpc.stub.StreamObserver<org.finos.tracdap.metadata.Tag> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetLatestObjectMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Get the latest tag for a metadata object using an HTTP GET request.
     * This call is intended for use by REST clients to provide TRAC metadata
     * objects as RESTFUL resources. For gRPC clients it is recommended to use
     * readObject instead and supply a TagSelector.
     * &#64;see readObject
     * To use this call, supply a tenant code, object type, ID and version. The
     * call will return the latest tag for the specified version of the object,
     * including the full object definition.
     * Error conditions include: Invalid request, unknown tenant, unknown object
     * ID, object type does not match ID, unknown object version.
     * </pre>
     */
    public void getLatestTag(org.finos.tracdap.api.MetadataGetRequest request,
        io.grpc.stub.StreamObserver<org.finos.tracdap.metadata.Tag> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetLatestTagMethod(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getPlatformInfoMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                org.finos.tracdap.api.PlatformInfoRequest,
                org.finos.tracdap.api.PlatformInfoResponse>(
                  this, METHODID_PLATFORM_INFO)))
          .addMethod(
            getListTenantsMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                org.finos.tracdap.api.ListTenantsRequest,
                org.finos.tracdap.api.ListTenantsResponse>(
                  this, METHODID_LIST_TENANTS)))
          .addMethod(
            getCreateObjectMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                org.finos.tracdap.api.MetadataWriteRequest,
                org.finos.tracdap.metadata.TagHeader>(
                  this, METHODID_CREATE_OBJECT)))
          .addMethod(
            getCreateObjectBatchMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                org.finos.tracdap.api.MetadataWriteBatchRequest,
                org.finos.tracdap.api.MetadataWriteBatchResponse>(
                  this, METHODID_CREATE_OBJECT_BATCH)))
          .addMethod(
            getUpdateObjectMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                org.finos.tracdap.api.MetadataWriteRequest,
                org.finos.tracdap.metadata.TagHeader>(
                  this, METHODID_UPDATE_OBJECT)))
          .addMethod(
            getUpdateObjectBatchMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                org.finos.tracdap.api.MetadataWriteBatchRequest,
                org.finos.tracdap.api.MetadataWriteBatchResponse>(
                  this, METHODID_UPDATE_OBJECT_BATCH)))
          .addMethod(
            getUpdateTagMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                org.finos.tracdap.api.MetadataWriteRequest,
                org.finos.tracdap.metadata.TagHeader>(
                  this, METHODID_UPDATE_TAG)))
          .addMethod(
            getUpdateTagBatchMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                org.finos.tracdap.api.MetadataWriteBatchRequest,
                org.finos.tracdap.api.MetadataWriteBatchResponse>(
                  this, METHODID_UPDATE_TAG_BATCH)))
          .addMethod(
            getReadObjectMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                org.finos.tracdap.api.MetadataReadRequest,
                org.finos.tracdap.metadata.Tag>(
                  this, METHODID_READ_OBJECT)))
          .addMethod(
            getReadBatchMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                org.finos.tracdap.api.MetadataBatchRequest,
                org.finos.tracdap.api.MetadataBatchResponse>(
                  this, METHODID_READ_BATCH)))
          .addMethod(
            getSearchMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                org.finos.tracdap.api.MetadataSearchRequest,
                org.finos.tracdap.api.MetadataSearchResponse>(
                  this, METHODID_SEARCH)))
          .addMethod(
            getGetObjectMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                org.finos.tracdap.api.MetadataGetRequest,
                org.finos.tracdap.metadata.Tag>(
                  this, METHODID_GET_OBJECT)))
          .addMethod(
            getGetLatestObjectMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                org.finos.tracdap.api.MetadataGetRequest,
                org.finos.tracdap.metadata.Tag>(
                  this, METHODID_GET_LATEST_OBJECT)))
          .addMethod(
            getGetLatestTagMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                org.finos.tracdap.api.MetadataGetRequest,
                org.finos.tracdap.metadata.Tag>(
                  this, METHODID_GET_LATEST_TAG)))
          .build();
    }
  }

  /**
   * <pre>
   **
   * Public API for creating, updating, reading and searching for objects in the TRAC metadata store.
   * The TRAC metadata API is expressed in terms of Objects and Tags. Objects are
   * structural items (nouns and verbs) such as data, models and jobs that describe
   * resources and operations on the TRAC platform. Tags contain descriptive and
   * informational data and provide a means to classify, catalogue and control objects.
   * Tags can also be used to describe the structure of applications built on the TRAC
   * platform. For more information on the TRAC metadata model, refer to the
   * documentation for ObjectDefinition and Tag.
   * The write API allows objects to be created directly, by supplying an object
   * definition and a set of tags. These definitions and tags are validated,
   * assigned an ID and version (in a tag header) then saved as they are. Only
   * certain types of objects can be created / updated directly via the public API
   * (currently FLOW and CUSTOM objects). Other types of objects are created by TRAC
   * as a result of operations on the platform, for example a model import job will
   * create a model definition.
   * Creating a new version of an object is very similar to creating a new object,
   * in that the entire metadata definition must be supplied. TRAC will perform
   * validation to make sure the new definition is a valid version update from the
   * previous version - the semantics of versioning depend on the particular object
   * type.
   * The metadata write API also provides a means for updating tags (i.e. creating
   * a new tag version); tag updates are allowed for all object types via the public
   * API. The current API requires a whole new tag to be supplied, this will be
   * replaced in a future version with an API that supplies attributes changes as a
   * set of add/modify/remove operations.
   * The read API is for reading metadata from the metadata store when the IDs of the
   * metadata items are known. The easiest way to read metadata is using TagSelectors,
   * which may be present in other metadata items (e.g. job definitions record tag
   * selectors to indicate which versions of resources were used in a job) or can be
   * easily constructed from an object ID or tag header. HTTP GET calls are also
   * available for REST clients (REST clients can still use selectors with POST
   * requests).
   * Metadata searches are performed using tag attributes, as well as an object type
   * and a few top-level parameters to handle versioning and temporality. See the
   * SearchParameters object for a more detailed description. The result of a search
   * call is a list of matching tags, which are always arranged with the most recent
   * tags first. A search that matches no results will return an empty list.
   * This API is a multi-tenant API. For gRPC requests every request includes a
   * tenant code, for REST requests the tenant code is the first element of every
   * path.
   * &#64;see tracdap.metadata.ObjectDefinition
   * &#64;see tracdap.metadata.Tag
   * &#64;see tracdap.metadata.TagHeader
   * &#64;see tracdap.metadata.TagSelector
   * &#64;see tracdap.metadata.TagUpdate
   * &#64;see tracdap.metadata.SearchParameters
   * </pre>
   */
  public static final class TracMetadataApiStub extends io.grpc.stub.AbstractAsyncStub<TracMetadataApiStub> {
    private TracMetadataApiStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected TracMetadataApiStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new TracMetadataApiStub(channel, callOptions);
    }

    /**
     * <pre>
     **
     * Get some general information about the TRAC platform.
     * Information returned includes what environment you are connected to
     * and what version of TRAC is running. Useful for displaying in "about"
     * boxes in a UI or client tool, and for submitting error reports.
     * </pre>
     */
    public void platformInfo(org.finos.tracdap.api.PlatformInfoRequest request,
        io.grpc.stub.StreamObserver<org.finos.tracdap.api.PlatformInfoResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getPlatformInfoMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Get a list of tenants that the current user has access to.
     * Information returned includes the available tenant codes, as well
     * as human readable descriptions. Client tools that support multiple
     * tenants and tenant switching will need to fetch this list.
     * Only tenants accessible to the current user are returned.
     * </pre>
     */
    public void listTenants(org.finos.tracdap.api.ListTenantsRequest request,
        io.grpc.stub.StreamObserver<org.finos.tracdap.api.ListTenantsResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getListTenantsMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Create a new object in the TRAC metadata store.
     * To create an object, supply a metadata write request with the tenant code,
     * object type and a definition for the item you want to save. The tag should contain
     * all the attributes you want to set and the object definition, without an
     * object header. TRAC will create a header when it assigns and ID for the new
     * object. Only FLOW and CUSTOM objects can be created by this API call.
     * Validation is performed on new objects before they are saved. Objects can
     * fail validation because they are semantically invalid (e.g. missing
     * required fields or inconsistencies within the object definition) or due to
     * consistency errors (referring to other metadata items that don't exist or
     * don't meet certain requirements).
     * NOTE: Validation is only partially implemented in the current release.
     * The call returns an ID response to indicate the ID of the newly created
     * object, as well as the object and tag version (which will always be 1).
     * Error conditions include: Invalid request, unknown tenant, object type does
     * not match the supplied definition, validation failure.
     * &#64;see tracdap.metadata.ObjectDefinition
     * &#64;see tracdap.metadata.TagUpdate
     * </pre>
     */
    public void createObject(org.finos.tracdap.api.MetadataWriteRequest request,
        io.grpc.stub.StreamObserver<org.finos.tracdap.metadata.TagHeader> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getCreateObjectMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Create new objects in batch in the TRAC metadata store.
     * To create an object, supply a metadata write request with the tenant code,
     * object type and a definition for the item you want to save. The tag should contain
     * all the attributes you want to set and the object definition, without an
     * object header. TRAC will create a header when it assigns and ID for the new
     * object. Only FLOW and CUSTOM objects can be created by this API call.
     * Validation is performed on new objects before they are saved. Objects can
     * fail validation because they are semantically invalid (e.g. missing
     * required fields or inconsistencies within the object definition) or due to
     * consistency errors (referring to other metadata items that don't exist or
     * don't meet certain requirements).
     * NOTE: Validation is only partially implemented in the current release.
     * The call returns an ID responses to indicate the IDs of the newly created
     * objects, as well as the objects and tag versions (which will always be 1).
     * Error conditions include: Invalid request, unknown tenant, object type does
     * not match the supplied definition, validation failure.
     * &#64;see TracMetadataApi.createObject()
     * &#64;see tracdap.metadata.ObjectDefinition
     * &#64;see tracdap.metadata.TagUpdate
     * </pre>
     */
    public void createObjectBatch(org.finos.tracdap.api.MetadataWriteBatchRequest request,
        io.grpc.stub.StreamObserver<org.finos.tracdap.api.MetadataWriteBatchResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getCreateObjectBatchMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Update an existing object in the TRAC metadata store.
     * To save a new version, supply a metadata write request with the tenant code,
     * object type and a tag for the item you want to save. The tag should contain
     * all the attributes you want to set and the updated object definition, which
     * must be supplied with the header from the *previous* version of the object.
     * TRAC will apply the new version number when it creates the new version of
     * the object. Only the latest version of an object can be updated and only
     * CUSTOM objects can be updated by this API call.
     * Validation is performed on new objects before they are saved. Objects can
     * fail validation because they are semantically invalid (e.g. missing
     * required fields or inconsistencies within the object definition) or due to
     * consistency errors (referring to other metadata items that don't exist or
     * don't meet certain requirements). For new versions, validation also covers
     * checking for compatibility with the previous version of the object.
     * NOTE: Validation is only partially implemented in the current release.
     * The call returns an ID response with the ID object and the newly assigned
     * version number, as well as the tag version (which will always be 1).
     * Error conditions include: Invalid request, unknown tenant, unknown object
     * ID or version, wrong object type (not the same as the prior version), object
     * version is superseded.
     * &#64;see tracdap.metadata.ObjectDefinition
     * &#64;see tracdap.metadata.TagSelector
     * &#64;see tracdap.metadata.TagUpdate
     * </pre>
     */
    public void updateObject(org.finos.tracdap.api.MetadataWriteRequest request,
        io.grpc.stub.StreamObserver<org.finos.tracdap.metadata.TagHeader> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getUpdateObjectMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Update existing objects in batch in the TRAC metadata store.
     * To save a new version, supply a metadata write request with the tenant code,
     * object type and a tag for the item you want to save. The tag should contain
     * all the attributes you want to set and the updated object definition, which
     * must be supplied with the header from the *previous* version of the object.
     * TRAC will apply the new version number when it creates the new version of
     * the object. Only the latest version of an object can be updated and only
     * CUSTOM objects can be updated by this API call.
     * Validation is performed on new objects before they are saved. Objects can
     * fail validation because they are semantically invalid (e.g. missing
     * required fields or inconsistencies within the object definition) or due to
     * consistency errors (referring to other metadata items that don't exist or
     * don't meet certain requirements). For new versions, validation also covers
     * checking for compatibility with the previous version of the object.
     * NOTE: Validation is only partially implemented in the current release.
     * The call returns an ID response with the ID object and the newly assigned
     * version number, as well as the tag version (which will always be 1).
     * Error conditions include: Invalid request, unknown tenant, unknown object
     * ID or version, wrong object type (not the same as the prior version), object
     * version is superseded.
     * &#64;see TracMetadataApi.updateObject()
     * &#64;see tracdap.metadata.ObjectDefinition
     * &#64;see tracdap.metadata.TagUpdate
     * </pre>
     */
    public void updateObjectBatch(org.finos.tracdap.api.MetadataWriteBatchRequest request,
        io.grpc.stub.StreamObserver<org.finos.tracdap.api.MetadataWriteBatchResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getUpdateObjectBatchMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Update the tag for an existing object in the TRAC metadata store.
     * To save a new tag, supply a metadata write request with the tenant code,
     * object type and a tag for the item you want to save. The tag should contain
     * all the attributes you want to include in the new tag, even if they have
     * not been changed. The object definition must be supplied with a header only,
     * supplying an object body is an invalid request. Tags for any type of object
     * can be updated by this API call. Only the latest version of a tag can be
     * updated.
     * The call returns an ID response with the ID and version of the object and
     * the newly assigned tag number.
     * Error conditions include: Invalid request, unknown tenant, unknown object
     * ID, object version or tag version, wrong object type (does not match what
     * is stored in TRAC), tag version is superseded.
     * &#64;see tracdap.metadata.TagSelector
     * &#64;see tracdap.metadata.TagUpdate
     * </pre>
     */
    public void updateTag(org.finos.tracdap.api.MetadataWriteRequest request,
        io.grpc.stub.StreamObserver<org.finos.tracdap.metadata.TagHeader> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getUpdateTagMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Update tags in batch for existing objects in the TRAC metadata store.
     * To save a new tag, supply a metadata write request with the tenant code,
     * object type and a tag for the item you want to save. The tag should contain
     * all the attributes you want to include in the new tag, even if they have
     * not been changed. The object definition must be supplied with a header only,
     * supplying an object body is an invalid request. Tags for any type of object
     * can be updated by this API call. Only the latest version of a tag can be
     * updated.
     * The call returns an ID response with the ID and version of the object and
     * the newly assigned tag number.
     * Error conditions include: Invalid request, unknown tenant, unknown object
     * ID, object version or tag version, wrong object type (does not match what
     * is stored in TRAC), tag version is superseded.
     * &#64;see TracMetadataApi.updateTag()
     * &#64;see tracdap.metadata.ObjectDefinition
     * &#64;see tracdap.metadata.TagUpdate
     * </pre>
     */
    public void updateTagBatch(org.finos.tracdap.api.MetadataWriteBatchRequest request,
        io.grpc.stub.StreamObserver<org.finos.tracdap.api.MetadataWriteBatchResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getUpdateTagBatchMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Read a single object from the TRAC metadata store using a tag selector.
     * Tag selectors are used throughout the TRAC metadata structures and API
     * calls to refer to objects. For example, a job definition includes
     * selectors to define the data sets and models that were selected for the
     * job. Those selectors can be passed directly into this call.
     * Tag selectors can refer to object and tag versions either using explicit
     * version numbers, with as-of times or by referring to the current latest
     * version. Combinations are also possible (e.g. object version x, latest
     * tag).
     * This call takes a single selector and returns a single Tag, including the
     * object definition. Error conditions include: Invalid request, unknown
     * tenant, unknown object ID, object type does not match ID, unknown object
     * version, unknown tag version.
     * &#64;see tracdap.metadata.TagSelector
     * </pre>
     */
    public void readObject(org.finos.tracdap.api.MetadataReadRequest request,
        io.grpc.stub.StreamObserver<org.finos.tracdap.metadata.Tag> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getReadObjectMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Read multiple objects from the TRAC metadata store using tag selectors.
     * Tag selectors are used throughout the TRAC metadata structures and API
     * calls to refer to objects. For example, a job definition includes
     * selectors to define the data sets and models that were selected for the
     * job. Those selectors can be passed directly into this call.
     * Tag selectors can refer to object and tag versions either using explicit
     * version numbers, with as-of times or by referring to the current latest
     * version. Combinations are also possible (e.g. object version x, latest
     * tag).
     * This call takes multiple selectors and returns multiple Tags in the same
     * order, including their object definitions. Selectors for different object
     * types and with different criteria for selecting versions can be mixed
     * freely in a single request. Error conditions include: Invalid request,
     * unknown tenant, unknown object ID, object type does not match ID, unknown
     * object version, unknown tag version. If there is an error for any of the
     * selectors the whole request will fail.
     * &#64;see tracdap.metadata.TagSelector
     * </pre>
     */
    public void readBatch(org.finos.tracdap.api.MetadataBatchRequest request,
        io.grpc.stub.StreamObserver<org.finos.tracdap.api.MetadataBatchResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getReadBatchMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Perform a search against the TRAC metadata store.
     * Searches are always for a specific tenant and object type. For details of the
     * available search parameters, see SearchParameters.
     * In gRPC calls, a MetadataSearchRequest specifies the tenant and includes the
     * SearchParameters, where object type and the search expression are set. For
     * REST calls the tenant is passed in the URL and searchParameters are supplied
     * as the request body.
     * &#64;see tracdap.metadata.SearchParameters
     * </pre>
     */
    public void search(org.finos.tracdap.api.MetadataSearchRequest request,
        io.grpc.stub.StreamObserver<org.finos.tracdap.api.MetadataSearchResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getSearchMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Get a single metadata object using an HTTP GET request.
     * This call is intended for use by REST clients to provide TRAC metadata
     * objects as RESTFUL resources. For gRPC clients it is recommended to use
     * readObject instead and supply a TagSelector.
     * &#64;see readObject
     * To use this call, supply a tenant code, object type, ID, object version
     * and tag version. The call will return a tag for the exact object version
     * and tag version specified, including the full object definition.
     * Error conditions include: Invalid request, unknown tenant, unknown object
     * ID, object type does not match ID, unknown object version, unknown tag
     * version.
     * </pre>
     */
    public void getObject(org.finos.tracdap.api.MetadataGetRequest request,
        io.grpc.stub.StreamObserver<org.finos.tracdap.metadata.Tag> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getGetObjectMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Get the latest version of a metadata object using an HTTP GET request.
     * This call is intended for use by REST clients to provide TRAC metadata
     * objects as RESTFUL resources. For gRPC clients it is recommended to use
     * readObject instead and supply a TagSelector.
     * &#64;see readObject
     * To use this call, supply a tenant code, object type and ID. The call will
     * return the latest version of the object with its latest tag, including
     * the full object definition.
     * Error conditions include: Invalid request, unknown tenant, unknown object
     * ID, object type does not match ID.
     * </pre>
     */
    public void getLatestObject(org.finos.tracdap.api.MetadataGetRequest request,
        io.grpc.stub.StreamObserver<org.finos.tracdap.metadata.Tag> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getGetLatestObjectMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Get the latest tag for a metadata object using an HTTP GET request.
     * This call is intended for use by REST clients to provide TRAC metadata
     * objects as RESTFUL resources. For gRPC clients it is recommended to use
     * readObject instead and supply a TagSelector.
     * &#64;see readObject
     * To use this call, supply a tenant code, object type, ID and version. The
     * call will return the latest tag for the specified version of the object,
     * including the full object definition.
     * Error conditions include: Invalid request, unknown tenant, unknown object
     * ID, object type does not match ID, unknown object version.
     * </pre>
     */
    public void getLatestTag(org.finos.tracdap.api.MetadataGetRequest request,
        io.grpc.stub.StreamObserver<org.finos.tracdap.metadata.Tag> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getGetLatestTagMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * <pre>
   **
   * Public API for creating, updating, reading and searching for objects in the TRAC metadata store.
   * The TRAC metadata API is expressed in terms of Objects and Tags. Objects are
   * structural items (nouns and verbs) such as data, models and jobs that describe
   * resources and operations on the TRAC platform. Tags contain descriptive and
   * informational data and provide a means to classify, catalogue and control objects.
   * Tags can also be used to describe the structure of applications built on the TRAC
   * platform. For more information on the TRAC metadata model, refer to the
   * documentation for ObjectDefinition and Tag.
   * The write API allows objects to be created directly, by supplying an object
   * definition and a set of tags. These definitions and tags are validated,
   * assigned an ID and version (in a tag header) then saved as they are. Only
   * certain types of objects can be created / updated directly via the public API
   * (currently FLOW and CUSTOM objects). Other types of objects are created by TRAC
   * as a result of operations on the platform, for example a model import job will
   * create a model definition.
   * Creating a new version of an object is very similar to creating a new object,
   * in that the entire metadata definition must be supplied. TRAC will perform
   * validation to make sure the new definition is a valid version update from the
   * previous version - the semantics of versioning depend on the particular object
   * type.
   * The metadata write API also provides a means for updating tags (i.e. creating
   * a new tag version); tag updates are allowed for all object types via the public
   * API. The current API requires a whole new tag to be supplied, this will be
   * replaced in a future version with an API that supplies attributes changes as a
   * set of add/modify/remove operations.
   * The read API is for reading metadata from the metadata store when the IDs of the
   * metadata items are known. The easiest way to read metadata is using TagSelectors,
   * which may be present in other metadata items (e.g. job definitions record tag
   * selectors to indicate which versions of resources were used in a job) or can be
   * easily constructed from an object ID or tag header. HTTP GET calls are also
   * available for REST clients (REST clients can still use selectors with POST
   * requests).
   * Metadata searches are performed using tag attributes, as well as an object type
   * and a few top-level parameters to handle versioning and temporality. See the
   * SearchParameters object for a more detailed description. The result of a search
   * call is a list of matching tags, which are always arranged with the most recent
   * tags first. A search that matches no results will return an empty list.
   * This API is a multi-tenant API. For gRPC requests every request includes a
   * tenant code, for REST requests the tenant code is the first element of every
   * path.
   * &#64;see tracdap.metadata.ObjectDefinition
   * &#64;see tracdap.metadata.Tag
   * &#64;see tracdap.metadata.TagHeader
   * &#64;see tracdap.metadata.TagSelector
   * &#64;see tracdap.metadata.TagUpdate
   * &#64;see tracdap.metadata.SearchParameters
   * </pre>
   */
  public static final class TracMetadataApiBlockingStub extends io.grpc.stub.AbstractBlockingStub<TracMetadataApiBlockingStub> {
    private TracMetadataApiBlockingStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected TracMetadataApiBlockingStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new TracMetadataApiBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     **
     * Get some general information about the TRAC platform.
     * Information returned includes what environment you are connected to
     * and what version of TRAC is running. Useful for displaying in "about"
     * boxes in a UI or client tool, and for submitting error reports.
     * </pre>
     */
    public org.finos.tracdap.api.PlatformInfoResponse platformInfo(org.finos.tracdap.api.PlatformInfoRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getPlatformInfoMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Get a list of tenants that the current user has access to.
     * Information returned includes the available tenant codes, as well
     * as human readable descriptions. Client tools that support multiple
     * tenants and tenant switching will need to fetch this list.
     * Only tenants accessible to the current user are returned.
     * </pre>
     */
    public org.finos.tracdap.api.ListTenantsResponse listTenants(org.finos.tracdap.api.ListTenantsRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getListTenantsMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Create a new object in the TRAC metadata store.
     * To create an object, supply a metadata write request with the tenant code,
     * object type and a definition for the item you want to save. The tag should contain
     * all the attributes you want to set and the object definition, without an
     * object header. TRAC will create a header when it assigns and ID for the new
     * object. Only FLOW and CUSTOM objects can be created by this API call.
     * Validation is performed on new objects before they are saved. Objects can
     * fail validation because they are semantically invalid (e.g. missing
     * required fields or inconsistencies within the object definition) or due to
     * consistency errors (referring to other metadata items that don't exist or
     * don't meet certain requirements).
     * NOTE: Validation is only partially implemented in the current release.
     * The call returns an ID response to indicate the ID of the newly created
     * object, as well as the object and tag version (which will always be 1).
     * Error conditions include: Invalid request, unknown tenant, object type does
     * not match the supplied definition, validation failure.
     * &#64;see tracdap.metadata.ObjectDefinition
     * &#64;see tracdap.metadata.TagUpdate
     * </pre>
     */
    public org.finos.tracdap.metadata.TagHeader createObject(org.finos.tracdap.api.MetadataWriteRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getCreateObjectMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Create new objects in batch in the TRAC metadata store.
     * To create an object, supply a metadata write request with the tenant code,
     * object type and a definition for the item you want to save. The tag should contain
     * all the attributes you want to set and the object definition, without an
     * object header. TRAC will create a header when it assigns and ID for the new
     * object. Only FLOW and CUSTOM objects can be created by this API call.
     * Validation is performed on new objects before they are saved. Objects can
     * fail validation because they are semantically invalid (e.g. missing
     * required fields or inconsistencies within the object definition) or due to
     * consistency errors (referring to other metadata items that don't exist or
     * don't meet certain requirements).
     * NOTE: Validation is only partially implemented in the current release.
     * The call returns an ID responses to indicate the IDs of the newly created
     * objects, as well as the objects and tag versions (which will always be 1).
     * Error conditions include: Invalid request, unknown tenant, object type does
     * not match the supplied definition, validation failure.
     * &#64;see TracMetadataApi.createObject()
     * &#64;see tracdap.metadata.ObjectDefinition
     * &#64;see tracdap.metadata.TagUpdate
     * </pre>
     */
    public org.finos.tracdap.api.MetadataWriteBatchResponse createObjectBatch(org.finos.tracdap.api.MetadataWriteBatchRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getCreateObjectBatchMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Update an existing object in the TRAC metadata store.
     * To save a new version, supply a metadata write request with the tenant code,
     * object type and a tag for the item you want to save. The tag should contain
     * all the attributes you want to set and the updated object definition, which
     * must be supplied with the header from the *previous* version of the object.
     * TRAC will apply the new version number when it creates the new version of
     * the object. Only the latest version of an object can be updated and only
     * CUSTOM objects can be updated by this API call.
     * Validation is performed on new objects before they are saved. Objects can
     * fail validation because they are semantically invalid (e.g. missing
     * required fields or inconsistencies within the object definition) or due to
     * consistency errors (referring to other metadata items that don't exist or
     * don't meet certain requirements). For new versions, validation also covers
     * checking for compatibility with the previous version of the object.
     * NOTE: Validation is only partially implemented in the current release.
     * The call returns an ID response with the ID object and the newly assigned
     * version number, as well as the tag version (which will always be 1).
     * Error conditions include: Invalid request, unknown tenant, unknown object
     * ID or version, wrong object type (not the same as the prior version), object
     * version is superseded.
     * &#64;see tracdap.metadata.ObjectDefinition
     * &#64;see tracdap.metadata.TagSelector
     * &#64;see tracdap.metadata.TagUpdate
     * </pre>
     */
    public org.finos.tracdap.metadata.TagHeader updateObject(org.finos.tracdap.api.MetadataWriteRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getUpdateObjectMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Update existing objects in batch in the TRAC metadata store.
     * To save a new version, supply a metadata write request with the tenant code,
     * object type and a tag for the item you want to save. The tag should contain
     * all the attributes you want to set and the updated object definition, which
     * must be supplied with the header from the *previous* version of the object.
     * TRAC will apply the new version number when it creates the new version of
     * the object. Only the latest version of an object can be updated and only
     * CUSTOM objects can be updated by this API call.
     * Validation is performed on new objects before they are saved. Objects can
     * fail validation because they are semantically invalid (e.g. missing
     * required fields or inconsistencies within the object definition) or due to
     * consistency errors (referring to other metadata items that don't exist or
     * don't meet certain requirements). For new versions, validation also covers
     * checking for compatibility with the previous version of the object.
     * NOTE: Validation is only partially implemented in the current release.
     * The call returns an ID response with the ID object and the newly assigned
     * version number, as well as the tag version (which will always be 1).
     * Error conditions include: Invalid request, unknown tenant, unknown object
     * ID or version, wrong object type (not the same as the prior version), object
     * version is superseded.
     * &#64;see TracMetadataApi.updateObject()
     * &#64;see tracdap.metadata.ObjectDefinition
     * &#64;see tracdap.metadata.TagUpdate
     * </pre>
     */
    public org.finos.tracdap.api.MetadataWriteBatchResponse updateObjectBatch(org.finos.tracdap.api.MetadataWriteBatchRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getUpdateObjectBatchMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Update the tag for an existing object in the TRAC metadata store.
     * To save a new tag, supply a metadata write request with the tenant code,
     * object type and a tag for the item you want to save. The tag should contain
     * all the attributes you want to include in the new tag, even if they have
     * not been changed. The object definition must be supplied with a header only,
     * supplying an object body is an invalid request. Tags for any type of object
     * can be updated by this API call. Only the latest version of a tag can be
     * updated.
     * The call returns an ID response with the ID and version of the object and
     * the newly assigned tag number.
     * Error conditions include: Invalid request, unknown tenant, unknown object
     * ID, object version or tag version, wrong object type (does not match what
     * is stored in TRAC), tag version is superseded.
     * &#64;see tracdap.metadata.TagSelector
     * &#64;see tracdap.metadata.TagUpdate
     * </pre>
     */
    public org.finos.tracdap.metadata.TagHeader updateTag(org.finos.tracdap.api.MetadataWriteRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getUpdateTagMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Update tags in batch for existing objects in the TRAC metadata store.
     * To save a new tag, supply a metadata write request with the tenant code,
     * object type and a tag for the item you want to save. The tag should contain
     * all the attributes you want to include in the new tag, even if they have
     * not been changed. The object definition must be supplied with a header only,
     * supplying an object body is an invalid request. Tags for any type of object
     * can be updated by this API call. Only the latest version of a tag can be
     * updated.
     * The call returns an ID response with the ID and version of the object and
     * the newly assigned tag number.
     * Error conditions include: Invalid request, unknown tenant, unknown object
     * ID, object version or tag version, wrong object type (does not match what
     * is stored in TRAC), tag version is superseded.
     * &#64;see TracMetadataApi.updateTag()
     * &#64;see tracdap.metadata.ObjectDefinition
     * &#64;see tracdap.metadata.TagUpdate
     * </pre>
     */
    public org.finos.tracdap.api.MetadataWriteBatchResponse updateTagBatch(org.finos.tracdap.api.MetadataWriteBatchRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getUpdateTagBatchMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Read a single object from the TRAC metadata store using a tag selector.
     * Tag selectors are used throughout the TRAC metadata structures and API
     * calls to refer to objects. For example, a job definition includes
     * selectors to define the data sets and models that were selected for the
     * job. Those selectors can be passed directly into this call.
     * Tag selectors can refer to object and tag versions either using explicit
     * version numbers, with as-of times or by referring to the current latest
     * version. Combinations are also possible (e.g. object version x, latest
     * tag).
     * This call takes a single selector and returns a single Tag, including the
     * object definition. Error conditions include: Invalid request, unknown
     * tenant, unknown object ID, object type does not match ID, unknown object
     * version, unknown tag version.
     * &#64;see tracdap.metadata.TagSelector
     * </pre>
     */
    public org.finos.tracdap.metadata.Tag readObject(org.finos.tracdap.api.MetadataReadRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getReadObjectMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Read multiple objects from the TRAC metadata store using tag selectors.
     * Tag selectors are used throughout the TRAC metadata structures and API
     * calls to refer to objects. For example, a job definition includes
     * selectors to define the data sets and models that were selected for the
     * job. Those selectors can be passed directly into this call.
     * Tag selectors can refer to object and tag versions either using explicit
     * version numbers, with as-of times or by referring to the current latest
     * version. Combinations are also possible (e.g. object version x, latest
     * tag).
     * This call takes multiple selectors and returns multiple Tags in the same
     * order, including their object definitions. Selectors for different object
     * types and with different criteria for selecting versions can be mixed
     * freely in a single request. Error conditions include: Invalid request,
     * unknown tenant, unknown object ID, object type does not match ID, unknown
     * object version, unknown tag version. If there is an error for any of the
     * selectors the whole request will fail.
     * &#64;see tracdap.metadata.TagSelector
     * </pre>
     */
    public org.finos.tracdap.api.MetadataBatchResponse readBatch(org.finos.tracdap.api.MetadataBatchRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getReadBatchMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Perform a search against the TRAC metadata store.
     * Searches are always for a specific tenant and object type. For details of the
     * available search parameters, see SearchParameters.
     * In gRPC calls, a MetadataSearchRequest specifies the tenant and includes the
     * SearchParameters, where object type and the search expression are set. For
     * REST calls the tenant is passed in the URL and searchParameters are supplied
     * as the request body.
     * &#64;see tracdap.metadata.SearchParameters
     * </pre>
     */
    public org.finos.tracdap.api.MetadataSearchResponse search(org.finos.tracdap.api.MetadataSearchRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getSearchMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Get a single metadata object using an HTTP GET request.
     * This call is intended for use by REST clients to provide TRAC metadata
     * objects as RESTFUL resources. For gRPC clients it is recommended to use
     * readObject instead and supply a TagSelector.
     * &#64;see readObject
     * To use this call, supply a tenant code, object type, ID, object version
     * and tag version. The call will return a tag for the exact object version
     * and tag version specified, including the full object definition.
     * Error conditions include: Invalid request, unknown tenant, unknown object
     * ID, object type does not match ID, unknown object version, unknown tag
     * version.
     * </pre>
     */
    public org.finos.tracdap.metadata.Tag getObject(org.finos.tracdap.api.MetadataGetRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getGetObjectMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Get the latest version of a metadata object using an HTTP GET request.
     * This call is intended for use by REST clients to provide TRAC metadata
     * objects as RESTFUL resources. For gRPC clients it is recommended to use
     * readObject instead and supply a TagSelector.
     * &#64;see readObject
     * To use this call, supply a tenant code, object type and ID. The call will
     * return the latest version of the object with its latest tag, including
     * the full object definition.
     * Error conditions include: Invalid request, unknown tenant, unknown object
     * ID, object type does not match ID.
     * </pre>
     */
    public org.finos.tracdap.metadata.Tag getLatestObject(org.finos.tracdap.api.MetadataGetRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getGetLatestObjectMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Get the latest tag for a metadata object using an HTTP GET request.
     * This call is intended for use by REST clients to provide TRAC metadata
     * objects as RESTFUL resources. For gRPC clients it is recommended to use
     * readObject instead and supply a TagSelector.
     * &#64;see readObject
     * To use this call, supply a tenant code, object type, ID and version. The
     * call will return the latest tag for the specified version of the object,
     * including the full object definition.
     * Error conditions include: Invalid request, unknown tenant, unknown object
     * ID, object type does not match ID, unknown object version.
     * </pre>
     */
    public org.finos.tracdap.metadata.Tag getLatestTag(org.finos.tracdap.api.MetadataGetRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getGetLatestTagMethod(), getCallOptions(), request);
    }
  }

  /**
   * <pre>
   **
   * Public API for creating, updating, reading and searching for objects in the TRAC metadata store.
   * The TRAC metadata API is expressed in terms of Objects and Tags. Objects are
   * structural items (nouns and verbs) such as data, models and jobs that describe
   * resources and operations on the TRAC platform. Tags contain descriptive and
   * informational data and provide a means to classify, catalogue and control objects.
   * Tags can also be used to describe the structure of applications built on the TRAC
   * platform. For more information on the TRAC metadata model, refer to the
   * documentation for ObjectDefinition and Tag.
   * The write API allows objects to be created directly, by supplying an object
   * definition and a set of tags. These definitions and tags are validated,
   * assigned an ID and version (in a tag header) then saved as they are. Only
   * certain types of objects can be created / updated directly via the public API
   * (currently FLOW and CUSTOM objects). Other types of objects are created by TRAC
   * as a result of operations on the platform, for example a model import job will
   * create a model definition.
   * Creating a new version of an object is very similar to creating a new object,
   * in that the entire metadata definition must be supplied. TRAC will perform
   * validation to make sure the new definition is a valid version update from the
   * previous version - the semantics of versioning depend on the particular object
   * type.
   * The metadata write API also provides a means for updating tags (i.e. creating
   * a new tag version); tag updates are allowed for all object types via the public
   * API. The current API requires a whole new tag to be supplied, this will be
   * replaced in a future version with an API that supplies attributes changes as a
   * set of add/modify/remove operations.
   * The read API is for reading metadata from the metadata store when the IDs of the
   * metadata items are known. The easiest way to read metadata is using TagSelectors,
   * which may be present in other metadata items (e.g. job definitions record tag
   * selectors to indicate which versions of resources were used in a job) or can be
   * easily constructed from an object ID or tag header. HTTP GET calls are also
   * available for REST clients (REST clients can still use selectors with POST
   * requests).
   * Metadata searches are performed using tag attributes, as well as an object type
   * and a few top-level parameters to handle versioning and temporality. See the
   * SearchParameters object for a more detailed description. The result of a search
   * call is a list of matching tags, which are always arranged with the most recent
   * tags first. A search that matches no results will return an empty list.
   * This API is a multi-tenant API. For gRPC requests every request includes a
   * tenant code, for REST requests the tenant code is the first element of every
   * path.
   * &#64;see tracdap.metadata.ObjectDefinition
   * &#64;see tracdap.metadata.Tag
   * &#64;see tracdap.metadata.TagHeader
   * &#64;see tracdap.metadata.TagSelector
   * &#64;see tracdap.metadata.TagUpdate
   * &#64;see tracdap.metadata.SearchParameters
   * </pre>
   */
  public static final class TracMetadataApiFutureStub extends io.grpc.stub.AbstractFutureStub<TracMetadataApiFutureStub> {
    private TracMetadataApiFutureStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected TracMetadataApiFutureStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new TracMetadataApiFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     **
     * Get some general information about the TRAC platform.
     * Information returned includes what environment you are connected to
     * and what version of TRAC is running. Useful for displaying in "about"
     * boxes in a UI or client tool, and for submitting error reports.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<org.finos.tracdap.api.PlatformInfoResponse> platformInfo(
        org.finos.tracdap.api.PlatformInfoRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getPlatformInfoMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * Get a list of tenants that the current user has access to.
     * Information returned includes the available tenant codes, as well
     * as human readable descriptions. Client tools that support multiple
     * tenants and tenant switching will need to fetch this list.
     * Only tenants accessible to the current user are returned.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<org.finos.tracdap.api.ListTenantsResponse> listTenants(
        org.finos.tracdap.api.ListTenantsRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getListTenantsMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * Create a new object in the TRAC metadata store.
     * To create an object, supply a metadata write request with the tenant code,
     * object type and a definition for the item you want to save. The tag should contain
     * all the attributes you want to set and the object definition, without an
     * object header. TRAC will create a header when it assigns and ID for the new
     * object. Only FLOW and CUSTOM objects can be created by this API call.
     * Validation is performed on new objects before they are saved. Objects can
     * fail validation because they are semantically invalid (e.g. missing
     * required fields or inconsistencies within the object definition) or due to
     * consistency errors (referring to other metadata items that don't exist or
     * don't meet certain requirements).
     * NOTE: Validation is only partially implemented in the current release.
     * The call returns an ID response to indicate the ID of the newly created
     * object, as well as the object and tag version (which will always be 1).
     * Error conditions include: Invalid request, unknown tenant, object type does
     * not match the supplied definition, validation failure.
     * &#64;see tracdap.metadata.ObjectDefinition
     * &#64;see tracdap.metadata.TagUpdate
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<org.finos.tracdap.metadata.TagHeader> createObject(
        org.finos.tracdap.api.MetadataWriteRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getCreateObjectMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * Create new objects in batch in the TRAC metadata store.
     * To create an object, supply a metadata write request with the tenant code,
     * object type and a definition for the item you want to save. The tag should contain
     * all the attributes you want to set and the object definition, without an
     * object header. TRAC will create a header when it assigns and ID for the new
     * object. Only FLOW and CUSTOM objects can be created by this API call.
     * Validation is performed on new objects before they are saved. Objects can
     * fail validation because they are semantically invalid (e.g. missing
     * required fields or inconsistencies within the object definition) or due to
     * consistency errors (referring to other metadata items that don't exist or
     * don't meet certain requirements).
     * NOTE: Validation is only partially implemented in the current release.
     * The call returns an ID responses to indicate the IDs of the newly created
     * objects, as well as the objects and tag versions (which will always be 1).
     * Error conditions include: Invalid request, unknown tenant, object type does
     * not match the supplied definition, validation failure.
     * &#64;see TracMetadataApi.createObject()
     * &#64;see tracdap.metadata.ObjectDefinition
     * &#64;see tracdap.metadata.TagUpdate
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<org.finos.tracdap.api.MetadataWriteBatchResponse> createObjectBatch(
        org.finos.tracdap.api.MetadataWriteBatchRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getCreateObjectBatchMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * Update an existing object in the TRAC metadata store.
     * To save a new version, supply a metadata write request with the tenant code,
     * object type and a tag for the item you want to save. The tag should contain
     * all the attributes you want to set and the updated object definition, which
     * must be supplied with the header from the *previous* version of the object.
     * TRAC will apply the new version number when it creates the new version of
     * the object. Only the latest version of an object can be updated and only
     * CUSTOM objects can be updated by this API call.
     * Validation is performed on new objects before they are saved. Objects can
     * fail validation because they are semantically invalid (e.g. missing
     * required fields or inconsistencies within the object definition) or due to
     * consistency errors (referring to other metadata items that don't exist or
     * don't meet certain requirements). For new versions, validation also covers
     * checking for compatibility with the previous version of the object.
     * NOTE: Validation is only partially implemented in the current release.
     * The call returns an ID response with the ID object and the newly assigned
     * version number, as well as the tag version (which will always be 1).
     * Error conditions include: Invalid request, unknown tenant, unknown object
     * ID or version, wrong object type (not the same as the prior version), object
     * version is superseded.
     * &#64;see tracdap.metadata.ObjectDefinition
     * &#64;see tracdap.metadata.TagSelector
     * &#64;see tracdap.metadata.TagUpdate
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<org.finos.tracdap.metadata.TagHeader> updateObject(
        org.finos.tracdap.api.MetadataWriteRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getUpdateObjectMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * Update existing objects in batch in the TRAC metadata store.
     * To save a new version, supply a metadata write request with the tenant code,
     * object type and a tag for the item you want to save. The tag should contain
     * all the attributes you want to set and the updated object definition, which
     * must be supplied with the header from the *previous* version of the object.
     * TRAC will apply the new version number when it creates the new version of
     * the object. Only the latest version of an object can be updated and only
     * CUSTOM objects can be updated by this API call.
     * Validation is performed on new objects before they are saved. Objects can
     * fail validation because they are semantically invalid (e.g. missing
     * required fields or inconsistencies within the object definition) or due to
     * consistency errors (referring to other metadata items that don't exist or
     * don't meet certain requirements). For new versions, validation also covers
     * checking for compatibility with the previous version of the object.
     * NOTE: Validation is only partially implemented in the current release.
     * The call returns an ID response with the ID object and the newly assigned
     * version number, as well as the tag version (which will always be 1).
     * Error conditions include: Invalid request, unknown tenant, unknown object
     * ID or version, wrong object type (not the same as the prior version), object
     * version is superseded.
     * &#64;see TracMetadataApi.updateObject()
     * &#64;see tracdap.metadata.ObjectDefinition
     * &#64;see tracdap.metadata.TagUpdate
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<org.finos.tracdap.api.MetadataWriteBatchResponse> updateObjectBatch(
        org.finos.tracdap.api.MetadataWriteBatchRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getUpdateObjectBatchMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * Update the tag for an existing object in the TRAC metadata store.
     * To save a new tag, supply a metadata write request with the tenant code,
     * object type and a tag for the item you want to save. The tag should contain
     * all the attributes you want to include in the new tag, even if they have
     * not been changed. The object definition must be supplied with a header only,
     * supplying an object body is an invalid request. Tags for any type of object
     * can be updated by this API call. Only the latest version of a tag can be
     * updated.
     * The call returns an ID response with the ID and version of the object and
     * the newly assigned tag number.
     * Error conditions include: Invalid request, unknown tenant, unknown object
     * ID, object version or tag version, wrong object type (does not match what
     * is stored in TRAC), tag version is superseded.
     * &#64;see tracdap.metadata.TagSelector
     * &#64;see tracdap.metadata.TagUpdate
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<org.finos.tracdap.metadata.TagHeader> updateTag(
        org.finos.tracdap.api.MetadataWriteRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getUpdateTagMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * Update tags in batch for existing objects in the TRAC metadata store.
     * To save a new tag, supply a metadata write request with the tenant code,
     * object type and a tag for the item you want to save. The tag should contain
     * all the attributes you want to include in the new tag, even if they have
     * not been changed. The object definition must be supplied with a header only,
     * supplying an object body is an invalid request. Tags for any type of object
     * can be updated by this API call. Only the latest version of a tag can be
     * updated.
     * The call returns an ID response with the ID and version of the object and
     * the newly assigned tag number.
     * Error conditions include: Invalid request, unknown tenant, unknown object
     * ID, object version or tag version, wrong object type (does not match what
     * is stored in TRAC), tag version is superseded.
     * &#64;see TracMetadataApi.updateTag()
     * &#64;see tracdap.metadata.ObjectDefinition
     * &#64;see tracdap.metadata.TagUpdate
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<org.finos.tracdap.api.MetadataWriteBatchResponse> updateTagBatch(
        org.finos.tracdap.api.MetadataWriteBatchRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getUpdateTagBatchMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * Read a single object from the TRAC metadata store using a tag selector.
     * Tag selectors are used throughout the TRAC metadata structures and API
     * calls to refer to objects. For example, a job definition includes
     * selectors to define the data sets and models that were selected for the
     * job. Those selectors can be passed directly into this call.
     * Tag selectors can refer to object and tag versions either using explicit
     * version numbers, with as-of times or by referring to the current latest
     * version. Combinations are also possible (e.g. object version x, latest
     * tag).
     * This call takes a single selector and returns a single Tag, including the
     * object definition. Error conditions include: Invalid request, unknown
     * tenant, unknown object ID, object type does not match ID, unknown object
     * version, unknown tag version.
     * &#64;see tracdap.metadata.TagSelector
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<org.finos.tracdap.metadata.Tag> readObject(
        org.finos.tracdap.api.MetadataReadRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getReadObjectMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * Read multiple objects from the TRAC metadata store using tag selectors.
     * Tag selectors are used throughout the TRAC metadata structures and API
     * calls to refer to objects. For example, a job definition includes
     * selectors to define the data sets and models that were selected for the
     * job. Those selectors can be passed directly into this call.
     * Tag selectors can refer to object and tag versions either using explicit
     * version numbers, with as-of times or by referring to the current latest
     * version. Combinations are also possible (e.g. object version x, latest
     * tag).
     * This call takes multiple selectors and returns multiple Tags in the same
     * order, including their object definitions. Selectors for different object
     * types and with different criteria for selecting versions can be mixed
     * freely in a single request. Error conditions include: Invalid request,
     * unknown tenant, unknown object ID, object type does not match ID, unknown
     * object version, unknown tag version. If there is an error for any of the
     * selectors the whole request will fail.
     * &#64;see tracdap.metadata.TagSelector
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<org.finos.tracdap.api.MetadataBatchResponse> readBatch(
        org.finos.tracdap.api.MetadataBatchRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getReadBatchMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * Perform a search against the TRAC metadata store.
     * Searches are always for a specific tenant and object type. For details of the
     * available search parameters, see SearchParameters.
     * In gRPC calls, a MetadataSearchRequest specifies the tenant and includes the
     * SearchParameters, where object type and the search expression are set. For
     * REST calls the tenant is passed in the URL and searchParameters are supplied
     * as the request body.
     * &#64;see tracdap.metadata.SearchParameters
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<org.finos.tracdap.api.MetadataSearchResponse> search(
        org.finos.tracdap.api.MetadataSearchRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getSearchMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * Get a single metadata object using an HTTP GET request.
     * This call is intended for use by REST clients to provide TRAC metadata
     * objects as RESTFUL resources. For gRPC clients it is recommended to use
     * readObject instead and supply a TagSelector.
     * &#64;see readObject
     * To use this call, supply a tenant code, object type, ID, object version
     * and tag version. The call will return a tag for the exact object version
     * and tag version specified, including the full object definition.
     * Error conditions include: Invalid request, unknown tenant, unknown object
     * ID, object type does not match ID, unknown object version, unknown tag
     * version.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<org.finos.tracdap.metadata.Tag> getObject(
        org.finos.tracdap.api.MetadataGetRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getGetObjectMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * Get the latest version of a metadata object using an HTTP GET request.
     * This call is intended for use by REST clients to provide TRAC metadata
     * objects as RESTFUL resources. For gRPC clients it is recommended to use
     * readObject instead and supply a TagSelector.
     * &#64;see readObject
     * To use this call, supply a tenant code, object type and ID. The call will
     * return the latest version of the object with its latest tag, including
     * the full object definition.
     * Error conditions include: Invalid request, unknown tenant, unknown object
     * ID, object type does not match ID.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<org.finos.tracdap.metadata.Tag> getLatestObject(
        org.finos.tracdap.api.MetadataGetRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getGetLatestObjectMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * Get the latest tag for a metadata object using an HTTP GET request.
     * This call is intended for use by REST clients to provide TRAC metadata
     * objects as RESTFUL resources. For gRPC clients it is recommended to use
     * readObject instead and supply a TagSelector.
     * &#64;see readObject
     * To use this call, supply a tenant code, object type, ID and version. The
     * call will return the latest tag for the specified version of the object,
     * including the full object definition.
     * Error conditions include: Invalid request, unknown tenant, unknown object
     * ID, object type does not match ID, unknown object version.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<org.finos.tracdap.metadata.Tag> getLatestTag(
        org.finos.tracdap.api.MetadataGetRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getGetLatestTagMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_PLATFORM_INFO = 0;
  private static final int METHODID_LIST_TENANTS = 1;
  private static final int METHODID_CREATE_OBJECT = 2;
  private static final int METHODID_CREATE_OBJECT_BATCH = 3;
  private static final int METHODID_UPDATE_OBJECT = 4;
  private static final int METHODID_UPDATE_OBJECT_BATCH = 5;
  private static final int METHODID_UPDATE_TAG = 6;
  private static final int METHODID_UPDATE_TAG_BATCH = 7;
  private static final int METHODID_READ_OBJECT = 8;
  private static final int METHODID_READ_BATCH = 9;
  private static final int METHODID_SEARCH = 10;
  private static final int METHODID_GET_OBJECT = 11;
  private static final int METHODID_GET_LATEST_OBJECT = 12;
  private static final int METHODID_GET_LATEST_TAG = 13;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final TracMetadataApiImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(TracMetadataApiImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_PLATFORM_INFO:
          serviceImpl.platformInfo((org.finos.tracdap.api.PlatformInfoRequest) request,
              (io.grpc.stub.StreamObserver<org.finos.tracdap.api.PlatformInfoResponse>) responseObserver);
          break;
        case METHODID_LIST_TENANTS:
          serviceImpl.listTenants((org.finos.tracdap.api.ListTenantsRequest) request,
              (io.grpc.stub.StreamObserver<org.finos.tracdap.api.ListTenantsResponse>) responseObserver);
          break;
        case METHODID_CREATE_OBJECT:
          serviceImpl.createObject((org.finos.tracdap.api.MetadataWriteRequest) request,
              (io.grpc.stub.StreamObserver<org.finos.tracdap.metadata.TagHeader>) responseObserver);
          break;
        case METHODID_CREATE_OBJECT_BATCH:
          serviceImpl.createObjectBatch((org.finos.tracdap.api.MetadataWriteBatchRequest) request,
              (io.grpc.stub.StreamObserver<org.finos.tracdap.api.MetadataWriteBatchResponse>) responseObserver);
          break;
        case METHODID_UPDATE_OBJECT:
          serviceImpl.updateObject((org.finos.tracdap.api.MetadataWriteRequest) request,
              (io.grpc.stub.StreamObserver<org.finos.tracdap.metadata.TagHeader>) responseObserver);
          break;
        case METHODID_UPDATE_OBJECT_BATCH:
          serviceImpl.updateObjectBatch((org.finos.tracdap.api.MetadataWriteBatchRequest) request,
              (io.grpc.stub.StreamObserver<org.finos.tracdap.api.MetadataWriteBatchResponse>) responseObserver);
          break;
        case METHODID_UPDATE_TAG:
          serviceImpl.updateTag((org.finos.tracdap.api.MetadataWriteRequest) request,
              (io.grpc.stub.StreamObserver<org.finos.tracdap.metadata.TagHeader>) responseObserver);
          break;
        case METHODID_UPDATE_TAG_BATCH:
          serviceImpl.updateTagBatch((org.finos.tracdap.api.MetadataWriteBatchRequest) request,
              (io.grpc.stub.StreamObserver<org.finos.tracdap.api.MetadataWriteBatchResponse>) responseObserver);
          break;
        case METHODID_READ_OBJECT:
          serviceImpl.readObject((org.finos.tracdap.api.MetadataReadRequest) request,
              (io.grpc.stub.StreamObserver<org.finos.tracdap.metadata.Tag>) responseObserver);
          break;
        case METHODID_READ_BATCH:
          serviceImpl.readBatch((org.finos.tracdap.api.MetadataBatchRequest) request,
              (io.grpc.stub.StreamObserver<org.finos.tracdap.api.MetadataBatchResponse>) responseObserver);
          break;
        case METHODID_SEARCH:
          serviceImpl.search((org.finos.tracdap.api.MetadataSearchRequest) request,
              (io.grpc.stub.StreamObserver<org.finos.tracdap.api.MetadataSearchResponse>) responseObserver);
          break;
        case METHODID_GET_OBJECT:
          serviceImpl.getObject((org.finos.tracdap.api.MetadataGetRequest) request,
              (io.grpc.stub.StreamObserver<org.finos.tracdap.metadata.Tag>) responseObserver);
          break;
        case METHODID_GET_LATEST_OBJECT:
          serviceImpl.getLatestObject((org.finos.tracdap.api.MetadataGetRequest) request,
              (io.grpc.stub.StreamObserver<org.finos.tracdap.metadata.Tag>) responseObserver);
          break;
        case METHODID_GET_LATEST_TAG:
          serviceImpl.getLatestTag((org.finos.tracdap.api.MetadataGetRequest) request,
              (io.grpc.stub.StreamObserver<org.finos.tracdap.metadata.Tag>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class TracMetadataApiBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    TracMetadataApiBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return org.finos.tracdap.api.Metadata.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("TracMetadataApi");
    }
  }

  private static final class TracMetadataApiFileDescriptorSupplier
      extends TracMetadataApiBaseDescriptorSupplier {
    TracMetadataApiFileDescriptorSupplier() {}
  }

  private static final class TracMetadataApiMethodDescriptorSupplier
      extends TracMetadataApiBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    TracMetadataApiMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (TracMetadataApiGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new TracMetadataApiFileDescriptorSupplier())
              .addMethod(getPlatformInfoMethod())
              .addMethod(getListTenantsMethod())
              .addMethod(getCreateObjectMethod())
              .addMethod(getCreateObjectBatchMethod())
              .addMethod(getUpdateObjectMethod())
              .addMethod(getUpdateObjectBatchMethod())
              .addMethod(getUpdateTagMethod())
              .addMethod(getUpdateTagBatchMethod())
              .addMethod(getReadObjectMethod())
              .addMethod(getReadBatchMethod())
              .addMethod(getSearchMethod())
              .addMethod(getGetObjectMethod())
              .addMethod(getGetLatestObjectMethod())
              .addMethod(getGetLatestTagMethod())
              .build();
        }
      }
    }
    return result;
  }
}
