package org.finos.tracdap.api;

import static io.grpc.MethodDescriptor.generateFullMethodName;

/**
 * <pre>
 **
 * Trusted API reading, writing and searching for objects in the TRAC metadata store.
 * This API is only available to other components of the TRAC platform, it is
 * not exposed to clients via the platform gateway.
 * Most of the calls in this interface are identical to their public equivalents.
 * Extra calls are available for pre-allocating objects, a facility which is not
 * available to clients of the platform. Restrictions on the creation of certain
 * object types and manipulation of controlled tag attributes are lifted. Methods
 * for performing HTTP GET requests of RESTFUL resources are not duplicated.
 * &#64;see TracMetadataApi
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.49.0)",
    comments = "Source: tracdap/api/metadata_trusted.proto")
@io.grpc.stub.annotations.GrpcGenerated
public final class TrustedMetadataApiGrpc {

  private TrustedMetadataApiGrpc() {}

  public static final String SERVICE_NAME = "tracdap.api.TrustedMetadataApi";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataWriteRequest,
      org.finos.tracdap.metadata.TagHeader> getCreateObjectMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "createObject",
      requestType = org.finos.tracdap.api.MetadataWriteRequest.class,
      responseType = org.finos.tracdap.metadata.TagHeader.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataWriteRequest,
      org.finos.tracdap.metadata.TagHeader> getCreateObjectMethod() {
    io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataWriteRequest, org.finos.tracdap.metadata.TagHeader> getCreateObjectMethod;
    if ((getCreateObjectMethod = TrustedMetadataApiGrpc.getCreateObjectMethod) == null) {
      synchronized (TrustedMetadataApiGrpc.class) {
        if ((getCreateObjectMethod = TrustedMetadataApiGrpc.getCreateObjectMethod) == null) {
          TrustedMetadataApiGrpc.getCreateObjectMethod = getCreateObjectMethod =
              io.grpc.MethodDescriptor.<org.finos.tracdap.api.MetadataWriteRequest, org.finos.tracdap.metadata.TagHeader>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "createObject"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.finos.tracdap.api.MetadataWriteRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.finos.tracdap.metadata.TagHeader.getDefaultInstance()))
              .setSchemaDescriptor(new TrustedMetadataApiMethodDescriptorSupplier("createObject"))
              .build();
        }
      }
    }
    return getCreateObjectMethod;
  }

  private static volatile io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataWriteBatchRequest,
      org.finos.tracdap.api.MetadataWriteBatchResponse> getCreateObjectBatchMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "createObjectBatch",
      requestType = org.finos.tracdap.api.MetadataWriteBatchRequest.class,
      responseType = org.finos.tracdap.api.MetadataWriteBatchResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataWriteBatchRequest,
      org.finos.tracdap.api.MetadataWriteBatchResponse> getCreateObjectBatchMethod() {
    io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataWriteBatchRequest, org.finos.tracdap.api.MetadataWriteBatchResponse> getCreateObjectBatchMethod;
    if ((getCreateObjectBatchMethod = TrustedMetadataApiGrpc.getCreateObjectBatchMethod) == null) {
      synchronized (TrustedMetadataApiGrpc.class) {
        if ((getCreateObjectBatchMethod = TrustedMetadataApiGrpc.getCreateObjectBatchMethod) == null) {
          TrustedMetadataApiGrpc.getCreateObjectBatchMethod = getCreateObjectBatchMethod =
              io.grpc.MethodDescriptor.<org.finos.tracdap.api.MetadataWriteBatchRequest, org.finos.tracdap.api.MetadataWriteBatchResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "createObjectBatch"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.finos.tracdap.api.MetadataWriteBatchRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.finos.tracdap.api.MetadataWriteBatchResponse.getDefaultInstance()))
              .setSchemaDescriptor(new TrustedMetadataApiMethodDescriptorSupplier("createObjectBatch"))
              .build();
        }
      }
    }
    return getCreateObjectBatchMethod;
  }

  private static volatile io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataWriteRequest,
      org.finos.tracdap.metadata.TagHeader> getUpdateObjectMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "updateObject",
      requestType = org.finos.tracdap.api.MetadataWriteRequest.class,
      responseType = org.finos.tracdap.metadata.TagHeader.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataWriteRequest,
      org.finos.tracdap.metadata.TagHeader> getUpdateObjectMethod() {
    io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataWriteRequest, org.finos.tracdap.metadata.TagHeader> getUpdateObjectMethod;
    if ((getUpdateObjectMethod = TrustedMetadataApiGrpc.getUpdateObjectMethod) == null) {
      synchronized (TrustedMetadataApiGrpc.class) {
        if ((getUpdateObjectMethod = TrustedMetadataApiGrpc.getUpdateObjectMethod) == null) {
          TrustedMetadataApiGrpc.getUpdateObjectMethod = getUpdateObjectMethod =
              io.grpc.MethodDescriptor.<org.finos.tracdap.api.MetadataWriteRequest, org.finos.tracdap.metadata.TagHeader>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "updateObject"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.finos.tracdap.api.MetadataWriteRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.finos.tracdap.metadata.TagHeader.getDefaultInstance()))
              .setSchemaDescriptor(new TrustedMetadataApiMethodDescriptorSupplier("updateObject"))
              .build();
        }
      }
    }
    return getUpdateObjectMethod;
  }

  private static volatile io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataWriteBatchRequest,
      org.finos.tracdap.api.MetadataWriteBatchResponse> getUpdateObjectBatchMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "updateObjectBatch",
      requestType = org.finos.tracdap.api.MetadataWriteBatchRequest.class,
      responseType = org.finos.tracdap.api.MetadataWriteBatchResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataWriteBatchRequest,
      org.finos.tracdap.api.MetadataWriteBatchResponse> getUpdateObjectBatchMethod() {
    io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataWriteBatchRequest, org.finos.tracdap.api.MetadataWriteBatchResponse> getUpdateObjectBatchMethod;
    if ((getUpdateObjectBatchMethod = TrustedMetadataApiGrpc.getUpdateObjectBatchMethod) == null) {
      synchronized (TrustedMetadataApiGrpc.class) {
        if ((getUpdateObjectBatchMethod = TrustedMetadataApiGrpc.getUpdateObjectBatchMethod) == null) {
          TrustedMetadataApiGrpc.getUpdateObjectBatchMethod = getUpdateObjectBatchMethod =
              io.grpc.MethodDescriptor.<org.finos.tracdap.api.MetadataWriteBatchRequest, org.finos.tracdap.api.MetadataWriteBatchResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "updateObjectBatch"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.finos.tracdap.api.MetadataWriteBatchRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.finos.tracdap.api.MetadataWriteBatchResponse.getDefaultInstance()))
              .setSchemaDescriptor(new TrustedMetadataApiMethodDescriptorSupplier("updateObjectBatch"))
              .build();
        }
      }
    }
    return getUpdateObjectBatchMethod;
  }

  private static volatile io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataWriteRequest,
      org.finos.tracdap.metadata.TagHeader> getUpdateTagMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "updateTag",
      requestType = org.finos.tracdap.api.MetadataWriteRequest.class,
      responseType = org.finos.tracdap.metadata.TagHeader.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataWriteRequest,
      org.finos.tracdap.metadata.TagHeader> getUpdateTagMethod() {
    io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataWriteRequest, org.finos.tracdap.metadata.TagHeader> getUpdateTagMethod;
    if ((getUpdateTagMethod = TrustedMetadataApiGrpc.getUpdateTagMethod) == null) {
      synchronized (TrustedMetadataApiGrpc.class) {
        if ((getUpdateTagMethod = TrustedMetadataApiGrpc.getUpdateTagMethod) == null) {
          TrustedMetadataApiGrpc.getUpdateTagMethod = getUpdateTagMethod =
              io.grpc.MethodDescriptor.<org.finos.tracdap.api.MetadataWriteRequest, org.finos.tracdap.metadata.TagHeader>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "updateTag"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.finos.tracdap.api.MetadataWriteRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.finos.tracdap.metadata.TagHeader.getDefaultInstance()))
              .setSchemaDescriptor(new TrustedMetadataApiMethodDescriptorSupplier("updateTag"))
              .build();
        }
      }
    }
    return getUpdateTagMethod;
  }

  private static volatile io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataWriteBatchRequest,
      org.finos.tracdap.api.MetadataWriteBatchResponse> getUpdateTagBatchMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "updateTagBatch",
      requestType = org.finos.tracdap.api.MetadataWriteBatchRequest.class,
      responseType = org.finos.tracdap.api.MetadataWriteBatchResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataWriteBatchRequest,
      org.finos.tracdap.api.MetadataWriteBatchResponse> getUpdateTagBatchMethod() {
    io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataWriteBatchRequest, org.finos.tracdap.api.MetadataWriteBatchResponse> getUpdateTagBatchMethod;
    if ((getUpdateTagBatchMethod = TrustedMetadataApiGrpc.getUpdateTagBatchMethod) == null) {
      synchronized (TrustedMetadataApiGrpc.class) {
        if ((getUpdateTagBatchMethod = TrustedMetadataApiGrpc.getUpdateTagBatchMethod) == null) {
          TrustedMetadataApiGrpc.getUpdateTagBatchMethod = getUpdateTagBatchMethod =
              io.grpc.MethodDescriptor.<org.finos.tracdap.api.MetadataWriteBatchRequest, org.finos.tracdap.api.MetadataWriteBatchResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "updateTagBatch"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.finos.tracdap.api.MetadataWriteBatchRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.finos.tracdap.api.MetadataWriteBatchResponse.getDefaultInstance()))
              .setSchemaDescriptor(new TrustedMetadataApiMethodDescriptorSupplier("updateTagBatch"))
              .build();
        }
      }
    }
    return getUpdateTagBatchMethod;
  }

  private static volatile io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataWriteRequest,
      org.finos.tracdap.metadata.TagHeader> getPreallocateIdMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "preallocateId",
      requestType = org.finos.tracdap.api.MetadataWriteRequest.class,
      responseType = org.finos.tracdap.metadata.TagHeader.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataWriteRequest,
      org.finos.tracdap.metadata.TagHeader> getPreallocateIdMethod() {
    io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataWriteRequest, org.finos.tracdap.metadata.TagHeader> getPreallocateIdMethod;
    if ((getPreallocateIdMethod = TrustedMetadataApiGrpc.getPreallocateIdMethod) == null) {
      synchronized (TrustedMetadataApiGrpc.class) {
        if ((getPreallocateIdMethod = TrustedMetadataApiGrpc.getPreallocateIdMethod) == null) {
          TrustedMetadataApiGrpc.getPreallocateIdMethod = getPreallocateIdMethod =
              io.grpc.MethodDescriptor.<org.finos.tracdap.api.MetadataWriteRequest, org.finos.tracdap.metadata.TagHeader>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "preallocateId"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.finos.tracdap.api.MetadataWriteRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.finos.tracdap.metadata.TagHeader.getDefaultInstance()))
              .setSchemaDescriptor(new TrustedMetadataApiMethodDescriptorSupplier("preallocateId"))
              .build();
        }
      }
    }
    return getPreallocateIdMethod;
  }

  private static volatile io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataWriteBatchRequest,
      org.finos.tracdap.api.MetadataWriteBatchResponse> getPreallocateIdBatchMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "preallocateIdBatch",
      requestType = org.finos.tracdap.api.MetadataWriteBatchRequest.class,
      responseType = org.finos.tracdap.api.MetadataWriteBatchResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataWriteBatchRequest,
      org.finos.tracdap.api.MetadataWriteBatchResponse> getPreallocateIdBatchMethod() {
    io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataWriteBatchRequest, org.finos.tracdap.api.MetadataWriteBatchResponse> getPreallocateIdBatchMethod;
    if ((getPreallocateIdBatchMethod = TrustedMetadataApiGrpc.getPreallocateIdBatchMethod) == null) {
      synchronized (TrustedMetadataApiGrpc.class) {
        if ((getPreallocateIdBatchMethod = TrustedMetadataApiGrpc.getPreallocateIdBatchMethod) == null) {
          TrustedMetadataApiGrpc.getPreallocateIdBatchMethod = getPreallocateIdBatchMethod =
              io.grpc.MethodDescriptor.<org.finos.tracdap.api.MetadataWriteBatchRequest, org.finos.tracdap.api.MetadataWriteBatchResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "preallocateIdBatch"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.finos.tracdap.api.MetadataWriteBatchRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.finos.tracdap.api.MetadataWriteBatchResponse.getDefaultInstance()))
              .setSchemaDescriptor(new TrustedMetadataApiMethodDescriptorSupplier("preallocateIdBatch"))
              .build();
        }
      }
    }
    return getPreallocateIdBatchMethod;
  }

  private static volatile io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataWriteRequest,
      org.finos.tracdap.metadata.TagHeader> getCreatePreallocatedObjectMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "createPreallocatedObject",
      requestType = org.finos.tracdap.api.MetadataWriteRequest.class,
      responseType = org.finos.tracdap.metadata.TagHeader.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataWriteRequest,
      org.finos.tracdap.metadata.TagHeader> getCreatePreallocatedObjectMethod() {
    io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataWriteRequest, org.finos.tracdap.metadata.TagHeader> getCreatePreallocatedObjectMethod;
    if ((getCreatePreallocatedObjectMethod = TrustedMetadataApiGrpc.getCreatePreallocatedObjectMethod) == null) {
      synchronized (TrustedMetadataApiGrpc.class) {
        if ((getCreatePreallocatedObjectMethod = TrustedMetadataApiGrpc.getCreatePreallocatedObjectMethod) == null) {
          TrustedMetadataApiGrpc.getCreatePreallocatedObjectMethod = getCreatePreallocatedObjectMethod =
              io.grpc.MethodDescriptor.<org.finos.tracdap.api.MetadataWriteRequest, org.finos.tracdap.metadata.TagHeader>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "createPreallocatedObject"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.finos.tracdap.api.MetadataWriteRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.finos.tracdap.metadata.TagHeader.getDefaultInstance()))
              .setSchemaDescriptor(new TrustedMetadataApiMethodDescriptorSupplier("createPreallocatedObject"))
              .build();
        }
      }
    }
    return getCreatePreallocatedObjectMethod;
  }

  private static volatile io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataWriteBatchRequest,
      org.finos.tracdap.api.MetadataWriteBatchResponse> getCreatePreallocatedObjectBatchMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "createPreallocatedObjectBatch",
      requestType = org.finos.tracdap.api.MetadataWriteBatchRequest.class,
      responseType = org.finos.tracdap.api.MetadataWriteBatchResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataWriteBatchRequest,
      org.finos.tracdap.api.MetadataWriteBatchResponse> getCreatePreallocatedObjectBatchMethod() {
    io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataWriteBatchRequest, org.finos.tracdap.api.MetadataWriteBatchResponse> getCreatePreallocatedObjectBatchMethod;
    if ((getCreatePreallocatedObjectBatchMethod = TrustedMetadataApiGrpc.getCreatePreallocatedObjectBatchMethod) == null) {
      synchronized (TrustedMetadataApiGrpc.class) {
        if ((getCreatePreallocatedObjectBatchMethod = TrustedMetadataApiGrpc.getCreatePreallocatedObjectBatchMethod) == null) {
          TrustedMetadataApiGrpc.getCreatePreallocatedObjectBatchMethod = getCreatePreallocatedObjectBatchMethod =
              io.grpc.MethodDescriptor.<org.finos.tracdap.api.MetadataWriteBatchRequest, org.finos.tracdap.api.MetadataWriteBatchResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "createPreallocatedObjectBatch"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.finos.tracdap.api.MetadataWriteBatchRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.finos.tracdap.api.MetadataWriteBatchResponse.getDefaultInstance()))
              .setSchemaDescriptor(new TrustedMetadataApiMethodDescriptorSupplier("createPreallocatedObjectBatch"))
              .build();
        }
      }
    }
    return getCreatePreallocatedObjectBatchMethod;
  }

  private static volatile io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataReadRequest,
      org.finos.tracdap.metadata.Tag> getReadObjectMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "readObject",
      requestType = org.finos.tracdap.api.MetadataReadRequest.class,
      responseType = org.finos.tracdap.metadata.Tag.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataReadRequest,
      org.finos.tracdap.metadata.Tag> getReadObjectMethod() {
    io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataReadRequest, org.finos.tracdap.metadata.Tag> getReadObjectMethod;
    if ((getReadObjectMethod = TrustedMetadataApiGrpc.getReadObjectMethod) == null) {
      synchronized (TrustedMetadataApiGrpc.class) {
        if ((getReadObjectMethod = TrustedMetadataApiGrpc.getReadObjectMethod) == null) {
          TrustedMetadataApiGrpc.getReadObjectMethod = getReadObjectMethod =
              io.grpc.MethodDescriptor.<org.finos.tracdap.api.MetadataReadRequest, org.finos.tracdap.metadata.Tag>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "readObject"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.finos.tracdap.api.MetadataReadRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.finos.tracdap.metadata.Tag.getDefaultInstance()))
              .setSchemaDescriptor(new TrustedMetadataApiMethodDescriptorSupplier("readObject"))
              .build();
        }
      }
    }
    return getReadObjectMethod;
  }

  private static volatile io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataBatchRequest,
      org.finos.tracdap.api.MetadataBatchResponse> getReadBatchMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "readBatch",
      requestType = org.finos.tracdap.api.MetadataBatchRequest.class,
      responseType = org.finos.tracdap.api.MetadataBatchResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataBatchRequest,
      org.finos.tracdap.api.MetadataBatchResponse> getReadBatchMethod() {
    io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataBatchRequest, org.finos.tracdap.api.MetadataBatchResponse> getReadBatchMethod;
    if ((getReadBatchMethod = TrustedMetadataApiGrpc.getReadBatchMethod) == null) {
      synchronized (TrustedMetadataApiGrpc.class) {
        if ((getReadBatchMethod = TrustedMetadataApiGrpc.getReadBatchMethod) == null) {
          TrustedMetadataApiGrpc.getReadBatchMethod = getReadBatchMethod =
              io.grpc.MethodDescriptor.<org.finos.tracdap.api.MetadataBatchRequest, org.finos.tracdap.api.MetadataBatchResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "readBatch"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.finos.tracdap.api.MetadataBatchRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.finos.tracdap.api.MetadataBatchResponse.getDefaultInstance()))
              .setSchemaDescriptor(new TrustedMetadataApiMethodDescriptorSupplier("readBatch"))
              .build();
        }
      }
    }
    return getReadBatchMethod;
  }

  private static volatile io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataSearchRequest,
      org.finos.tracdap.api.MetadataSearchResponse> getSearchMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "search",
      requestType = org.finos.tracdap.api.MetadataSearchRequest.class,
      responseType = org.finos.tracdap.api.MetadataSearchResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataSearchRequest,
      org.finos.tracdap.api.MetadataSearchResponse> getSearchMethod() {
    io.grpc.MethodDescriptor<org.finos.tracdap.api.MetadataSearchRequest, org.finos.tracdap.api.MetadataSearchResponse> getSearchMethod;
    if ((getSearchMethod = TrustedMetadataApiGrpc.getSearchMethod) == null) {
      synchronized (TrustedMetadataApiGrpc.class) {
        if ((getSearchMethod = TrustedMetadataApiGrpc.getSearchMethod) == null) {
          TrustedMetadataApiGrpc.getSearchMethod = getSearchMethod =
              io.grpc.MethodDescriptor.<org.finos.tracdap.api.MetadataSearchRequest, org.finos.tracdap.api.MetadataSearchResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "search"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.finos.tracdap.api.MetadataSearchRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  org.finos.tracdap.api.MetadataSearchResponse.getDefaultInstance()))
              .setSchemaDescriptor(new TrustedMetadataApiMethodDescriptorSupplier("search"))
              .build();
        }
      }
    }
    return getSearchMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static TrustedMetadataApiStub newStub(io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<TrustedMetadataApiStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<TrustedMetadataApiStub>() {
        @java.lang.Override
        public TrustedMetadataApiStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new TrustedMetadataApiStub(channel, callOptions);
        }
      };
    return TrustedMetadataApiStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static TrustedMetadataApiBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<TrustedMetadataApiBlockingStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<TrustedMetadataApiBlockingStub>() {
        @java.lang.Override
        public TrustedMetadataApiBlockingStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new TrustedMetadataApiBlockingStub(channel, callOptions);
        }
      };
    return TrustedMetadataApiBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static TrustedMetadataApiFutureStub newFutureStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<TrustedMetadataApiFutureStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<TrustedMetadataApiFutureStub>() {
        @java.lang.Override
        public TrustedMetadataApiFutureStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new TrustedMetadataApiFutureStub(channel, callOptions);
        }
      };
    return TrustedMetadataApiFutureStub.newStub(factory, channel);
  }

  /**
   * <pre>
   **
   * Trusted API reading, writing and searching for objects in the TRAC metadata store.
   * This API is only available to other components of the TRAC platform, it is
   * not exposed to clients via the platform gateway.
   * Most of the calls in this interface are identical to their public equivalents.
   * Extra calls are available for pre-allocating objects, a facility which is not
   * available to clients of the platform. Restrictions on the creation of certain
   * object types and manipulation of controlled tag attributes are lifted. Methods
   * for performing HTTP GET requests of RESTFUL resources are not duplicated.
   * &#64;see TracMetadataApi
   * </pre>
   */
  public static abstract class TrustedMetadataApiImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     **
     * Create a new object in the TRAC metadata store.
     * This call behaves identically to the equivalent public API call, without the
     * restriction on which types of object can be saved.
     * &#64;see TracMetadataApi.createObject()
     * </pre>
     */
    public void createObject(org.finos.tracdap.api.MetadataWriteRequest request,
        io.grpc.stub.StreamObserver<org.finos.tracdap.metadata.TagHeader> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getCreateObjectMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Create new objects in the TRAC metadata store.
     * This call behaves identically to the equivalent public API call, without the
     * restriction on which types of object can be saved.
     * &#64;see TracMetadataApi.createObjectBatch()
     * &#64;see TracMetadataApi.createObject()
     * </pre>
     */
    public void createObjectBatch(org.finos.tracdap.api.MetadataWriteBatchRequest request,
        io.grpc.stub.StreamObserver<org.finos.tracdap.api.MetadataWriteBatchResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getCreateObjectBatchMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Update an existing object in the TRAC metadata store.
     * This call behaves identically to the equivalent public API call, however it
     * can be used with any type of object that supports versioning (currently DATA
     * and CUSTOM).
     * &#64;see TracMetadataApi.updateObject()
     * </pre>
     */
    public void updateObject(org.finos.tracdap.api.MetadataWriteRequest request,
        io.grpc.stub.StreamObserver<org.finos.tracdap.metadata.TagHeader> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getUpdateObjectMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Update existing objects in the TRAC metadata store.
     * This call behaves identically to the equivalent public API call, however it
     * can be used with any type of object that supports versioning (currently DATA
     * and CUSTOM).
     * &#64;see TracMetadataApi.updateObjectBatch()
     * &#64;see TracMetadataApi.updateObject()
     * </pre>
     */
    public void updateObjectBatch(org.finos.tracdap.api.MetadataWriteBatchRequest request,
        io.grpc.stub.StreamObserver<org.finos.tracdap.api.MetadataWriteBatchResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getUpdateObjectBatchMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Update the tag for an existing object in the TRAC metadata store.
     * This call behaves identically to the equivalent public API call.
     * &#64;see TracMetadataApi.updateTag()
     * </pre>
     */
    public void updateTag(org.finos.tracdap.api.MetadataWriteRequest request,
        io.grpc.stub.StreamObserver<org.finos.tracdap.metadata.TagHeader> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getUpdateTagMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Update tags for existing objects in the TRAC metadata store.
     * This call behaves identically to the equivalent public API call, however it
     * can be used with any type of object that supports versioning (currently DATA
     * and CUSTOM).
     * &#64;see TracMetadataApi.updateTagBatch()
     * &#64;see TracMetadataApi.updateTag()
     * </pre>
     */
    public void updateTagBatch(org.finos.tracdap.api.MetadataWriteBatchRequest request,
        io.grpc.stub.StreamObserver<org.finos.tracdap.api.MetadataWriteBatchResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getUpdateTagBatchMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Preallocate an object ID for an object that will be created later.
     * This call is for use by TRAC components that need to reserve an ID before
     * it is used, particularly if the object ID must be included in the definition
     * of an object that has not been created yet. When creating an ID the tenant
     * and object type must be specified, the object that is eventually saved must
     * match these two conditions. Orphan IDs are expected - if a component request
     * an ID and encounters an error before that ID is used, the orphan ID is just
     * ignored.
     * </pre>
     */
    public void preallocateId(org.finos.tracdap.api.MetadataWriteRequest request,
        io.grpc.stub.StreamObserver<org.finos.tracdap.metadata.TagHeader> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getPreallocateIdMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Preallocate object IDs in batch for objects that will be created later.
     * This call is for use by TRAC components that need to reserve an ID before
     * it is used, particularly if the object ID must be included in the definition
     * of an object that has not been created yet. When creating an ID the tenant
     * and object type must be specified, the object that is eventually saved must
     * match these two conditions. Orphan IDs are expected - if a component request
     * an ID and encounters an error before that ID is used, the orphan ID is just
     * ignored.
     * &#64;see TrustedMetadataApi.preallocateId()
     * </pre>
     */
    public void preallocateIdBatch(org.finos.tracdap.api.MetadataWriteBatchRequest request,
        io.grpc.stub.StreamObserver<org.finos.tracdap.api.MetadataWriteBatchResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getPreallocateIdBatchMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Create an object using an ID that was previously preallocated.
     * This call behaves essentially the same as saveNewObject(), with all the
     * same validation. The only difference is that the new definition must be
     * supplied with an object header, including the object ID returned from a
     * prior call to preallocateId().
     * Error conditions include all the error conditions for saveNewObject().
     * Using a preallocated ID twice, attempting to save to an unknown ID or the
     * ID of another object that already exists are also errors.
     * </pre>
     */
    public void createPreallocatedObject(org.finos.tracdap.api.MetadataWriteRequest request,
        io.grpc.stub.StreamObserver<org.finos.tracdap.metadata.TagHeader> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getCreatePreallocatedObjectMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Create objects in batch using IDs that were previously preallocated.
     * This call behaves essentially the same as saveNewObject(), with all the
     * same validation. The only difference is that the new definition must be
     * supplied with an object header, including the object ID returned from a
     * prior call to preallocateId().
     * Error conditions include all the error conditions for saveNewObject().
     * Using a preallocated ID twice, attempting to save to an unknown ID or the
     * ID of another object that already exists are also errors.
     * &#64;see TrustedMetadataApi.createPreallocatedObject()
     * </pre>
     */
    public void createPreallocatedObjectBatch(org.finos.tracdap.api.MetadataWriteBatchRequest request,
        io.grpc.stub.StreamObserver<org.finos.tracdap.api.MetadataWriteBatchResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getCreatePreallocatedObjectBatchMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Read a single object from the TRAC metadata store using a tag selector.
     * This call behaves identically to the equivalent public API call.
     * &#64;see TracMetadataApi.readObject()
     * </pre>
     */
    public void readObject(org.finos.tracdap.api.MetadataReadRequest request,
        io.grpc.stub.StreamObserver<org.finos.tracdap.metadata.Tag> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getReadObjectMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Read multiple objects from the TRAC metadata store using tag selectors.
     * This call behaves identically to the equivalent public API call.
     * &#64;see TracMetadataApi.readBatch()
     * </pre>
     */
    public void readBatch(org.finos.tracdap.api.MetadataBatchRequest request,
        io.grpc.stub.StreamObserver<org.finos.tracdap.api.MetadataBatchResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getReadBatchMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Perform a search against the TRAC metadata store.
     * This call behaves identically to the equivalent public API call.
     * &#64;see TracMetadataApi.search()
     * </pre>
     */
    public void search(org.finos.tracdap.api.MetadataSearchRequest request,
        io.grpc.stub.StreamObserver<org.finos.tracdap.api.MetadataSearchResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getSearchMethod(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getCreateObjectMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                org.finos.tracdap.api.MetadataWriteRequest,
                org.finos.tracdap.metadata.TagHeader>(
                  this, METHODID_CREATE_OBJECT)))
          .addMethod(
            getCreateObjectBatchMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                org.finos.tracdap.api.MetadataWriteBatchRequest,
                org.finos.tracdap.api.MetadataWriteBatchResponse>(
                  this, METHODID_CREATE_OBJECT_BATCH)))
          .addMethod(
            getUpdateObjectMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                org.finos.tracdap.api.MetadataWriteRequest,
                org.finos.tracdap.metadata.TagHeader>(
                  this, METHODID_UPDATE_OBJECT)))
          .addMethod(
            getUpdateObjectBatchMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                org.finos.tracdap.api.MetadataWriteBatchRequest,
                org.finos.tracdap.api.MetadataWriteBatchResponse>(
                  this, METHODID_UPDATE_OBJECT_BATCH)))
          .addMethod(
            getUpdateTagMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                org.finos.tracdap.api.MetadataWriteRequest,
                org.finos.tracdap.metadata.TagHeader>(
                  this, METHODID_UPDATE_TAG)))
          .addMethod(
            getUpdateTagBatchMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                org.finos.tracdap.api.MetadataWriteBatchRequest,
                org.finos.tracdap.api.MetadataWriteBatchResponse>(
                  this, METHODID_UPDATE_TAG_BATCH)))
          .addMethod(
            getPreallocateIdMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                org.finos.tracdap.api.MetadataWriteRequest,
                org.finos.tracdap.metadata.TagHeader>(
                  this, METHODID_PREALLOCATE_ID)))
          .addMethod(
            getPreallocateIdBatchMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                org.finos.tracdap.api.MetadataWriteBatchRequest,
                org.finos.tracdap.api.MetadataWriteBatchResponse>(
                  this, METHODID_PREALLOCATE_ID_BATCH)))
          .addMethod(
            getCreatePreallocatedObjectMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                org.finos.tracdap.api.MetadataWriteRequest,
                org.finos.tracdap.metadata.TagHeader>(
                  this, METHODID_CREATE_PREALLOCATED_OBJECT)))
          .addMethod(
            getCreatePreallocatedObjectBatchMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                org.finos.tracdap.api.MetadataWriteBatchRequest,
                org.finos.tracdap.api.MetadataWriteBatchResponse>(
                  this, METHODID_CREATE_PREALLOCATED_OBJECT_BATCH)))
          .addMethod(
            getReadObjectMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                org.finos.tracdap.api.MetadataReadRequest,
                org.finos.tracdap.metadata.Tag>(
                  this, METHODID_READ_OBJECT)))
          .addMethod(
            getReadBatchMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                org.finos.tracdap.api.MetadataBatchRequest,
                org.finos.tracdap.api.MetadataBatchResponse>(
                  this, METHODID_READ_BATCH)))
          .addMethod(
            getSearchMethod(),
            io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                org.finos.tracdap.api.MetadataSearchRequest,
                org.finos.tracdap.api.MetadataSearchResponse>(
                  this, METHODID_SEARCH)))
          .build();
    }
  }

  /**
   * <pre>
   **
   * Trusted API reading, writing and searching for objects in the TRAC metadata store.
   * This API is only available to other components of the TRAC platform, it is
   * not exposed to clients via the platform gateway.
   * Most of the calls in this interface are identical to their public equivalents.
   * Extra calls are available for pre-allocating objects, a facility which is not
   * available to clients of the platform. Restrictions on the creation of certain
   * object types and manipulation of controlled tag attributes are lifted. Methods
   * for performing HTTP GET requests of RESTFUL resources are not duplicated.
   * &#64;see TracMetadataApi
   * </pre>
   */
  public static final class TrustedMetadataApiStub extends io.grpc.stub.AbstractAsyncStub<TrustedMetadataApiStub> {
    private TrustedMetadataApiStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected TrustedMetadataApiStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new TrustedMetadataApiStub(channel, callOptions);
    }

    /**
     * <pre>
     **
     * Create a new object in the TRAC metadata store.
     * This call behaves identically to the equivalent public API call, without the
     * restriction on which types of object can be saved.
     * &#64;see TracMetadataApi.createObject()
     * </pre>
     */
    public void createObject(org.finos.tracdap.api.MetadataWriteRequest request,
        io.grpc.stub.StreamObserver<org.finos.tracdap.metadata.TagHeader> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getCreateObjectMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Create new objects in the TRAC metadata store.
     * This call behaves identically to the equivalent public API call, without the
     * restriction on which types of object can be saved.
     * &#64;see TracMetadataApi.createObjectBatch()
     * &#64;see TracMetadataApi.createObject()
     * </pre>
     */
    public void createObjectBatch(org.finos.tracdap.api.MetadataWriteBatchRequest request,
        io.grpc.stub.StreamObserver<org.finos.tracdap.api.MetadataWriteBatchResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getCreateObjectBatchMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Update an existing object in the TRAC metadata store.
     * This call behaves identically to the equivalent public API call, however it
     * can be used with any type of object that supports versioning (currently DATA
     * and CUSTOM).
     * &#64;see TracMetadataApi.updateObject()
     * </pre>
     */
    public void updateObject(org.finos.tracdap.api.MetadataWriteRequest request,
        io.grpc.stub.StreamObserver<org.finos.tracdap.metadata.TagHeader> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getUpdateObjectMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Update existing objects in the TRAC metadata store.
     * This call behaves identically to the equivalent public API call, however it
     * can be used with any type of object that supports versioning (currently DATA
     * and CUSTOM).
     * &#64;see TracMetadataApi.updateObjectBatch()
     * &#64;see TracMetadataApi.updateObject()
     * </pre>
     */
    public void updateObjectBatch(org.finos.tracdap.api.MetadataWriteBatchRequest request,
        io.grpc.stub.StreamObserver<org.finos.tracdap.api.MetadataWriteBatchResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getUpdateObjectBatchMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Update the tag for an existing object in the TRAC metadata store.
     * This call behaves identically to the equivalent public API call.
     * &#64;see TracMetadataApi.updateTag()
     * </pre>
     */
    public void updateTag(org.finos.tracdap.api.MetadataWriteRequest request,
        io.grpc.stub.StreamObserver<org.finos.tracdap.metadata.TagHeader> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getUpdateTagMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Update tags for existing objects in the TRAC metadata store.
     * This call behaves identically to the equivalent public API call, however it
     * can be used with any type of object that supports versioning (currently DATA
     * and CUSTOM).
     * &#64;see TracMetadataApi.updateTagBatch()
     * &#64;see TracMetadataApi.updateTag()
     * </pre>
     */
    public void updateTagBatch(org.finos.tracdap.api.MetadataWriteBatchRequest request,
        io.grpc.stub.StreamObserver<org.finos.tracdap.api.MetadataWriteBatchResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getUpdateTagBatchMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Preallocate an object ID for an object that will be created later.
     * This call is for use by TRAC components that need to reserve an ID before
     * it is used, particularly if the object ID must be included in the definition
     * of an object that has not been created yet. When creating an ID the tenant
     * and object type must be specified, the object that is eventually saved must
     * match these two conditions. Orphan IDs are expected - if a component request
     * an ID and encounters an error before that ID is used, the orphan ID is just
     * ignored.
     * </pre>
     */
    public void preallocateId(org.finos.tracdap.api.MetadataWriteRequest request,
        io.grpc.stub.StreamObserver<org.finos.tracdap.metadata.TagHeader> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getPreallocateIdMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Preallocate object IDs in batch for objects that will be created later.
     * This call is for use by TRAC components that need to reserve an ID before
     * it is used, particularly if the object ID must be included in the definition
     * of an object that has not been created yet. When creating an ID the tenant
     * and object type must be specified, the object that is eventually saved must
     * match these two conditions. Orphan IDs are expected - if a component request
     * an ID and encounters an error before that ID is used, the orphan ID is just
     * ignored.
     * &#64;see TrustedMetadataApi.preallocateId()
     * </pre>
     */
    public void preallocateIdBatch(org.finos.tracdap.api.MetadataWriteBatchRequest request,
        io.grpc.stub.StreamObserver<org.finos.tracdap.api.MetadataWriteBatchResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getPreallocateIdBatchMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Create an object using an ID that was previously preallocated.
     * This call behaves essentially the same as saveNewObject(), with all the
     * same validation. The only difference is that the new definition must be
     * supplied with an object header, including the object ID returned from a
     * prior call to preallocateId().
     * Error conditions include all the error conditions for saveNewObject().
     * Using a preallocated ID twice, attempting to save to an unknown ID or the
     * ID of another object that already exists are also errors.
     * </pre>
     */
    public void createPreallocatedObject(org.finos.tracdap.api.MetadataWriteRequest request,
        io.grpc.stub.StreamObserver<org.finos.tracdap.metadata.TagHeader> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getCreatePreallocatedObjectMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Create objects in batch using IDs that were previously preallocated.
     * This call behaves essentially the same as saveNewObject(), with all the
     * same validation. The only difference is that the new definition must be
     * supplied with an object header, including the object ID returned from a
     * prior call to preallocateId().
     * Error conditions include all the error conditions for saveNewObject().
     * Using a preallocated ID twice, attempting to save to an unknown ID or the
     * ID of another object that already exists are also errors.
     * &#64;see TrustedMetadataApi.createPreallocatedObject()
     * </pre>
     */
    public void createPreallocatedObjectBatch(org.finos.tracdap.api.MetadataWriteBatchRequest request,
        io.grpc.stub.StreamObserver<org.finos.tracdap.api.MetadataWriteBatchResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getCreatePreallocatedObjectBatchMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Read a single object from the TRAC metadata store using a tag selector.
     * This call behaves identically to the equivalent public API call.
     * &#64;see TracMetadataApi.readObject()
     * </pre>
     */
    public void readObject(org.finos.tracdap.api.MetadataReadRequest request,
        io.grpc.stub.StreamObserver<org.finos.tracdap.metadata.Tag> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getReadObjectMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Read multiple objects from the TRAC metadata store using tag selectors.
     * This call behaves identically to the equivalent public API call.
     * &#64;see TracMetadataApi.readBatch()
     * </pre>
     */
    public void readBatch(org.finos.tracdap.api.MetadataBatchRequest request,
        io.grpc.stub.StreamObserver<org.finos.tracdap.api.MetadataBatchResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getReadBatchMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Perform a search against the TRAC metadata store.
     * This call behaves identically to the equivalent public API call.
     * &#64;see TracMetadataApi.search()
     * </pre>
     */
    public void search(org.finos.tracdap.api.MetadataSearchRequest request,
        io.grpc.stub.StreamObserver<org.finos.tracdap.api.MetadataSearchResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getSearchMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * <pre>
   **
   * Trusted API reading, writing and searching for objects in the TRAC metadata store.
   * This API is only available to other components of the TRAC platform, it is
   * not exposed to clients via the platform gateway.
   * Most of the calls in this interface are identical to their public equivalents.
   * Extra calls are available for pre-allocating objects, a facility which is not
   * available to clients of the platform. Restrictions on the creation of certain
   * object types and manipulation of controlled tag attributes are lifted. Methods
   * for performing HTTP GET requests of RESTFUL resources are not duplicated.
   * &#64;see TracMetadataApi
   * </pre>
   */
  public static final class TrustedMetadataApiBlockingStub extends io.grpc.stub.AbstractBlockingStub<TrustedMetadataApiBlockingStub> {
    private TrustedMetadataApiBlockingStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected TrustedMetadataApiBlockingStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new TrustedMetadataApiBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     **
     * Create a new object in the TRAC metadata store.
     * This call behaves identically to the equivalent public API call, without the
     * restriction on which types of object can be saved.
     * &#64;see TracMetadataApi.createObject()
     * </pre>
     */
    public org.finos.tracdap.metadata.TagHeader createObject(org.finos.tracdap.api.MetadataWriteRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getCreateObjectMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Create new objects in the TRAC metadata store.
     * This call behaves identically to the equivalent public API call, without the
     * restriction on which types of object can be saved.
     * &#64;see TracMetadataApi.createObjectBatch()
     * &#64;see TracMetadataApi.createObject()
     * </pre>
     */
    public org.finos.tracdap.api.MetadataWriteBatchResponse createObjectBatch(org.finos.tracdap.api.MetadataWriteBatchRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getCreateObjectBatchMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Update an existing object in the TRAC metadata store.
     * This call behaves identically to the equivalent public API call, however it
     * can be used with any type of object that supports versioning (currently DATA
     * and CUSTOM).
     * &#64;see TracMetadataApi.updateObject()
     * </pre>
     */
    public org.finos.tracdap.metadata.TagHeader updateObject(org.finos.tracdap.api.MetadataWriteRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getUpdateObjectMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Update existing objects in the TRAC metadata store.
     * This call behaves identically to the equivalent public API call, however it
     * can be used with any type of object that supports versioning (currently DATA
     * and CUSTOM).
     * &#64;see TracMetadataApi.updateObjectBatch()
     * &#64;see TracMetadataApi.updateObject()
     * </pre>
     */
    public org.finos.tracdap.api.MetadataWriteBatchResponse updateObjectBatch(org.finos.tracdap.api.MetadataWriteBatchRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getUpdateObjectBatchMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Update the tag for an existing object in the TRAC metadata store.
     * This call behaves identically to the equivalent public API call.
     * &#64;see TracMetadataApi.updateTag()
     * </pre>
     */
    public org.finos.tracdap.metadata.TagHeader updateTag(org.finos.tracdap.api.MetadataWriteRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getUpdateTagMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Update tags for existing objects in the TRAC metadata store.
     * This call behaves identically to the equivalent public API call, however it
     * can be used with any type of object that supports versioning (currently DATA
     * and CUSTOM).
     * &#64;see TracMetadataApi.updateTagBatch()
     * &#64;see TracMetadataApi.updateTag()
     * </pre>
     */
    public org.finos.tracdap.api.MetadataWriteBatchResponse updateTagBatch(org.finos.tracdap.api.MetadataWriteBatchRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getUpdateTagBatchMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Preallocate an object ID for an object that will be created later.
     * This call is for use by TRAC components that need to reserve an ID before
     * it is used, particularly if the object ID must be included in the definition
     * of an object that has not been created yet. When creating an ID the tenant
     * and object type must be specified, the object that is eventually saved must
     * match these two conditions. Orphan IDs are expected - if a component request
     * an ID and encounters an error before that ID is used, the orphan ID is just
     * ignored.
     * </pre>
     */
    public org.finos.tracdap.metadata.TagHeader preallocateId(org.finos.tracdap.api.MetadataWriteRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getPreallocateIdMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Preallocate object IDs in batch for objects that will be created later.
     * This call is for use by TRAC components that need to reserve an ID before
     * it is used, particularly if the object ID must be included in the definition
     * of an object that has not been created yet. When creating an ID the tenant
     * and object type must be specified, the object that is eventually saved must
     * match these two conditions. Orphan IDs are expected - if a component request
     * an ID and encounters an error before that ID is used, the orphan ID is just
     * ignored.
     * &#64;see TrustedMetadataApi.preallocateId()
     * </pre>
     */
    public org.finos.tracdap.api.MetadataWriteBatchResponse preallocateIdBatch(org.finos.tracdap.api.MetadataWriteBatchRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getPreallocateIdBatchMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Create an object using an ID that was previously preallocated.
     * This call behaves essentially the same as saveNewObject(), with all the
     * same validation. The only difference is that the new definition must be
     * supplied with an object header, including the object ID returned from a
     * prior call to preallocateId().
     * Error conditions include all the error conditions for saveNewObject().
     * Using a preallocated ID twice, attempting to save to an unknown ID or the
     * ID of another object that already exists are also errors.
     * </pre>
     */
    public org.finos.tracdap.metadata.TagHeader createPreallocatedObject(org.finos.tracdap.api.MetadataWriteRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getCreatePreallocatedObjectMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Create objects in batch using IDs that were previously preallocated.
     * This call behaves essentially the same as saveNewObject(), with all the
     * same validation. The only difference is that the new definition must be
     * supplied with an object header, including the object ID returned from a
     * prior call to preallocateId().
     * Error conditions include all the error conditions for saveNewObject().
     * Using a preallocated ID twice, attempting to save to an unknown ID or the
     * ID of another object that already exists are also errors.
     * &#64;see TrustedMetadataApi.createPreallocatedObject()
     * </pre>
     */
    public org.finos.tracdap.api.MetadataWriteBatchResponse createPreallocatedObjectBatch(org.finos.tracdap.api.MetadataWriteBatchRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getCreatePreallocatedObjectBatchMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Read a single object from the TRAC metadata store using a tag selector.
     * This call behaves identically to the equivalent public API call.
     * &#64;see TracMetadataApi.readObject()
     * </pre>
     */
    public org.finos.tracdap.metadata.Tag readObject(org.finos.tracdap.api.MetadataReadRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getReadObjectMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Read multiple objects from the TRAC metadata store using tag selectors.
     * This call behaves identically to the equivalent public API call.
     * &#64;see TracMetadataApi.readBatch()
     * </pre>
     */
    public org.finos.tracdap.api.MetadataBatchResponse readBatch(org.finos.tracdap.api.MetadataBatchRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getReadBatchMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Perform a search against the TRAC metadata store.
     * This call behaves identically to the equivalent public API call.
     * &#64;see TracMetadataApi.search()
     * </pre>
     */
    public org.finos.tracdap.api.MetadataSearchResponse search(org.finos.tracdap.api.MetadataSearchRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getSearchMethod(), getCallOptions(), request);
    }
  }

  /**
   * <pre>
   **
   * Trusted API reading, writing and searching for objects in the TRAC metadata store.
   * This API is only available to other components of the TRAC platform, it is
   * not exposed to clients via the platform gateway.
   * Most of the calls in this interface are identical to their public equivalents.
   * Extra calls are available for pre-allocating objects, a facility which is not
   * available to clients of the platform. Restrictions on the creation of certain
   * object types and manipulation of controlled tag attributes are lifted. Methods
   * for performing HTTP GET requests of RESTFUL resources are not duplicated.
   * &#64;see TracMetadataApi
   * </pre>
   */
  public static final class TrustedMetadataApiFutureStub extends io.grpc.stub.AbstractFutureStub<TrustedMetadataApiFutureStub> {
    private TrustedMetadataApiFutureStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected TrustedMetadataApiFutureStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new TrustedMetadataApiFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     **
     * Create a new object in the TRAC metadata store.
     * This call behaves identically to the equivalent public API call, without the
     * restriction on which types of object can be saved.
     * &#64;see TracMetadataApi.createObject()
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<org.finos.tracdap.metadata.TagHeader> createObject(
        org.finos.tracdap.api.MetadataWriteRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getCreateObjectMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * Create new objects in the TRAC metadata store.
     * This call behaves identically to the equivalent public API call, without the
     * restriction on which types of object can be saved.
     * &#64;see TracMetadataApi.createObjectBatch()
     * &#64;see TracMetadataApi.createObject()
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<org.finos.tracdap.api.MetadataWriteBatchResponse> createObjectBatch(
        org.finos.tracdap.api.MetadataWriteBatchRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getCreateObjectBatchMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * Update an existing object in the TRAC metadata store.
     * This call behaves identically to the equivalent public API call, however it
     * can be used with any type of object that supports versioning (currently DATA
     * and CUSTOM).
     * &#64;see TracMetadataApi.updateObject()
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<org.finos.tracdap.metadata.TagHeader> updateObject(
        org.finos.tracdap.api.MetadataWriteRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getUpdateObjectMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * Update existing objects in the TRAC metadata store.
     * This call behaves identically to the equivalent public API call, however it
     * can be used with any type of object that supports versioning (currently DATA
     * and CUSTOM).
     * &#64;see TracMetadataApi.updateObjectBatch()
     * &#64;see TracMetadataApi.updateObject()
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<org.finos.tracdap.api.MetadataWriteBatchResponse> updateObjectBatch(
        org.finos.tracdap.api.MetadataWriteBatchRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getUpdateObjectBatchMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * Update the tag for an existing object in the TRAC metadata store.
     * This call behaves identically to the equivalent public API call.
     * &#64;see TracMetadataApi.updateTag()
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<org.finos.tracdap.metadata.TagHeader> updateTag(
        org.finos.tracdap.api.MetadataWriteRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getUpdateTagMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * Update tags for existing objects in the TRAC metadata store.
     * This call behaves identically to the equivalent public API call, however it
     * can be used with any type of object that supports versioning (currently DATA
     * and CUSTOM).
     * &#64;see TracMetadataApi.updateTagBatch()
     * &#64;see TracMetadataApi.updateTag()
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<org.finos.tracdap.api.MetadataWriteBatchResponse> updateTagBatch(
        org.finos.tracdap.api.MetadataWriteBatchRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getUpdateTagBatchMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * Preallocate an object ID for an object that will be created later.
     * This call is for use by TRAC components that need to reserve an ID before
     * it is used, particularly if the object ID must be included in the definition
     * of an object that has not been created yet. When creating an ID the tenant
     * and object type must be specified, the object that is eventually saved must
     * match these two conditions. Orphan IDs are expected - if a component request
     * an ID and encounters an error before that ID is used, the orphan ID is just
     * ignored.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<org.finos.tracdap.metadata.TagHeader> preallocateId(
        org.finos.tracdap.api.MetadataWriteRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getPreallocateIdMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * Preallocate object IDs in batch for objects that will be created later.
     * This call is for use by TRAC components that need to reserve an ID before
     * it is used, particularly if the object ID must be included in the definition
     * of an object that has not been created yet. When creating an ID the tenant
     * and object type must be specified, the object that is eventually saved must
     * match these two conditions. Orphan IDs are expected - if a component request
     * an ID and encounters an error before that ID is used, the orphan ID is just
     * ignored.
     * &#64;see TrustedMetadataApi.preallocateId()
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<org.finos.tracdap.api.MetadataWriteBatchResponse> preallocateIdBatch(
        org.finos.tracdap.api.MetadataWriteBatchRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getPreallocateIdBatchMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * Create an object using an ID that was previously preallocated.
     * This call behaves essentially the same as saveNewObject(), with all the
     * same validation. The only difference is that the new definition must be
     * supplied with an object header, including the object ID returned from a
     * prior call to preallocateId().
     * Error conditions include all the error conditions for saveNewObject().
     * Using a preallocated ID twice, attempting to save to an unknown ID or the
     * ID of another object that already exists are also errors.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<org.finos.tracdap.metadata.TagHeader> createPreallocatedObject(
        org.finos.tracdap.api.MetadataWriteRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getCreatePreallocatedObjectMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * Create objects in batch using IDs that were previously preallocated.
     * This call behaves essentially the same as saveNewObject(), with all the
     * same validation. The only difference is that the new definition must be
     * supplied with an object header, including the object ID returned from a
     * prior call to preallocateId().
     * Error conditions include all the error conditions for saveNewObject().
     * Using a preallocated ID twice, attempting to save to an unknown ID or the
     * ID of another object that already exists are also errors.
     * &#64;see TrustedMetadataApi.createPreallocatedObject()
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<org.finos.tracdap.api.MetadataWriteBatchResponse> createPreallocatedObjectBatch(
        org.finos.tracdap.api.MetadataWriteBatchRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getCreatePreallocatedObjectBatchMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * Read a single object from the TRAC metadata store using a tag selector.
     * This call behaves identically to the equivalent public API call.
     * &#64;see TracMetadataApi.readObject()
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<org.finos.tracdap.metadata.Tag> readObject(
        org.finos.tracdap.api.MetadataReadRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getReadObjectMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * Read multiple objects from the TRAC metadata store using tag selectors.
     * This call behaves identically to the equivalent public API call.
     * &#64;see TracMetadataApi.readBatch()
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<org.finos.tracdap.api.MetadataBatchResponse> readBatch(
        org.finos.tracdap.api.MetadataBatchRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getReadBatchMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * Perform a search against the TRAC metadata store.
     * This call behaves identically to the equivalent public API call.
     * &#64;see TracMetadataApi.search()
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<org.finos.tracdap.api.MetadataSearchResponse> search(
        org.finos.tracdap.api.MetadataSearchRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getSearchMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_CREATE_OBJECT = 0;
  private static final int METHODID_CREATE_OBJECT_BATCH = 1;
  private static final int METHODID_UPDATE_OBJECT = 2;
  private static final int METHODID_UPDATE_OBJECT_BATCH = 3;
  private static final int METHODID_UPDATE_TAG = 4;
  private static final int METHODID_UPDATE_TAG_BATCH = 5;
  private static final int METHODID_PREALLOCATE_ID = 6;
  private static final int METHODID_PREALLOCATE_ID_BATCH = 7;
  private static final int METHODID_CREATE_PREALLOCATED_OBJECT = 8;
  private static final int METHODID_CREATE_PREALLOCATED_OBJECT_BATCH = 9;
  private static final int METHODID_READ_OBJECT = 10;
  private static final int METHODID_READ_BATCH = 11;
  private static final int METHODID_SEARCH = 12;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final TrustedMetadataApiImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(TrustedMetadataApiImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_CREATE_OBJECT:
          serviceImpl.createObject((org.finos.tracdap.api.MetadataWriteRequest) request,
              (io.grpc.stub.StreamObserver<org.finos.tracdap.metadata.TagHeader>) responseObserver);
          break;
        case METHODID_CREATE_OBJECT_BATCH:
          serviceImpl.createObjectBatch((org.finos.tracdap.api.MetadataWriteBatchRequest) request,
              (io.grpc.stub.StreamObserver<org.finos.tracdap.api.MetadataWriteBatchResponse>) responseObserver);
          break;
        case METHODID_UPDATE_OBJECT:
          serviceImpl.updateObject((org.finos.tracdap.api.MetadataWriteRequest) request,
              (io.grpc.stub.StreamObserver<org.finos.tracdap.metadata.TagHeader>) responseObserver);
          break;
        case METHODID_UPDATE_OBJECT_BATCH:
          serviceImpl.updateObjectBatch((org.finos.tracdap.api.MetadataWriteBatchRequest) request,
              (io.grpc.stub.StreamObserver<org.finos.tracdap.api.MetadataWriteBatchResponse>) responseObserver);
          break;
        case METHODID_UPDATE_TAG:
          serviceImpl.updateTag((org.finos.tracdap.api.MetadataWriteRequest) request,
              (io.grpc.stub.StreamObserver<org.finos.tracdap.metadata.TagHeader>) responseObserver);
          break;
        case METHODID_UPDATE_TAG_BATCH:
          serviceImpl.updateTagBatch((org.finos.tracdap.api.MetadataWriteBatchRequest) request,
              (io.grpc.stub.StreamObserver<org.finos.tracdap.api.MetadataWriteBatchResponse>) responseObserver);
          break;
        case METHODID_PREALLOCATE_ID:
          serviceImpl.preallocateId((org.finos.tracdap.api.MetadataWriteRequest) request,
              (io.grpc.stub.StreamObserver<org.finos.tracdap.metadata.TagHeader>) responseObserver);
          break;
        case METHODID_PREALLOCATE_ID_BATCH:
          serviceImpl.preallocateIdBatch((org.finos.tracdap.api.MetadataWriteBatchRequest) request,
              (io.grpc.stub.StreamObserver<org.finos.tracdap.api.MetadataWriteBatchResponse>) responseObserver);
          break;
        case METHODID_CREATE_PREALLOCATED_OBJECT:
          serviceImpl.createPreallocatedObject((org.finos.tracdap.api.MetadataWriteRequest) request,
              (io.grpc.stub.StreamObserver<org.finos.tracdap.metadata.TagHeader>) responseObserver);
          break;
        case METHODID_CREATE_PREALLOCATED_OBJECT_BATCH:
          serviceImpl.createPreallocatedObjectBatch((org.finos.tracdap.api.MetadataWriteBatchRequest) request,
              (io.grpc.stub.StreamObserver<org.finos.tracdap.api.MetadataWriteBatchResponse>) responseObserver);
          break;
        case METHODID_READ_OBJECT:
          serviceImpl.readObject((org.finos.tracdap.api.MetadataReadRequest) request,
              (io.grpc.stub.StreamObserver<org.finos.tracdap.metadata.Tag>) responseObserver);
          break;
        case METHODID_READ_BATCH:
          serviceImpl.readBatch((org.finos.tracdap.api.MetadataBatchRequest) request,
              (io.grpc.stub.StreamObserver<org.finos.tracdap.api.MetadataBatchResponse>) responseObserver);
          break;
        case METHODID_SEARCH:
          serviceImpl.search((org.finos.tracdap.api.MetadataSearchRequest) request,
              (io.grpc.stub.StreamObserver<org.finos.tracdap.api.MetadataSearchResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class TrustedMetadataApiBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    TrustedMetadataApiBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return org.finos.tracdap.api.MetadataTrusted.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("TrustedMetadataApi");
    }
  }

  private static final class TrustedMetadataApiFileDescriptorSupplier
      extends TrustedMetadataApiBaseDescriptorSupplier {
    TrustedMetadataApiFileDescriptorSupplier() {}
  }

  private static final class TrustedMetadataApiMethodDescriptorSupplier
      extends TrustedMetadataApiBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    TrustedMetadataApiMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (TrustedMetadataApiGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new TrustedMetadataApiFileDescriptorSupplier())
              .addMethod(getCreateObjectMethod())
              .addMethod(getCreateObjectBatchMethod())
              .addMethod(getUpdateObjectMethod())
              .addMethod(getUpdateObjectBatchMethod())
              .addMethod(getUpdateTagMethod())
              .addMethod(getUpdateTagBatchMethod())
              .addMethod(getPreallocateIdMethod())
              .addMethod(getPreallocateIdBatchMethod())
              .addMethod(getCreatePreallocatedObjectMethod())
              .addMethod(getCreatePreallocatedObjectBatchMethod())
              .addMethod(getReadObjectMethod())
              .addMethod(getReadBatchMethod())
              .addMethod(getSearchMethod())
              .build();
        }
      }
    }
    return result;
  }
}
