/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.concurrent;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.Context;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.ServerCallExecutorSupplier;
import io.netty.util.concurrent.OrderedEventExecutor;
import java.util.concurrent.Executor;
import org.finos.tracdap.common.concurrent.IExecutionContext;

public class ExecutionContext
implements IExecutionContext {
    public static final Context.Key<IExecutionContext> EXEC_CONTEXT_KEY = Context.key((String)"TRAC_EXEC_CONTEXT");
    private final OrderedEventExecutor eventLoopExecutor;

    public ExecutionContext(OrderedEventExecutor eventLoopExecutor) {
        this.eventLoopExecutor = eventLoopExecutor;
    }

    @Override
    public OrderedEventExecutor eventLoopExecutor() {
        return this.eventLoopExecutor;
    }

    public ServerCallExecutorSupplier eventLoopServerCall() {
        return new ServerCallExecutorSupplier(){

            public <ReqT, RespT> Executor getExecutor(ServerCall<ReqT, RespT> call, Metadata metadata) {
                return ExecutionContext.this.eventLoopExecutor;
            }
        };
    }

    public ClientInterceptor eventLoopClientCall() {
        return new ClientInterceptor(){

            public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
                CallOptions options = callOptions.withExecutor((Executor)ExecutionContext.this.eventLoopExecutor);
                return next.newCall(method, options);
            }
        };
    }
}

