/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.concurrent;

import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.OrderedEventExecutor;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.finos.tracdap.common.concurrent.ExecutionContext;
import org.finos.tracdap.common.concurrent.IExecutionContext;
import org.finos.tracdap.common.exception.ETracInternal;

public class ExecutionRegister {
    private final EventExecutorGroup executorGroup;
    private final ConcurrentMap<String, OrderedEventExecutor> executors;

    public ExecutionRegister(EventExecutorGroup executorGroup) {
        this.executorGroup = executorGroup;
        this.executors = new ConcurrentHashMap<String, OrderedEventExecutor>();
    }

    public ServerInterceptor registerExecContext() {
        return new RegisterContextInterceptor();
    }

    private IExecutionContext execContextForThread() {
        String eventLoopKey = Thread.currentThread().getName();
        OrderedEventExecutor executor = (OrderedEventExecutor)this.executors.get(eventLoopKey);
        if (executor == null) {
            executor = this.registerEventLoopKey(eventLoopKey);
        }
        return new ExecutionContext(executor);
    }

    private OrderedEventExecutor registerEventLoopKey(String eventLoopKey) {
        for (EventExecutor eventExec : this.executorGroup) {
            if (!eventExec.inEventLoop() || !(eventExec instanceof OrderedEventExecutor)) continue;
            this.executors.putIfAbsent(eventLoopKey, (OrderedEventExecutor)eventExec);
            return (OrderedEventExecutor)eventExec;
        }
        throw new ETracInternal("Netty event loop manager is running outside of the worker event loop group");
    }

    private class RegisterContextInterceptor
    implements ServerInterceptor {
        private RegisterContextInterceptor() {
        }

        public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
            IExecutionContext execCtx = ExecutionRegister.this.execContextForThread();
            Context grpcCtx = Context.current().withValue(ExecutionContext.EXEC_CONTEXT_KEY, (Object)execCtx);
            return Contexts.interceptCall((Context)grpcCtx, call, (Metadata)headers, next);
        }
    }
}

