/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.concurrent;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.netty.util.concurrent.Future;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;

public class Futures {
    public static <T> CompletionStage<T> javaFuture(ListenableFuture<T> guavaFuture) {
        final CompletableFuture javaFuture = new CompletableFuture();
        com.google.common.util.concurrent.Futures.addCallback(guavaFuture, (FutureCallback)new FutureCallback<T>(){

            public void onSuccess(T result) {
                javaFuture.complete(result);
            }

            public void onFailure(Throwable error) {
                javaFuture.completeExceptionally(error);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return javaFuture;
    }

    public static <T> CompletionStage<T> javaFuture(Future<T> nettyFuture) {
        CompletableFuture javaFuture = new CompletableFuture();
        nettyFuture.addListener(f -> {
            if (f.isSuccess()) {
                javaFuture.complete(f.getNow());
            } else {
                javaFuture.completeExceptionally(f.cause());
            }
        });
        return javaFuture;
    }
}

