/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.concurrent.flow;

import java.util.concurrent.Flow;
import java.util.function.BiConsumer;

public class InterceptProcessor<T>
implements Flow.Processor<T, T> {
    Flow.Subscriber<? super T> target;
    Flow.Subscription subscription;
    private final BiConsumer<T, Throwable> resultInterceptor;

    public InterceptProcessor(BiConsumer<T, Throwable> resultInterceptor) {
        this.resultInterceptor = resultInterceptor;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        if (this.target != null) {
            throw new IllegalStateException("Multiple target subscriptions for intercept processor");
        }
        this.target = subscriber;
        if (this.subscription != null) {
            this.target.onSubscribe(this.subscription);
        }
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        if (this.subscription != null) {
            throw new IllegalStateException("Multiple source subscriptions for intercept processor");
        }
        this.subscription = subscription;
        if (this.target != null) {
            this.target.onSubscribe(subscription);
        }
    }

    @Override
    public void onNext(T item) {
        this.target.onNext(item);
    }

    @Override
    public void onError(Throwable error) {
        if (this.resultInterceptor != null) {
            this.resultInterceptor.accept(null, error);
        }
        this.target.onError(error);
    }

    @Override
    public void onComplete() {
        if (this.resultInterceptor != null) {
            this.resultInterceptor.accept(null, null);
        }
        this.target.onComplete();
    }
}

