/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.concurrent.flow;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Flow;
import java.util.function.BiFunction;
import java.util.function.Function;

public class ReduceProcessor<T, U>
implements Flow.Subscriber<T> {
    private final BiFunction<U, T, U> func;
    private final CompletableFuture<U> result;
    private Flow.Subscription subscription;
    private Function<T, U> initFunc;
    private U acc;

    public ReduceProcessor(BiFunction<U, T, U> func, CompletableFuture<U> result, U acc) {
        this.func = func;
        this.result = result;
        this.initFunc = null;
        this.acc = acc;
    }

    public ReduceProcessor(BiFunction<U, T, U> func, CompletableFuture<U> result, Function<T, U> initFunc) {
        this.func = func;
        this.result = result;
        this.initFunc = initFunc;
        this.acc = null;
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        this.subscription = subscription;
        subscription.request(1L);
    }

    @Override
    public void onNext(T x) {
        if (this.initFunc != null) {
            this.acc = this.initFunc.apply(x);
            this.initFunc = null;
        } else {
            this.acc = this.func.apply(this.acc, x);
        }
        this.subscription.request(1L);
    }

    @Override
    public void onError(Throwable error) {
        Throwable completionError = error instanceof CompletionException ? error : new CompletionException(error.getMessage(), error);
        this.result.completeExceptionally(completionError);
    }

    @Override
    public void onComplete() {
        this.result.complete(this.acc);
    }
}

