/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.config;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import org.finos.tracdap.common.config.ConfigFormat;
import org.finos.tracdap.common.exception.EStartup;
import org.finos.tracdap.common.exception.EUnexpected;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.error.MarkedYAMLException;
import org.yaml.snakeyaml.error.YAMLException;

public class ConfigParser {
    private static final Logger log = LoggerFactory.getLogger(ConfigParser.class);

    public static <TConfig extends Message, B extends Message.Builder> TConfig parseConfig(ByteBuf configData, ConfigFormat configFormat, Class<TConfig> configClass) {
        try {
            Method newBuilder = configClass.getMethod("newBuilder", new Class[0]);
            Message.Builder builder = (Message.Builder)newBuilder.invoke(null, new Object[0]);
            Message blankConfig = builder.build();
            switch (configFormat) {
                case PROTO: {
                    Message message = ConfigParser.parseProtoConfig(configData, blankConfig);
                    return (TConfig)message;
                }
                case JSON: {
                    Message message = ConfigParser.parseJsonConfig(configData, blankConfig);
                    return (TConfig)message;
                }
                case YAML: {
                    Message message = ConfigParser.parseYamlConfig(configData, blankConfig);
                    return (TConfig)message;
                }
            }
            try {
                throw new EStartup(String.format("Unknown config format [%s]", new Object[]{configFormat}));
            }
            catch (InvalidProtocolBufferException e) {
                throw new EStartup("Invalid config: " + e.getMessage(), e);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new EUnexpected();
            }
        }
        finally {
            configData.release();
        }
    }

    private static <TConfig extends Message> TConfig parseProtoConfig(ByteBuf configData, TConfig defaultConfig) throws InvalidProtocolBufferException {
        return (TConfig)defaultConfig.toBuilder().mergeFrom(configData.array()).build();
    }

    private static <TConfig extends Message> TConfig parseJsonConfig(ByteBuf configData, TConfig defaultConfig) throws InvalidProtocolBufferException {
        String json = configData.getCharSequence(0, configData.readableBytes(), StandardCharsets.UTF_8).toString();
        JsonFormat.Parser parser = JsonFormat.parser();
        Message.Builder builder = defaultConfig.toBuilder();
        parser.merge(json, builder);
        return (TConfig)builder.build();
    }

    private static <TConfig extends Message> TConfig parseYamlConfig(ByteBuf configData, TConfig defaultConfig) throws InvalidProtocolBufferException {
        ByteBuf json = Unpooled.EMPTY_BUFFER;
        try {
            TConfig TConfig;
            block12: {
                ByteBufInputStream stream = new ByteBufInputStream(configData);
                try {
                    YAMLFactory yamlFactory = new YAMLFactory();
                    JsonFactory jsonFactory = new JsonFactory();
                    YAMLMapper reader = new YAMLMapper(yamlFactory);
                    JsonMapper writer = new JsonMapper(jsonFactory);
                    Object obj = reader.readValue((InputStream)stream, Object.class);
                    byte[] jsonBytes = writer.writeValueAsBytes(obj);
                    json = Unpooled.wrappedBuffer((byte[])jsonBytes);
                    TConfig = ConfigParser.parseJsonConfig(json, defaultConfig);
                    if (stream == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new EStartup(e.getMessage(), e);
                    }
                }
                stream.close();
            }
            return TConfig;
        }
        finally {
            if (json != Unpooled.EMPTY_BUFFER) {
                json.release();
            }
        }
    }

    static <TConfig> TConfig parseStructuredConfig(String configData, ConfigFormat configFormat, Class<TConfig> elementClass) throws EStartup {
        switch (configFormat) {
            case YAML: {
                return ConfigParser.parseYamlConfig_(configData, elementClass);
            }
        }
        throw new EStartup(String.format("Unsupported config format '%s'", new Object[]{configFormat}));
    }

    static <TConfig> TConfig parseYamlConfig_(String configData, Class<TConfig> elementClass) throws EStartup {
        try {
            LoaderOptions loaderOptions = new LoaderOptions();
            loaderOptions.setEnumCaseSensitive(false);
            Constructor constructor = new Constructor(elementClass, loaderOptions);
            Yaml yaml = new Yaml((BaseConstructor)constructor);
            return (TConfig)yaml.loadAs(configData, elementClass);
        }
        catch (MarkedYAMLException e) {
            log.error("YAML Error", (Throwable)e);
            throw new EStartup("YAML error", e);
        }
        catch (YAMLException e) {
            throw new EStartup("There was an unexpected problem parsing YAML config: " + e.getMessage(), e);
        }
    }
}

