/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.config.local;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.finos.tracdap.common.config.IConfigLoader;
import org.finos.tracdap.common.exception.EStartup;
import org.finos.tracdap.common.exception.ETracInternal;

public class LocalConfigLoader
implements IConfigLoader {
    @Override
    public String loaderName() {
        return "FILESYSTEM";
    }

    @Override
    public List<String> protocols() {
        return List.of("file");
    }

    @Override
    public String loadTextFile(URI uri) {
        String ERROR_MSG_TEMPLATE = "Failed to load config file: %2$s [%1$s]";
        Path path = null;
        try {
            path = Paths.get(uri);
            return Files.readString(path, StandardCharsets.UTF_8);
        }
        catch (IllegalArgumentException e) {
            String message = String.format("URL is not a file path: [%s]", uri);
            throw new ETracInternal(message, e);
        }
        catch (NoSuchFileException e) {
            String message = String.format(ERROR_MSG_TEMPLATE, path, "File does not exist");
            throw new EStartup(message, e);
        }
        catch (AccessDeniedException e) {
            String message = String.format(ERROR_MSG_TEMPLATE, path, "Access denied");
            throw new EStartup(message, e);
        }
        catch (IOException e) {
            String message = String.format(ERROR_MSG_TEMPLATE, path, e.getMessage());
            throw new EStartup(message, e);
        }
    }
}

