/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.grpc;

import com.google.common.util.concurrent.ListenableFuture;
import io.grpc.MethodDescriptor;
import io.grpc.StatusRuntimeException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.finos.tracdap.common.concurrent.Futures;
import org.finos.tracdap.common.grpc.GrpcErrorMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcClientWrap {
    private final Logger log;

    public GrpcClientWrap(Class<?> serviceClass) {
        this.log = LoggerFactory.getLogger(serviceClass);
    }

    public <TRequest, TResponse> CompletionStage<TResponse> unaryCall(MethodDescriptor<TRequest, TResponse> method, TRequest request, Function<TRequest, ListenableFuture<TResponse>> methodImpl) {
        try {
            this.log.info("CLIENT CALL START: [{}]", (Object)this.methodDisplayName(method));
            return Futures.javaFuture(methodImpl.apply(request)).handle((result, error) -> this.handleResult(method, (Object)result, (Throwable)error));
        }
        catch (Exception error2) {
            StatusRuntimeException grpcError = GrpcErrorMapping.processError(error2);
            this.log.error("CLIENT CALL FAILED: [{}] {}", new Object[]{this.methodDisplayName(method), grpcError.getMessage(), grpcError});
            return CompletableFuture.failedFuture((Throwable)grpcError);
        }
    }

    private <TResponse> TResponse handleResult(MethodDescriptor<?, ?> method, TResponse result, Throwable error) {
        if (error == null) {
            this.log.info("CLIENT CALL SUCCEEDED: [{}]", (Object)this.methodDisplayName(method));
            return result;
        }
        StatusRuntimeException grpcError = GrpcErrorMapping.processError(error);
        this.log.error("CLIENT CALL FAILED: [{}] {}", new Object[]{this.methodDisplayName(method), grpcError.getMessage(), grpcError});
        throw grpcError;
    }

    private String methodDisplayName(MethodDescriptor<?, ?> method) {
        String serviceName = method.getServiceName();
        String shortServiceName = serviceName == null ? null : serviceName.substring(serviceName.lastIndexOf(".") + 1);
        String methodName = method.getBareMethodName();
        return String.format("%s.%s()", shortServiceName, methodName);
    }
}

