/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.grpc;

import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.Flow;
import org.finos.tracdap.common.exception.ETracInternal;
import org.finos.tracdap.common.grpc.GrpcErrorMapping;

public class GrpcServerResponseStream<TResponse>
implements Flow.Subscriber<TResponse> {
    private final StreamObserver<TResponse> grpcObserver;
    private Flow.Subscription subscription;

    public GrpcServerResponseStream(StreamObserver<TResponse> grpcObserver) {
        this.grpcObserver = grpcObserver;
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        if (this.subscription != null) {
            throw new ETracInternal("Multiple subscriptions on gRPC observer wrapper");
        }
        this.subscription = subscription;
        subscription.request(1L);
    }

    @Override
    public void onNext(TResponse item) {
        this.grpcObserver.onNext(item);
        this.subscription.request(1L);
    }

    @Override
    public void onError(Throwable error) {
        StatusRuntimeException grpcError = GrpcErrorMapping.processError(error);
        this.grpcObserver.onError((Throwable)grpcError);
        this.subscription.cancel();
    }

    @Override
    public void onComplete() {
        this.grpcObserver.onCompleted();
    }
}

