/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.plugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.finos.tracdap.common.config.IConfigLoader;
import org.finos.tracdap.common.exception.EPluginNotAvailable;
import org.finos.tracdap.common.exception.EUnexpected;
import org.finos.tracdap.common.plugin.IPluginManager;
import org.finos.tracdap.common.plugin.ITracPlugin;
import org.finos.tracdap.common.plugin.PluginKey;
import org.finos.tracdap.common.plugin.PluginServiceInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginManager
implements IPluginManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<PluginKey, ITracPlugin> plugins = new HashMap<PluginKey, ITracPlugin>();

    public void initConfigPlugins() {
        this.log.info("Loading config plugins...");
        ServiceLoader<ITracPlugin> availablePlugins = ServiceLoader.load(ITracPlugin.class);
        for (ITracPlugin plugin : availablePlugins) {
            List<PluginServiceInfo> services = plugin.serviceInfo();
            List<PluginServiceInfo> configServices = services.stream().filter(si -> si.serviceClass() == IConfigLoader.class).collect(Collectors.toList());
            if (configServices.isEmpty()) continue;
            this.log.info("Plugin: [{}]", (Object)plugin.pluginName());
            this.registerServices(plugin, configServices);
        }
    }

    public void initRegularPlugins() {
        this.log.info("Loading plugins...");
        ServiceLoader<ITracPlugin> availablePlugins = ServiceLoader.load(ITracPlugin.class);
        for (ITracPlugin plugin : availablePlugins) {
            List<PluginServiceInfo> services = plugin.serviceInfo();
            List<PluginServiceInfo> regularServices = services.stream().filter(si -> si.serviceClass() != IConfigLoader.class).collect(Collectors.toList());
            if (regularServices.isEmpty()) continue;
            this.log.info("Plugin: [{}]", (Object)plugin.pluginName());
            this.registerServices(plugin, regularServices);
        }
    }

    private void registerServices(ITracPlugin plugin, List<PluginServiceInfo> services) {
        for (PluginServiceInfo service : services) {
            String prettyServiceType = this.prettyTypeName(service.serviceTypeName(), true);
            String protocols = String.join((CharSequence)", ", service.protocols());
            this.log.info(" |-> {}: [{}] (protocols: {})", new Object[]{prettyServiceType, service.serviceName(), protocols});
            for (String protocol : service.protocols()) {
                PluginKey pluginKey = new PluginKey(service.serviceClass(), protocol);
                this.plugins.put(pluginKey, plugin);
            }
        }
    }

    @Override
    public List<String> availableProtocols(Class<?> serviceClass) {
        HashSet<String> protocols = new HashSet<String>();
        for (PluginKey pluginKey : this.plugins.keySet()) {
            if (pluginKey.serviceClass() != serviceClass) continue;
            protocols.add(pluginKey.protocol());
        }
        return new ArrayList<String>(protocols);
    }

    @Override
    public boolean isServiceAvailable(Class<?> serviceClass, String protocol) {
        PluginKey pluginKey = new PluginKey(serviceClass, protocol);
        return this.plugins.containsKey(pluginKey);
    }

    @Override
    public <T> T createService(Class<T> serviceClass, String protocol) {
        return this.createService(serviceClass, protocol, new Properties());
    }

    @Override
    public <T> T createService(Class<T> serviceClass, String protocol, Properties properties) {
        PluginKey pluginKey = new PluginKey(serviceClass, protocol);
        if (!PluginServiceInfo.SERVICE_NAMES.containsKey(serviceClass.getName())) {
            throw new EUnexpected();
        }
        if (!this.plugins.containsKey(pluginKey)) {
            String rawTypeName = PluginServiceInfo.SERVICE_NAMES.get(serviceClass.getName());
            String message = String.format("Plugin not available for %s protocol: [%s]", this.prettyTypeName(rawTypeName, false), protocol);
            this.log.error(message);
            throw new EPluginNotAvailable(message);
        }
        ITracPlugin plugin = this.plugins.get(pluginKey);
        return plugin.createService(serviceClass, protocol, properties);
    }

    private String prettyTypeName(String rawTypeName, boolean caps) {
        String caseAndSpaces = rawTypeName.toLowerCase().replace("_", " ").replace("-", " ");
        if (caps) {
            String firstLetter = caseAndSpaces.substring(0, 1).toUpperCase();
            return firstLetter + caseAndSpaces.substring(1);
        }
        return caseAndSpaces;
    }
}

