/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.plugin;

import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.finos.tracdap.common.exception.ETracInternal;

public class PluginServiceInfo {
    static final Map<String, String> SERVICE_NAMES = Map.ofEntries(Map.entry("org.finos.tracdap.common.config.IConfigLoader", "CONFIG"), Map.entry("org.finos.tracdap.common.codec.ICodec", "FORMAT"), Map.entry("org.finos.tracdap.common.storage.IFileStorage", "FILE_STORAGE"), Map.entry("org.finos.tracdap.common.storage.IDataStorage", "DATA_STORAGE"), Map.entry("org.finos.tracdap.common.exec.IBatchExecutor", "BATCH_EXECUTOR"));
    private final String pluginName;
    private final Class<?> serviceClass;
    private final String serviceTypeName;
    private final String serviceName;
    private final List<String> protocols;

    public PluginServiceInfo(@Nonnull String pluginName, @Nonnull Class<?> serviceClass, @Nonnull String serviceName, @Nonnull List<String> protocols) {
        this.pluginName = pluginName;
        this.serviceClass = serviceClass;
        this.serviceName = serviceName;
        this.protocols = protocols;
        this.serviceTypeName = SERVICE_NAMES.getOrDefault(serviceClass.getName(), null);
        if (this.serviceTypeName == null) {
            throw new ETracInternal("Service class is not a recognized pluggable service class");
        }
    }

    public String pluginName() {
        return this.pluginName;
    }

    public Class<?> serviceClass() {
        return this.serviceClass;
    }

    public String serviceTypeName() {
        return this.serviceTypeName;
    }

    public String serviceName() {
        return this.serviceName;
    }

    public List<String> protocols() {
        return this.protocols;
    }
}

