/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.startup;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Configurator;
import org.finos.tracdap.common.config.ConfigManager;
import org.finos.tracdap.common.exception.EStartup;
import org.finos.tracdap.common.exception.ETracInternal;
import org.finos.tracdap.common.exception.EUnexpected;
import org.finos.tracdap.common.plugin.PluginManager;
import org.finos.tracdap.common.startup.StandardArgs;
import org.finos.tracdap.common.startup.Startup;
import org.finos.tracdap.common.util.VersionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartupSequence {
    private static final String STARTUP_LOG_CONFIG = "/log4j2_startup.xml";
    private final Class<?> serviceClass;
    private final StandardArgs standardArgs;
    private final boolean doPrintBanner;
    private boolean sequenceComplete = false;
    private PluginManager plugins;
    private ConfigManager config;

    public StartupSequence(Class<?> serviceClass, StandardArgs standardArgs) {
        this(serviceClass, standardArgs, true);
    }

    StartupSequence(Class<?> serviceClass, StandardArgs standardArgs, boolean doPrintBanner) {
        this.serviceClass = serviceClass;
        this.standardArgs = standardArgs;
        this.doPrintBanner = doPrintBanner;
    }

    public void runStartupSequence() {
        if (this.doPrintBanner) {
            StartupSequence.printBanner(this.serviceClass);
        }
        this.printSubBanner();
        this.initStartupLogging();
        this.initConfigPlugins();
        this.loadConfig();
        this.initLogging();
        this.sequenceComplete = true;
    }

    public PluginManager getPlugins() {
        if (!this.sequenceComplete) {
            throw new ETracInternal("Startup sequence has not been run");
        }
        return this.plugins;
    }

    public ConfigManager getConfig() {
        if (!this.sequenceComplete) {
            throw new ETracInternal("Startup sequence has not been run");
        }
        return this.config;
    }

    public List<StandardArgs.Task> getTasks() {
        return this.standardArgs.getTasks();
    }

    public static void printBanner(Class<?> serviceClass) {
        String componentName = VersionInfo.getComponentName(serviceClass);
        String componentVersion = VersionInfo.getComponentVersion(serviceClass);
        String startupBanner = String.format(">>> %s %s", componentName, componentVersion);
        System.out.println(startupBanner);
    }

    private void printSubBanner() {
        System.out.println(">>> Working directory: " + this.standardArgs.getWorkingDir());
        System.out.println(">>> Config file: " + this.standardArgs.getConfigFile());
        System.out.println();
    }

    private void initStartupLogging() {
        try (InputStream logConfig = Startup.class.getResourceAsStream(STARTUP_LOG_CONFIG);){
            if (logConfig == null) {
                throw new EStartup("Failed to load logging config for bootstrap");
            }
            ConfigurationSource configSource = new ConfigurationSource(logConfig);
            Configurator.initialize((ClassLoader)Startup.class.getClassLoader(), (ConfigurationSource)configSource);
        }
        catch (IOException e) {
            throw new EStartup("Failed to load logging config for startup sequence (this is a bug)");
        }
    }

    public void initConfigPlugins() {
        this.plugins = new PluginManager();
        this.plugins.initConfigPlugins();
    }

    private void loadConfig() {
        String configFile = this.standardArgs.getConfigFile();
        Path workingDir = this.standardArgs.getWorkingDir();
        this.config = new ConfigManager(configFile, workingDir, this.plugins);
    }

    public void initLogging() {
        Logger log;
        block8: {
            log = LoggerFactory.getLogger(this.getClass());
            Map rootConfigMap = this.config.loadRootConfigObject(Map.class);
            String loggingConfigUrl = this.lookupLoggingConfigUrl(rootConfigMap);
            if (loggingConfigUrl != null && !loggingConfigUrl.isBlank()) {
                String loggingConfig = this.config.loadConfigFile(loggingConfigUrl);
                try (ByteArrayInputStream configStream = new ByteArrayInputStream(loggingConfig.getBytes());){
                    ConfigurationSource configSource = new ConfigurationSource((InputStream)configStream);
                    Configurator.initialize((ClassLoader)this.getClass().getClassLoader(), (ConfigurationSource)configSource);
                    break block8;
                }
                catch (IOException e) {
                    throw new EUnexpected(e);
                }
            }
            log.info("Using default logging config");
        }
        log.info("Initialize logging...");
        Configurator.reconfigure();
    }

    private String lookupLoggingConfigUrl(Map<?, ?> rootConfigMap) {
        if (!rootConfigMap.containsKey("config")) {
            return null;
        }
        Object externalConfig = rootConfigMap.get("config");
        if (!(externalConfig instanceof Map)) {
            return null;
        }
        Map externalConfigMap = (Map)externalConfig;
        if (!externalConfigMap.containsKey("logging")) {
            return null;
        }
        Object loggingConfig = externalConfigMap.get("logging");
        if (loggingConfig == null) {
            return null;
        }
        return loggingConfig.toString();
    }
}

