/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.util;

import com.google.protobuf.ByteString;
import com.google.protobuf.UnsafeByteOperations;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Optional;
import org.finos.tracdap.common.exception.EUnexpected;

public class Bytes {
    public static ByteBuf fromProtoBytes(ByteString bs) {
        return Unpooled.wrappedBuffer((ByteBuffer)bs.asReadOnlyByteBuffer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteString toProtoBytes(ByteBuf buf) {
        try {
            if (buf.nioBufferCount() == 1) {
                ByteBuffer nioBuffer = buf.nioBuffer();
                ByteString byteString = ByteString.copyFrom((ByteBuffer)nioBuffer);
                return byteString;
            }
            if (buf.nioBufferCount() > 1) {
                ByteBuffer[] nioBuffers = buf.nioBuffers();
                Optional<ByteString> byteStream = Arrays.stream(nioBuffers).map(ByteString::copyFrom).reduce(ByteString::concat);
                if (byteStream.isEmpty()) {
                    throw new EUnexpected();
                }
                ByteString byteString = byteStream.get();
                return byteString;
            }
            if (buf.hasArray()) {
                ByteString nioBuffers = UnsafeByteOperations.unsafeWrap((byte[])buf.array());
                return nioBuffers;
            }
            byte[] bufCopy = new byte[buf.readableBytes()];
            buf.readBytes(bufCopy);
            ByteString byteString = UnsafeByteOperations.unsafeWrap((byte[])bufCopy);
            return byteString;
        }
        finally {
            buf.release();
        }
    }
}

