/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.util;

import com.google.protobuf.Message;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import org.finos.tracdap.metadata.TagHeader;
import org.finos.tracdap.metadata.TagSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterfaceLogging
implements InvocationHandler {
    private static final Set<Class<?>> LOGGABLE_METADATA_TYPES = Set.of(TagSelector.class, TagHeader.class);
    private final Object impl;
    private final Logger log;

    public static <I, T extends I> I wrap(T impl, Class<I> iface) {
        Logger logger = LoggerFactory.getLogger(impl.getClass());
        InterfaceLogging handler = new InterfaceLogging(impl, logger);
        Object proxy = Proxy.newProxyInstance(impl.getClass().getClassLoader(), new Class[]{iface}, (InvocationHandler)handler);
        return (I)proxy;
    }

    private InterfaceLogging(Object impl, Logger log) {
        this.impl = impl;
        this.log = log;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Parameter[] params = method.getParameters();
        CharSequence[] paramInfo = new String[params.length];
        for (int paramIndex = 0; paramIndex < params.length; ++paramIndex) {
            paramInfo[paramIndex] = params[paramIndex].getName() + " = " + this.argToString(args[paramIndex]);
        }
        try {
            this.log.info("START: {} {}", (Object)method.getName(), (Object)String.join((CharSequence)", ", paramInfo));
            Object result = method.invoke(this.impl, args);
            if (CompletionStage.class.isAssignableFrom(method.getReturnType())) {
                return this.applyAsyncLogging(method, (CompletionStage)result);
            }
            this.log.info("SUCCEEDED: {}", (Object)method.getName());
            return result;
        }
        catch (InvocationTargetException e) {
            this.log.error("FAILED: {} {}", new Object[]{method.getName(), e.getTargetException().getMessage(), e.getTargetException()});
            throw e.getTargetException();
        }
        catch (Throwable e) {
            this.log.error("FAILED: {} Unexpected error logging method status ({})", new Object[]{method.getName(), e.getMessage(), e});
            throw e;
        }
    }

    private String argToString(Object arg) {
        if (arg == null) {
            return "(null)";
        }
        if (LOGGABLE_METADATA_TYPES.contains(arg.getClass())) {
            String oneLiner = arg.toString().stripTrailing().replaceAll(": ", " = ").replaceAll("\n", ", ");
            return arg.getClass().getSimpleName() + " (" + oneLiner + ")";
        }
        if (arg instanceof Message) {
            return String.format("(metadata %s)", arg.getClass().getSimpleName());
        }
        if (arg instanceof Collection) {
            return String.format("(collection %s, size=%d)", arg.getClass().getSimpleName(), ((Collection)arg).size());
        }
        return arg.toString();
    }

    private <T> CompletionStage<T> applyAsyncLogging(Method method, CompletionStage<T> asyncOperation) {
        return asyncOperation.thenApply(x -> {
            this.log.info("SUCCEEDED: {}", (Object)method.getName());
            return x;
        }).exceptionally(e -> {
            if (e instanceof CompletionException) {
                this.log.error("FAILED: {} {}", new Object[]{method.getName(), e.getCause().getMessage(), e.getCause()});
                throw (CompletionException)e;
            }
            this.log.error("FAILED: {} {}", new Object[]{method.getName(), e.getMessage(), e});
            throw new CompletionException((Throwable)e);
        });
    }
}

