/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.finos.tracdap.common.exception.EStartup;
import org.finos.tracdap.common.exception.ETracInternal;

public class VersionInfo {
    private static final String VERSION_INFO_PROPS = "version.properties";
    private static final String COMPONENT_NAME_KEY = "trac.component.name";
    private static final String COMPONENT_VERSION_KEY = "trac.component.version";
    private static final String UNPACKED_SUFFIX = " (Unpackaged)";

    public static String getComponentName(Class<?> component) {
        try {
            String packedName = component.getPackage().getImplementationTitle();
            if (packedName != null && !packedName.isBlank()) {
                return packedName;
            }
            return VersionInfo.readVersionInfo(component, COMPONENT_NAME_KEY);
        }
        catch (IOException e) {
            throw new EStartup("Error reading component version info", e);
        }
    }

    public static String getComponentVersion(Class<?> component) {
        try {
            String packedVersion = component.getPackage().getImplementationVersion();
            if (packedVersion != null && !packedVersion.isBlank()) {
                return packedVersion;
            }
            return VersionInfo.readVersionInfo(component, COMPONENT_VERSION_KEY) + UNPACKED_SUFFIX;
        }
        catch (IOException e) {
            throw new EStartup("Error reading component version info", e);
        }
    }

    private static String readVersionInfo(Class<?> component, String propKey) throws IOException {
        InputStream versionInfoStream = component.getClassLoader().getResourceAsStream(VERSION_INFO_PROPS);
        if (versionInfoStream == null) {
            throw new ETracInternal("Component version info not available");
        }
        Properties versionInfo = new Properties();
        versionInfo.load(versionInfoStream);
        String unpackedVersion = versionInfo.getProperty(propKey);
        if (unpackedVersion != null && !unpackedVersion.isBlank()) {
            return unpackedVersion;
        }
        throw new ETracInternal("Component version info not available");
    }
}

